/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.TripleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.CheckBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;

public class FinanceCorrectionDocumentsParametersPane
extends CardsContainer {
    private GridCell<DateValueWidget> dateCell;
    private GridCell<PriceValueWidget> totalCell;
    private GridCell<TripleValueWidget> useDelegateCell;
    private GridCell<TripleValueWidget> useFacsimileCell;
    private GridCell<EntityBoxWidget<Shipment>> shipmentCell;
    private TableWidgetController<TableWidget<ProductDataWrapper>, ProductDataWrapper> controller;
    private final List<ProductDataWrapper> wrappers = new ArrayList<ProductDataWrapper>();
    private final IntegerProperty selectedProductsCount = new SimpleIntegerProperty();
    private final ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper(false);
    private FinanceDocumentsParameters data;

    public FinanceCorrectionDocumentsParametersPane() {
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Card<Node> generalPane = this.createGeneralPane();
        Card<Node> productsPane = this.createProductsPane();
        this.getCards().addAll((Object[])new Card[]{generalPane, productsPane});
    }

    private Card<Node> createGeneralPane() {
        this.dateCell = new GridCell(Messages.Date, (Node)new DateValueWidget(false));
        this.totalCell = new GridCell(Messages.total, (Node)new PriceValueWidget(false));
        this.useDelegateCell = new GridCell(Messages.useDelegate, (Node)new TripleValueWidget(false, false));
        ((TripleValueWidget)this.useDelegateCell.getPayload()).setConverter(Converters.boolConverter((String)Messages.Yes, (String)Messages.No, (String)Messages.Auto));
        this.useFacsimileCell = new GridCell(Messages.useFacsimile, (Node)new TripleValueWidget(false, false));
        ((TripleValueWidget)this.useFacsimileCell.getPayload()).setConverter(Converters.boolConverter((String)Messages.Yes, (String)Messages.No, (String)Messages.Auto));
        this.shipmentCell = new GridCell(Messages.shipment, (Node)new EntityBoxWidget(Shipment.class, false));
        ((PriceValueWidget)this.totalCell.getPayload()).getViewState().setNotEditable(true);
        ((EntityBoxWidget)this.shipmentCell.getPayload()).setNoNulls(true);
        ((EntityBoxWidget)this.shipmentCell.getPayload()).setItemsSupplier(Collections::emptyList, false);
        ((EntityBoxWidget)this.shipmentCell.getPayload()).valueProperty().addListener((observable, oldValue, newValue) -> this.update((EntityReference<Shipment>)newValue, true));
        GridContainer pane = new GridContainer(5);
        pane.getCells().addAll((Object[])new GridCell[]{this.dateCell, this.totalCell, this.useDelegateCell, this.useFacsimileCell, this.shipmentCell});
        return new Card("parameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)pane);
    }

    private Card<Node> createProductsPane() {
        this.controller = new TableWidgetController<TableWidget<ProductDataWrapper>, ProductDataWrapper>(){
            private final TableWidget<ProductDataWrapper> view = new TableWidget(false);
            {
                this.view.setPlaceholder(Messages.No_data);
                this.view.setControlButtonsAvailability(ControlsPane.NONE);
            }

            public TableWidget<ProductDataWrapper> getView() {
                return this.view;
            }
        };
        ArrayList<Object> columns = new ArrayList<Object>();
        InfoWidgetColumn nameColumn = new InfoWidgetColumn(item -> BookingHelper.generateShortProductName((BaseProduct)item.data.getProduct()), (a, b) -> {});
        nameColumn.setCaption(Messages.Name);
        nameColumn.setId("name");
        columns.add(nameColumn);
        PriceValueWidgetColumn totalColumn = new PriceValueWidgetColumn(item -> item.data.getTotal(), (a, b) -> {});
        totalColumn.setCaption(Messages.total);
        totalColumn.setId("total");
        totalColumn.setNotEditable(Boolean.TRUE);
        columns.add(totalColumn);
        CheckBoxWidgetColumn selectedColumn = new CheckBoxWidgetColumn(item -> item.selected, (item, selected) -> {
            item.selected = selected;
        });
        selectedColumn.setCaption(Messages.includeToDocument);
        selectedColumn.setId("selected");
        columns.add(selectedColumn);
        ((TableWidget)this.controller.getView()).setColumns(columns);
        Card productsPane = new Card("products", UiCardsContainer.Style.STATIC, Messages.Products, this.controller.getView());
        productsPane.setAdaptiveHeight(true);
        return productsPane;
    }

    private void createBindings() {
        this.valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> ((DateValueWidget)this.dateCell.getPayload()).getValue() != null && this.selectedProductsCount.get() > 0 && ((EntityBoxWidget)this.shipmentCell.getPayload()).getValue() != null, (Observable[])new Observable[]{((DateValueWidget)this.dateCell.getPayload()).valueProperty(), this.selectedProductsCount, ((EntityBoxWidget)this.shipmentCell.getPayload()).valueProperty()}));
    }

    private void createListeners() {
        ((TableWidget)this.controller.getView()).setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int rowIndex = event.getRowIndex() != null ? event.getRowIndex() : 0;
                ProductDataWrapper wrapper = (ProductDataWrapper)((TableWidget)this.controller.getView()).getData(rowIndex);
                CheckBoxWidget checkBoxWidget = (CheckBoxWidget)((TableWidget)this.controller.getView()).getColumn("selected").getWidget(rowIndex);
                if (wrapper != null && checkBoxWidget != null) {
                    checkBoxWidget.selectedProperty().addListener((observable, oldValue, newValue) -> {
                        wrapper.selected = newValue;
                        this.update((EntityReference<Shipment>)((EntityBoxWidget)this.shipmentCell.getPayload()).getValue(), false);
                    });
                }
            }
        });
    }

    private void update(EntityReference<Shipment> shipment, boolean updateTable) {
        if (updateTable) {
            Set<NestedEntityReference<BookingFile, BaseProduct>> products = this.data.getProducts().get(shipment).keySet();
            this.controller.readData((Collection)this.wrappers.stream().filter(wrapper -> products.contains(wrapper.product)).collect(Collectors.toList()));
        }
        int rowsCount = ((TableWidget)this.controller.getView()).getRowsCount();
        CheckBoxWidgetColumn selectedColumn = (CheckBoxWidgetColumn)((TableWidget)this.controller.getView()).getColumn("selected");
        PriceValueWidgetColumn totalColumn = (PriceValueWidgetColumn)((TableWidget)this.controller.getView()).getColumn("total");
        this.selectedProductsCount.setValue((Number)IntStream.range(0, rowsCount).mapToObj(arg_0 -> ((CheckBoxWidgetColumn)selectedColumn).getWidget(arg_0)).filter(CheckBox::isSelected).count());
        ((PriceValueWidget)this.totalCell.getPayload()).setValue((Number)IntStream.range(0, rowsCount).mapToObj(arg_0 -> ((PriceValueWidgetColumn)totalColumn).getWidget(arg_0)).map(rec$ -> (BigDecimal)((PriceValueWidget)rec$).getValue()).reduce(null, (xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})));
    }

    public void readData(FinanceDocumentsParameters model) {
        this.data = model;
        ((DateValueWidget)this.dateCell.getPayload()).setValue(DateUtils.asLocalDate((Date)model.getDate()));
        ((TripleValueWidget)this.useDelegateCell.getPayload()).setValue(model.getUseDelegate());
        ((TripleValueWidget)this.useFacsimileCell.getPayload()).setValue(model.getUseFacsimile());
        ((EntityBoxWidget)this.shipmentCell.getPayload()).setValue(model.getShipment());
        this.wrappers.clear();
        for (Map<NestedEntityReference<BookingFile, BaseProduct>, MiscUtil.Pair<FinanceDocumentsHelper.FinanceDocumentProductData, Boolean>> shipmentData : model.getProducts().values()) {
            shipmentData.forEach((reference, productData) -> {
                ProductDataWrapper wrapper = new ProductDataWrapper();
                wrapper.product = reference;
                wrapper.data = (FinanceDocumentsHelper.FinanceDocumentProductData)productData.getFirst();
                wrapper.selected = (Boolean)productData.getSecond();
                this.wrappers.add(wrapper);
            });
        }
        ((EntityBoxWidget)this.shipmentCell.getPayload()).setItemsSupplier(() -> new ArrayList<EntityReference<Shipment>>(model.getProducts().keySet()), false);
        ((EntityBoxWidget)this.shipmentCell.getPayload()).setValue((EntityReference)CollectionUtil.head(model.getProducts().keySet()));
    }

    public void writeData(FinanceDocumentsParameters model) {
        this.data = model;
        model.setDate(DateUtils.asDate((LocalDate)((DateValueWidget)this.dateCell.getPayload()).getValue()));
        model.setUseDelegate(((TripleValueWidget)this.useDelegateCell.getPayload()).getValue());
        model.setUseFacsimile(((TripleValueWidget)this.useFacsimileCell.getPayload()).getValue());
        model.setShipment((EntityReference<Shipment>)((EntityBoxWidget)this.shipmentCell.getPayload()).getValue());
        model.getProducts().clear();
        ArrayList wrappers = new ArrayList();
        this.controller.writeData(wrappers);
        model.getProducts().put((EntityReference<Shipment>)((EntityBoxWidget)this.shipmentCell.getPayload()).getValue(), wrappers.stream().collect(Collectors.toMap(wrapper -> wrapper.product, wrapper -> new MiscUtil.Pair((Object)wrapper.data, (Object)wrapper.selected))));
    }

    public final ReadOnlyBooleanProperty validProperty() {
        return this.valid.getReadOnlyProperty();
    }

    private static class ProductDataWrapper {
        NestedEntityReference<BookingFile, BaseProduct> product;
        FinanceDocumentsHelper.FinanceDocumentProductData data;
        Boolean selected;

        private ProductDataWrapper() {
        }
    }

    public static class FinanceDocumentsParameters {
        private Date date;
        private Boolean useDelegate;
        private Boolean useFacsimile;
        private EntityReference<Shipment> shipment;
        private final Map<EntityReference<Shipment>, Map<NestedEntityReference<BookingFile, BaseProduct>, MiscUtil.Pair<FinanceDocumentsHelper.FinanceDocumentProductData, Boolean>>> products = new HashMap<EntityReference<Shipment>, Map<NestedEntityReference<BookingFile, BaseProduct>, MiscUtil.Pair<FinanceDocumentsHelper.FinanceDocumentProductData, Boolean>>>();

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Boolean getUseDelegate() {
            return this.useDelegate;
        }

        public void setUseDelegate(Boolean useDelegate) {
            this.useDelegate = useDelegate;
        }

        public Boolean getUseFacsimile() {
            return this.useFacsimile;
        }

        public void setUseFacsimile(Boolean useFacsimile) {
            this.useFacsimile = useFacsimile;
        }

        public EntityReference<Shipment> getShipment() {
            return this.shipment;
        }

        public void setShipment(EntityReference<Shipment> shipment) {
            this.shipment = shipment;
        }

        public Map<EntityReference<Shipment>, Map<NestedEntityReference<BookingFile, BaseProduct>, MiscUtil.Pair<FinanceDocumentsHelper.FinanceDocumentProductData, Boolean>>> getProducts() {
            return this.products;
        }
    }
}

