/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.TripleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.CheckBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;

public class FinanceDocumentsParametersPane
extends CardsContainer {
    private GridCell<DateValueWidget> dateCell;
    private GridCell<PriceValueWidget> totalRemainCell;
    private GridCell<TripleValueWidget> useDelegateCell;
    private GridCell<TripleValueWidget> useFacsimileCell;
    private GridCell<ComboBoxWidget<ContractType>> contractTypeCell;
    private TableWidgetController<TableWidget<ProductDataWrapper>, ProductDataWrapper> controller;
    private Button checkAllButton;
    private Button uncheckAllButton;
    private final List<ContractType> allowedContractTypes = new ArrayList<ContractType>();
    private final List<ProductDataWrapper> wrappers = new ArrayList<ProductDataWrapper>();
    private final IntegerProperty selectedProductsCount = new SimpleIntegerProperty();
    private final ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper(false);
    private FinanceDocumentsParameters data;
    private static final String BUTTON_CSS = "-fx-padding: 0.333333em 0.5em;-fx-min-width: 8em;-fx-background-color: -xtrip-controls-background;-fx-alignment: center;-fx-border-width: 1;-fx-border-radius: 3;-fx-border-color: derive(-fx-base, -35%);-fx-text-fill: -xtrip-control-button-color;-fx-font-weight: bold;-fx-effect: dropshadow(gaussian, -theme-common-button-shadow, 2, 0.0, 0, 1);-fx-background-insets: 0;-fx-cursor: hand;";

    public FinanceDocumentsParametersPane() {
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Card<Node> generalPane = this.createGeneralPane();
        Card<Node> productsPane = this.createProductsPane();
        this.getCards().addAll((Object[])new Card[]{generalPane, productsPane});
    }

    private Card<Node> createGeneralPane() {
        this.dateCell = new GridCell(Messages.Date, (Node)new DateValueWidget(false));
        this.totalRemainCell = new GridCell(Messages.totalToPay, (Node)new PriceValueWidget(false));
        this.useDelegateCell = new GridCell(Messages.useDelegate, (Node)new TripleValueWidget(false, false));
        ((TripleValueWidget)this.useDelegateCell.getPayload()).setConverter(Converters.boolConverter((String)Messages.Yes, (String)Messages.No, (String)Messages.Auto));
        this.useFacsimileCell = new GridCell(Messages.useFacsimile, (Node)new TripleValueWidget(false, false));
        ((TripleValueWidget)this.useFacsimileCell.getPayload()).setConverter(Converters.boolConverter((String)Messages.Yes, (String)Messages.No, (String)Messages.Auto));
        this.contractTypeCell = new GridCell(Messages.contractType, (Node)new ComboBoxWidget(false));
        ((PriceValueWidget)this.totalRemainCell.getPayload()).getViewState().setNotEditable(true);
        ((ComboBoxWidget)this.contractTypeCell.getPayload()).valueProperty().addListener((observable, oldValue, newValue) -> this.update((ContractType)newValue));
        GridContainer pane = new GridContainer(5);
        pane.getCells().addAll((Object[])new GridCell[]{this.dateCell, this.totalRemainCell, this.useDelegateCell, this.useFacsimileCell, this.contractTypeCell});
        Card generalPane = new Card("parameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)pane);
        return generalPane;
    }

    private Card<Node> createProductsPane() {
        GridContainer container = new GridContainer(1);
        this.controller = new TableWidgetController<TableWidget<ProductDataWrapper>, ProductDataWrapper>(){
            private final TableWidget<ProductDataWrapper> view = new TableWidget(false);
            {
                this.view.setPlaceholder(Messages.No_data);
                this.view.setControlButtonsAvailability(ControlsPane.NONE);
            }

            public TableWidget<ProductDataWrapper> getView() {
                return this.view;
            }
        };
        ArrayList<Object> columns = new ArrayList<Object>();
        InfoWidgetColumn nameColumn = new InfoWidgetColumn(item -> item.data.getProduct() != null ? BookingHelper.generateShortProductName((BaseProduct)item.data.getProduct()) : null, (a, b) -> {});
        nameColumn.setCaption(Messages.Name);
        nameColumn.setId("name");
        columns.add(nameColumn);
        PriceValueWidgetColumn remainColumn = new PriceValueWidgetColumn(item -> item.data.getRemain(), (a, b) -> {});
        remainColumn.setCaption(Messages.toPay);
        remainColumn.setId("remain");
        remainColumn.setNotEditable(Boolean.TRUE);
        columns.add(remainColumn);
        CheckBoxWidgetColumn selectedColumn = new CheckBoxWidgetColumn(item -> item.selected, (item, selected) -> {
            item.selected = selected;
        });
        selectedColumn.setCaption(Messages.includeToDocument);
        selectedColumn.setId("selected");
        columns.add(selectedColumn);
        ((TableWidget)this.controller.getView()).setColumns(columns);
        this.checkAllButton = new Button(Messages.Enable_all);
        this.checkAllButton.setStyle(BUTTON_CSS);
        this.checkAllButton.setOnAction(event -> {
            for (int i = 0; i < ((TableWidget)this.controller.getView()).getRowsData().size(); ++i) {
                ((CheckBoxWidget)selectedColumn.getWidget(i)).setSelected(true);
            }
        });
        this.checkAllButton.setDisable(true);
        this.uncheckAllButton = new Button(Messages.Disable_all);
        this.uncheckAllButton.setStyle(BUTTON_CSS);
        this.uncheckAllButton.setOnAction(event -> {
            for (int i = 0; i < ((TableWidget)this.controller.getView()).getRowsData().size(); ++i) {
                ((CheckBoxWidget)selectedColumn.getWidget(i)).setSelected(false);
            }
        });
        GridPane buttonsPane = new GridPane();
        buttonsPane.setAlignment(Pos.CENTER_RIGHT);
        buttonsPane.addRow(0, new Node[]{this.checkAllButton, this.uncheckAllButton});
        container.getCells().add((Object)new GridCell((Node)buttonsPane));
        container.getCells().add((Object)new GridCell(this.controller.getView()));
        Card productsPane = new Card("products", UiCardsContainer.Style.STATIC, Messages.Products, (Node)container);
        productsPane.setAdaptiveHeight(true);
        return productsPane;
    }

    private void createBindings() {
        this.valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> ((DateValueWidget)this.dateCell.getPayload()).getValue() != null && this.selectedProductsCount.get() > 0 && ((ComboBoxWidget)this.contractTypeCell.getPayload()).getValue() != null, (Observable[])new Observable[]{((DateValueWidget)this.dateCell.getPayload()).valueProperty(), this.selectedProductsCount, ((ComboBoxWidget)this.contractTypeCell.getPayload()).valueProperty()}));
    }

    private void createListeners() {
        ((TableWidget)this.controller.getView()).setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int rowIndex = event.getRowIndex() != null ? event.getRowIndex() : 0;
                ProductDataWrapper wrapper = (ProductDataWrapper)((TableWidget)this.controller.getView()).getData(rowIndex);
                Set wrappers = ((TableWidget)this.controller.getView()).getRowsData().stream().filter(item -> item.product != null && item.product.equals(wrapper.product)).collect(Collectors.toSet());
                CheckBoxWidget checkBoxWidget = (CheckBoxWidget)((TableWidget)this.controller.getView()).getColumn("selected").getWidget(rowIndex);
                if (wrapper != null && checkBoxWidget != null) {
                    checkBoxWidget.selectedProperty().addListener((observable, oldValue, newValue) -> {
                        this.selectedProductsCount.set(this.selectedProductsCount.get() + (newValue != false ? wrappers.size() : -wrappers.size()));
                        wrappers.forEach(item -> {
                            item.selected = newValue;
                        });
                        this.update((ContractType)((ComboBoxWidget)this.contractTypeCell.getPayload()).getValue());
                    });
                }
                this.checkAllButton.setDisable(((TableWidget)this.controller.getView()).getRowsData().stream().allMatch(item -> item.selected));
                this.uncheckAllButton.setDisable(((TableWidget)this.controller.getView()).getRowsData().stream().noneMatch(item -> item.selected));
            }
        });
    }

    private void update(ContractType contractType) {
        this.controller.readData((Collection)this.wrappers.stream().filter(wrapper -> wrapper.data.getContractType().equals((Object)contractType)).collect(Collectors.toList()));
        List availableContractTypes = this.wrappers.stream().map(wrapper -> wrapper.data.getContractType()).distinct().filter(this.allowedContractTypes::contains).collect(Collectors.toList());
        ((ComboBoxWidget)this.contractTypeCell.getPayload()).setItemsSupplier(() -> availableContractTypes);
        if (availableContractTypes.size() == 1) {
            ((ComboBoxWidget)this.contractTypeCell.getPayload()).setValue(availableContractTypes.get(0));
        }
        ((PriceValueWidget)this.totalRemainCell.getPayload()).setValue((Number)this.controller.getData().stream().filter(item -> item.selected).map(item -> item.data.getRemain()).reduce(null, (xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})));
        this.selectedProductsCount.setValue((Number)this.controller.getData().stream().filter(item -> item.selected).count());
    }

    public void readData(FinanceDocumentsParameters model) {
        this.data = model;
        ((DateValueWidget)this.dateCell.getPayload()).setValue(DateUtils.asLocalDate((Date)model.getDate()));
        ((TripleValueWidget)this.useDelegateCell.getPayload()).setValue(model.getUseDelegate());
        ((TripleValueWidget)this.useFacsimileCell.getPayload()).setValue(model.getUseFacsimile());
        this.allowedContractTypes.clear();
        this.allowedContractTypes.addAll(model.getAllowedContractTypes());
        this.wrappers.clear();
        HashSet foundContractTypes = new HashSet();
        for (Map.Entry<NestedEntityReference<BookingFile, BaseProduct>, Set<MiscUtil.Pair<FinanceDocumentsHelper.FinanceDocumentProductData, Boolean>>> product : model.getProducts().entrySet()) {
            product.getValue().forEach(item -> {
                ProductDataWrapper wrapper = new ProductDataWrapper();
                wrapper.product = (NestedEntityReference)product.getKey();
                wrapper.data = (FinanceDocumentsHelper.FinanceDocumentProductData)item.getFirst();
                foundContractTypes.add(((FinanceDocumentsHelper.FinanceDocumentProductData)item.getFirst()).getContractType());
                wrapper.selected = (Boolean)item.getSecond();
                this.wrappers.add(wrapper);
            });
        }
        this.allowedContractTypes.removeIf(type -> !foundContractTypes.contains(type));
        if (this.allowedContractTypes.contains(model.getContractType())) {
            ((ComboBoxWidget)this.contractTypeCell.getPayload()).setValue((Object)model.contractType);
        }
        this.update((ContractType)((ComboBoxWidget)this.contractTypeCell.getPayload()).getValue());
    }

    public void writeData(FinanceDocumentsParameters model) {
        this.data = model;
        model.setDate(DateUtils.asDate((LocalDate)((DateValueWidget)this.dateCell.getPayload()).getValue()));
        model.setUseDelegate(((TripleValueWidget)this.useDelegateCell.getPayload()).getValue());
        model.setUseFacsimile(((TripleValueWidget)this.useFacsimileCell.getPayload()).getValue());
        model.setContractType((ContractType)((ComboBoxWidget)this.contractTypeCell.getPayload()).getValue());
        model.getProducts().clear();
        ArrayList wrappers = new ArrayList();
        this.controller.writeData(wrappers);
        for (ProductDataWrapper wrapper : wrappers) {
            model.getProducts().computeIfAbsent(wrapper.product, item -> new HashSet()).add(new MiscUtil.Pair((Object)wrapper.data, (Object)wrapper.selected));
        }
    }

    public final ReadOnlyBooleanProperty validProperty() {
        return this.valid.getReadOnlyProperty();
    }

    private static class ProductDataWrapper {
        NestedEntityReference<BookingFile, BaseProduct> product;
        FinanceDocumentsHelper.FinanceDocumentProductData data;
        Boolean selected;

        private ProductDataWrapper() {
        }
    }

    public static class FinanceDocumentsParameters {
        private Date date;
        private Boolean useDelegate;
        private Boolean useFacsimile;
        private ContractType contractType;
        private final Set<ContractType> allowedContractTypes = new HashSet<ContractType>();
        private final Map<NestedEntityReference<BookingFile, BaseProduct>, Set<MiscUtil.Pair<FinanceDocumentsHelper.FinanceDocumentProductData, Boolean>>> products = new LinkedHashMap<NestedEntityReference<BookingFile, BaseProduct>, Set<MiscUtil.Pair<FinanceDocumentsHelper.FinanceDocumentProductData, Boolean>>>();

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Boolean getUseDelegate() {
            return this.useDelegate;
        }

        public void setUseDelegate(Boolean useDelegate) {
            this.useDelegate = useDelegate;
        }

        public Boolean getUseFacsimile() {
            return this.useFacsimile;
        }

        public void setUseFacsimile(Boolean useFacsimile) {
            this.useFacsimile = useFacsimile;
        }

        public ContractType getContractType() {
            return this.contractType;
        }

        public void setContractType(ContractType contractType) {
            this.contractType = contractType;
        }

        public Set<ContractType> getAllowedContractTypes() {
            return this.allowedContractTypes;
        }

        public Map<NestedEntityReference<BookingFile, BaseProduct>, Set<MiscUtil.Pair<FinanceDocumentsHelper.FinanceDocumentProductData, Boolean>>> getProducts() {
            return this.products;
        }
    }
}

