/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.CheckBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.ProductRefundCreditSlipResult;
import com.gridnine.xtrip.common.fx.rpc.ProductRefundCreditSlipService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.finance.CreditSlip;
import com.gridnine.xtrip.common.model.finance.CreditSlipType;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.TravellerHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.util.StringConverter;

public class ProductRefundCreditSlipDialog {
    private final Control source;
    private final Locale locale = LocaleManager.get().getCurrentLocale();
    private final TableWidget<ProductTableVM> productsWidget;
    private final ComboBoxWidget<Traveller> travellerNameWidget;
    private final ComboBoxWidget<Passport> passportWidget;
    private final TextFieldWidget personReceiverWidget;
    private final TextFieldWidget passportNumberWidget;
    private final DateValueWidget passportIssueDateWidget;
    private final TextFieldWidget passportIssuedByWidget;
    private final TextFieldWidget passportCitizenshipWidget;
    private final List<Traveller> travellers = new ArrayList<Traveller>();
    private final List<Passport> passports = new ArrayList<Passport>();
    private final Map<Map.Entry<BaseProduct, EntityContainer<BookingFile>>, Boolean> productSelected = new LinkedHashMap<Map.Entry<BaseProduct, EntityContainer<BookingFile>>, Boolean>();
    private final Map<BaseProduct, List<Traveller>> productTravellers = new LinkedHashMap<BaseProduct, List<Traveller>>();
    private final Map<Traveller, List<Passport>> travellerPassports = new HashMap<Traveller, List<Passport>>();
    private TableWidgetController<TableWidget<ProductTableVM>, ProductTableVM> productsController;

    public ProductRefundCreditSlipDialog(Control scr, Map<BaseProduct, EntityContainer<BookingFile>> productsMap) {
        this.source = scr;
        this.travellerNameWidget = new ComboBoxWidget(false);
        this.passportWidget = new ComboBoxWidget(false);
        this.personReceiverWidget = new TextFieldWidget(false);
        this.passportNumberWidget = new TextFieldWidget(false);
        this.passportIssueDateWidget = new DateValueWidget(false);
        this.passportIssuedByWidget = new TextFieldWidget(false);
        this.passportCitizenshipWidget = new TextFieldWidget(false);
        this.productsWidget = this.createProductsWidget();
        this.setStringConverters();
        this.productsController = new TableWidgetController<TableWidget<ProductTableVM>, ProductTableVM>(){

            public TableWidget<ProductTableVM> getView() {
                return ProductRefundCreditSlipDialog.this.productsWidget;
            }
        };
        this.productsWidget.setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int idx = event.getRowIndex();
                TableWidgetColumn checkWidget = this.productsWidget.getColumn("check");
                ((CheckBoxWidget)((CheckBoxWidgetColumn)checkWidget).getWidget(idx)).selectedProperty().addListener((val, oldVal, newVal) -> {
                    String uid = ((ProductTableVM)this.productsWidget.getData(idx)).getProductUID();
                    for (Map.Entry<Map.Entry<BaseProduct, EntityContainer<BookingFile>>, Boolean> entry : this.productSelected.entrySet()) {
                        if (!entry.getKey().getKey().getUid().equals(uid)) continue;
                        entry.setValue((Boolean)newVal);
                    }
                    this.updateTravellers();
                });
            }
        });
        HashMap<Map.Entry<BaseProduct, EntityContainer<BookingFile>>, Boolean> productsToProcess = new HashMap<Map.Entry<BaseProduct, EntityContainer<BookingFile>>, Boolean>();
        for (Map.Entry<BaseProduct, EntityContainer<BookingFile>> product : productsMap.entrySet()) {
            productsToProcess.put(product, Boolean.TRUE);
        }
        List<ProductTableVM> productsVM = this.configureProductTableVM(productsToProcess);
        this.productsController.readData(productsVM);
    }

    public void showDialog() {
        CardsContainer cardsContainer = this.createParametersCard();
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Parameters_for_the_formation_RKO).setAutoClose(false).setExpandToParent(true).setBody((Node)cardsContainer).setExpandToParent(false).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Form_RKO, () -> {
            if (this.travellerNameWidget.getValue() == null) {
                Dialog.info((String)Messages.Select_at_least_one_product_and_traveler);
                return;
            }
            EntityContainer<CreditSlip> creditSlipContainer = this.createCreditSlip();
            Notifications.get().submitTask(() -> {
                this.fillAmount(creditSlipContainer);
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                entityService.save(ServiceInvocationContext.get(), creditSlipContainer, null, true);
                RootEntityEditingService.get().open(creditSlipContainer.toReference(), true);
            }, Messages.Forming_RKO);
            dialog.close();
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)this.source);
    }

    private void fillAmount(EntityContainer<CreditSlip> creditSlipContainer) {
        CreditSlip creditSlip = (CreditSlip)creditSlipContainer.getEntity();
        ArrayList<Money> moneyList = new ArrayList<Money>();
        for (Map.Entry<Map.Entry<BaseProduct, EntityContainer<BookingFile>>, Boolean> entry : this.productSelected.entrySet()) {
            if (!Boolean.TRUE.equals(entry.getValue())) continue;
            try {
                BaseProduct product = entry.getKey().getKey();
                ProductRefundCreditSlipService service = (ProductRefundCreditSlipService)RpcServiceManager.get().getService(ProductRefundCreditSlipService.class);
                ProductRefundCreditSlipResult productRefundCreditSlipResult = service.loadDataForProductRefund(ServiceInvocationContext.get(), product);
                Money amount = productRefundCreditSlipResult.getAmount();
                if (amount == null) continue;
                moneyList.add(amount);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
        Money result = new Money();
        result.setValue(BigDecimal.ZERO);
        for (Money money : moneyList) {
            if (result.getValue() == null || money.getValue() == null) continue;
            result.setValue(result.getValue().add(money.getValue()));
            result.setCurrency(money.getCurrency());
        }
        creditSlip.setTotalAmount(result);
    }

    private EntityContainer<CreditSlip> createCreditSlip() {
        EntityContainer creditSlipContainer = new EntityContainer(CreditSlip.class);
        CreditSlip creditSlip = (CreditSlip)creditSlipContainer.getEntity();
        creditSlip.setType(CreditSlipType.CUSTOMER);
        creditSlip.setDate(new Date());
        creditSlip.setPersonName(this.personReceiverWidget.getValue() != null ? this.personReceiverWidget.getValue() : "");
        StringBuilder title = new StringBuilder();
        StringBuilder reason = new StringBuilder();
        for (Map.Entry<Map.Entry<BaseProduct, EntityContainer<BookingFile>>, Boolean> entry : this.productSelected.entrySet()) {
            String numbers;
            ProductHandler handler;
            if (!Boolean.TRUE.equals(entry.getValue())) continue;
            BaseProduct product = entry.getKey().getKey();
            EntityReference bfRef = (EntityReference)MiscUtil.safeGet(entry.getKey().getValue(), EntityContainer::toReference);
            if (bfRef != null && !creditSlip.getOwners().contains(bfRef)) {
                creditSlip.getOwners().add(bfRef);
            }
            if ((handler = HandlersRegistry.get().findProductHandler(product.getClass())).getStatus(product) != ProductStatus.REFUND || handler.getProductCategory(product) == ProductCategory.MCO) continue;
            if (title.length() > 0) {
                title.append(", ");
            }
            title.append(handler.generateShortProductName(product));
            if (reason.length() > 0) {
                reason.append(", ");
            } else {
                reason.append(Messages.Refund_of_value);
                reason.append(" ");
            }
            if (product instanceof UniversalProduct) {
                reason.append(handler.getUniversalProductDescription(product));
            } else {
                reason.append(handler.getProductType(product));
            }
            if (!TextUtil.isBlank((String)handler.getCarrierNumber(product))) {
                if (reason.length() > 0) {
                    reason.append(" ");
                }
                reason.append(handler.getCarrierNumber(product));
            }
            if (TextUtil.isBlank((String)(numbers = String.join((CharSequence)" ", handler.getProductNumbers(product))))) continue;
            if (reason.length() > 0) {
                reason.append(" ");
            }
            reason.append(numbers);
        }
        creditSlip.setName(L10n.replace((String)Messages.RKO_on, (Object[])new Object[]{title.toString()}));
        creditSlip.setPersonReason(reason.toString());
        if (this.travellerNameWidget.getValue() != null) {
            creditSlip.setPerson(((Traveller)this.travellerNameWidget.getValue()).getPassenger());
        }
        StringBuilder document = new StringBuilder();
        if (this.passportWidget.getValue() != null && ((Passport)this.passportWidget.getValue()).getType() != null) {
            if (document.length() > 0) {
                document.append(", ");
            }
            document.append(((Passport)this.passportWidget.getValue()).getType().toString());
        }
        if (this.passportNumberWidget.getValue() != null) {
            if (document.length() > 0) {
                document.append(", ");
            }
            document.append(this.passportNumberWidget.getValue());
        }
        if (this.passportIssuedByWidget.getValue() != null) {
            if (document.length() > 0) {
                document.append(" ");
            }
            document.append(Messages.Issued).append(this.passportIssuedByWidget.getValue());
        }
        if (this.passportIssueDateWidget.getValue() != null) {
            if (document.length() > 0) {
                document.append(", ");
            }
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            document.append(format.format(DateUtils.asDate((LocalDate)this.passportIssueDateWidget.getValue())));
        }
        creditSlip.setPersonDocument(document.toString());
        return creditSlipContainer;
    }

    private List<ProductTableVM> configureProductTableVM(Map<Map.Entry<BaseProduct, EntityContainer<BookingFile>>, Boolean> products) {
        return products.entrySet().stream().map(item -> {
            BaseProduct baseProduct = (BaseProduct)((Map.Entry)item.getKey()).getKey();
            boolean selected = (Boolean)item.getValue();
            this.productSelected.put((Map.Entry<BaseProduct, EntityContainer<BookingFile>>)item.getKey(), selected);
            ProductTableVM productVM = new ProductTableVM();
            productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)baseProduct));
            productVM.setProductUID(baseProduct.getUid());
            productVM.setChecked(true);
            ProductHandler handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            ArrayList<Traveller> entryTravellers = new ArrayList<Traveller>();
            Collection entryTravellersCollection = handler.getTravellers(baseProduct);
            if (entryTravellersCollection != null) {
                for (Traveller traveller : entryTravellersCollection) {
                    Passport travellerPassport;
                    ArrayList<Passport> entryTravellerPassports = new ArrayList<Passport>();
                    if (!entryTravellers.contains(traveller)) {
                        entryTravellers.add(traveller);
                    }
                    if ((travellerPassport = traveller.getPassport()) != null) {
                        entryTravellerPassports.add(travellerPassport);
                    }
                    Notifications.get().submitTask(() -> {
                        ServiceInvocationContext ctx = ServiceInvocationContext.get();
                        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                        EntityContainer personContainer = entityService.load(ctx, traveller.getPassenger());
                        if (personContainer != null) {
                            Person person = (Person)personContainer.getEntity();
                            List personPassports = person.getPassports();
                            for (Passport personPassport : personPassports) {
                                if (personPassport == null || CollectionUtil.contains((Collection)entryTravellerPassports, (Object)personPassport, TravellerHelper::equals)) continue;
                                entryTravellerPassports.add(personPassport);
                            }
                        }
                        if (entryTravellerPassports.size() > 0) {
                            entryTravellerPassports.sort((p1, p2) -> {
                                if (PassportType.INTERNAL.equals((Object)p1.getType()) && !PassportType.INTERNAL.equals((Object)p2.getType())) {
                                    return -1;
                                }
                                if (PassportType.INTERNAL.equals((Object)p2.getType()) && !PassportType.INTERNAL.equals((Object)p1.getType())) {
                                    return 1;
                                }
                                if (PassportType.PASSPORT.equals((Object)p1.getType()) && !PassportType.PASSPORT.equals((Object)p2.getType())) {
                                    return -1;
                                }
                                if (PassportType.PASSPORT.equals((Object)p2.getType()) && !PassportType.PASSPORT.equals((Object)p1.getType())) {
                                    return 1;
                                }
                                if (PassportType.FOREIGN.equals((Object)p1.getType()) && !PassportType.FOREIGN.equals((Object)p2.getType())) {
                                    return -1;
                                }
                                if (PassportType.FOREIGN.equals((Object)p2.getType()) && !PassportType.FOREIGN.equals((Object)p1.getType())) {
                                    return 1;
                                }
                                return 0;
                            });
                            this.travellerPassports.put(traveller, entryTravellerPassports);
                        }
                        this.productTravellers.put(baseProduct, entryTravellers);
                        FxUtil.waitForFxThread(this::updateTravellers);
                    }, Messages.Receiving_data);
                }
            }
            return productVM;
        }).collect(Collectors.toList());
    }

    private void setEmptyValuePassportsWidgets() {
        this.travellerNameWidget.setValue(null);
        this.passportWidget.setItemsSupplier(null);
        this.passportWidget.setValue(null);
        this.personReceiverWidget.setValue(null);
        this.passportNumberWidget.setValue(null);
        this.passportIssueDateWidget.setValue(null);
        this.passportIssuedByWidget.setValue(null);
        this.passportCitizenshipWidget.setValue(null);
    }

    private void setStringConverters() {
        this.travellerNameWidget.setConverter((StringConverter)new StringConverter<Traveller>(){

            public String toString(Traveller object) {
                return object.getName() != null ? object.getName() : Messages.No_Name_specified;
            }

            public Traveller fromString(String string) {
                return null;
            }
        });
        this.passportWidget.setConverter((StringConverter)new StringConverter<Passport>(){

            public String toString(Passport object) {
                PassportType passportType = object.getType() != null ? object.getType() : PassportType.OTHER;
                String passportNumber = object.getNumber();
                return (passportType.toString(ProductRefundCreditSlipDialog.this.locale) + " " + passportNumber).trim();
            }

            public Passport fromString(String string) {
                return null;
            }
        });
    }

    private void updateTravellers() {
        this.travellers.clear();
        for (Map.Entry<Map.Entry<BaseProduct, EntityContainer<BookingFile>>, Boolean> entry : this.productSelected.entrySet()) {
            List<Traveller> entryTravellers;
            if (!Boolean.TRUE.equals(entry.getValue()) || (entryTravellers = this.productTravellers.get(entry.getKey().getKey())) == null) continue;
            for (Traveller traveller : entryTravellers) {
                if (this.travellers.contains(traveller)) continue;
                this.travellers.add(traveller);
            }
        }
        this.travellerNameWidget.setLive(true);
        if (!this.travellers.isEmpty()) {
            this.travellerNameWidget.setItemsSupplier(() -> this.travellers);
            this.travellerNameWidget.setValue((Object)this.travellers.get(0));
            this.updatePassports(this.travellers.get(0));
        } else {
            this.travellerNameWidget.setItemsSupplier(null);
            this.setEmptyValuePassportsWidgets();
        }
        this.travellerNameWidget.valueProperty().addListener((val, oldVal, newVal) -> {
            if (newVal == null) {
                this.passportWidget.setItemsSupplier(null);
                this.setEmptyValuePassportsWidgets();
            } else {
                this.updatePassports((Traveller)newVal);
            }
        });
    }

    private void updatePassports(Traveller traveller) {
        List<Passport> personPassports;
        this.passports.clear();
        if (traveller != null && (personPassports = this.travellerPassports.get(traveller)) != null) {
            this.passports.addAll(personPassports);
        }
        this.passportWidget.setNoNulls(true);
        this.passportWidget.setLive(true);
        this.passportWidget.valueProperty().addListener((val, oldVal, newVal) -> this.updatePersonPassport(traveller, (Passport)newVal));
        if (this.passports.size() > 0) {
            this.passportWidget.setItemsSupplier(() -> this.passports);
            this.passportWidget.setValue(((List)this.passportWidget.getItemsSupplier().get()).get(0));
        } else {
            this.passportWidget.setItemsSupplier(null);
            this.passportWidget.setValue(null);
        }
    }

    private void updatePersonPassport(Traveller traveller, Passport passport) {
        if (passport != null) {
            this.personReceiverWidget.setValue(String.format("%s %s %s %s", passport.getSecondName() != null ? passport.getSecondName() : "", passport.getLastName() != null ? passport.getLastName() : "", passport.getFirstName() != null ? passport.getFirstName() : "", passport.getMiddleName() != null ? passport.getMiddleName() : "").trim());
            this.passportNumberWidget.setValue(passport.getNumber());
            this.passportIssueDateWidget.setValue(DateUtils.asLocalDate((Date)passport.getIssued()));
            this.passportIssuedByWidget.setValue(passport.getIssueOrganization());
            if (passport.getCitizenship() != null) {
                this.passportCitizenshipWidget.setValue(passport.getCitizenship().toString(this.locale));
            }
        }
        if (traveller != null && TextUtil.isBlank((String)this.personReceiverWidget.getValue())) {
            if (!TextUtil.isBlank((String)traveller.getCyrillicName())) {
                this.personReceiverWidget.setValue(traveller.getCyrillicName().trim());
            } else if (!TextUtil.isBlank((String)traveller.getName())) {
                this.personReceiverWidget.setValue(traveller.getName().trim());
            }
        }
    }

    private CardsContainer createParametersCard() {
        GridContainer productContainer = new GridContainer();
        productContainer.getCells().add((Object)new GridCell("", this.productsWidget));
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("products", UiCardsContainer.Style.STATIC, Messages.Products, (Node)productContainer));
        cardsContainer.getCards().add((Object)new Card("travellers", UiCardsContainer.Style.STATIC, Messages.Name_Travelers, (Node)this.createTravellersContainer()));
        return cardsContainer;
    }

    private TableWidget<ProductTableVM> createProductsWidget() {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<InfoWidgetColumn> columns = new ArrayList<InfoWidgetColumn>();
        InfoWidgetColumn column = new InfoWidgetColumn(ProductTableVM::getProduct, ProductTableVM::setProduct);
        column.setId("product");
        column.setCaption(Messages.Name);
        columns.add(column);
        column = new CheckBoxWidgetColumn(ProductTableVM::isChecked, ProductTableVM::setChecked);
        column.setId("check");
        column.setCaption(Messages.Add_in_RKO);
        column.setNotHGrowable(true);
        column.setPrefWidth(Double.valueOf(880.0));
        columns.add(column);
        widget.setColumns(columns);
        return widget;
    }

    private GridContainer createTravellersContainer() {
        GridContainer gridContainer = new GridContainer(4);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(this.travellerNameWidget);
        cell.setCaption(Messages.Traveler);
        cells.add(cell);
        cell = new GridCell(this.passportWidget);
        cell.setCaption(Messages.Passport);
        cells.add(cell);
        cell = new GridCell((Node)this.personReceiverWidget);
        cell.setCaption(Messages.Issue);
        cells.add(cell);
        cell = new GridCell((Node)this.passportNumberWidget);
        cell.setCaption(Messages.Number);
        cells.add(cell);
        cell = new GridCell((Node)this.passportIssueDateWidget);
        cell.setCaption(Messages.Date_of_issue);
        cells.add(cell);
        cell = new GridCell((Node)this.passportIssuedByWidget);
        cell.setCaption(Messages.Issued_by);
        cells.add(cell);
        cell = new GridCell((Node)this.passportCitizenshipWidget);
        cell.setCaption(Messages.Country_Nationality);
        cells.add(cell);
        gridContainer.getCells().addAll(cells);
        return gridContainer;
    }

    public static class ProductTableVM {
        private String product;
        private String productUID;
        private boolean checked;

        public String getProduct() {
            return this.product;
        }

        public void setProduct(String product) {
            this.product = product;
        }

        public String getProductUID() {
            return this.productUID;
        }

        public void setProductUID(String productUID) {
            this.productUID = productUID;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }
    }
}

