/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.booking.PayDialogFOPVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ProductClientFOPDialog;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ProductRefusePayClientFOPDialog
extends ProductClientFOPDialog {
    public ProductRefusePayClientFOPDialog(String selectedProductUid, EntityReference<BookingFile> bookingFileEntityReference) {
        super(Collections.singletonMap(bookingFileEntityReference, Collections.singletonList(selectedProductUid)), false);
    }

    @Override
    protected String getAcceptButtonCaption() {
        return Messages.Refuse;
    }

    @Override
    protected void saturateTableWidget(List<ProductClientFOPDialog.ProductFop> fops, boolean haveProductColumn) {
        TableWidget tableWidget = (TableWidget)this.tableWidgetController.getView();
        tableWidget.getColumn("check").setCaption(Messages.Refuse);
        if (!haveProductColumn) {
            tableWidget.hideColumn(tableWidget.getColumn("productName"));
        }
        tableWidget.hideColumn(tableWidget.getColumn("uid"));
        this.tableWidgetController.readData(fops.stream().map(fop -> {
            PayDialogFOPVM fopVM = new PayDialogFOPVM();
            fopVM.setPaymentType(fop.getFop().getType().toString());
            BigDecimal equivalentAmount = fop.getFop().getEquivalentAmount();
            BigDecimal equivalentAmountNegate = equivalentAmount.negate();
            fopVM.setProductName(fop.getProductName());
            fopVM.setSum(fop.isRefundOrExchange() ? equivalentAmountNegate : equivalentAmount);
            fopVM.setPayment(fop.isRefundOrExchange() ? equivalentAmountNegate : equivalentAmount);
            fopVM.setDate(LocalDateTime.now());
            fopVM.setAgent(Prefetched.getData().getCurrentAgentData().getAgent());
            fopVM.setCheck(true);
            fopVM.setUid(fop.getFop().getUid());
            return fopVM;
        }).collect(Collectors.toList()));
    }

    @Override
    protected void updateSourceFop(GeneralProductFop sourceFop, ProductClientFOPDialog.PayDialogFOP selectedFop, boolean refundOrExchange) {
        BigDecimal value = (BigDecimal)selectedFop.paymentWidget.getValue();
        sourceFop.setEquivalentAmount(refundOrExchange ? value.negate() : value);
        sourceFop.setAgent(selectedFop.agentWidget.getValue());
        sourceFop.setOperationDate(DateUtils.asDate((LocalDateTime)selectedFop.dateWidget.getValue()));
        sourceFop.setRefused(true);
    }

    @Override
    Collection<? extends String> performExtraChecks(List<ProductClientFOPDialog.PayDialogFOP> selectedFops) {
        ArrayList<String> result = new ArrayList<String>();
        if (selectedFops.stream().anyMatch(payDialogFOP -> {
            EntityReference agent = payDialogFOP.agentWidget.getValue();
            return agent == null;
        })) {
            result.add(Messages.No_Agent_Specified);
        }
        return result;
    }

    @Override
    String getCardCaption() {
        return Messages.Refuse_Payment;
    }

    @Override
    String getNothingToDoMessage() {
        return Messages.Unpaid_forms_of_payment_not_found;
    }

    @Override
    boolean isPaymentStatusAppropriate(GeneralProductFop generalProductFop) {
        return generalProductFop.getEquivalentAmount() != null && generalProductFop.getOperationDate() == null;
    }
}

