/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.worklog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.registry.basic.AppStopHook;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.PrefetchedHelper;
import com.gridnine.xtrip.client.fx.standard.worklog.WorklogFxHelper;
import com.gridnine.xtrip.client.fx.standard.worklog.Workplace;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.Worklog;

public class WorklogAppStopHook
implements AppStopHook {
    public String getId() {
        return "worklog-close";
    }

    public double getWeight() {
        return 50.0;
    }

    public void shutdownRequested(AppStopHook.ShutdownCallback callback) {
        if (!Workplace.get().isWorklogOpen()) {
            PrefetchedHelper.saveAgentSalesPoint();
            callback.accept(true);
            return;
        }
        Notifications.get().submitTask(() -> {
            EntityReference<Worklog> worklogRef = WorklogFxHelper.getWorklog();
            if (worklogRef != null) {
                FxUtil.submitToFxThread(() -> new Dialog().setTitle(Messages.Closing_worklog).setMessage(Messages.Worklog_close_message).addButton(DialogButtonStyle.DECLINE, () -> callback.accept(false)).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Close_without_close_worklog, () -> callback.accept(true)).addButton(DialogButtonStyle.AUXILARY, Messages.Close_worklog_and_quit, () -> Notifications.get().submitTask(() -> {
                    WorklogFxHelper.closeWorklog(worklogRef);
                    callback.accept(true);
                }, Messages.Closing_worklog2)).setOnCloseRequest(() -> callback.accept(false)).showGlobal());
            } else {
                callback.accept(true);
            }
        }, Messages.Closing_worklog2);
    }
}

