/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.worklog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.registry.basic.MainTool;
import com.gridnine.xtrip.client.fx.core.service.WindowTitleService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.worklog.WorklogFxHelper;
import com.gridnine.xtrip.client.fx.standard.worklog.Workplace;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.Worklog;

public class WorklogTool
implements MainTool {
    public String getId() {
        return "main-tool-worklog";
    }

    public double getWeight() {
        return 100.0;
    }

    public String getShape() {
        return "M12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22C6.47,22 2,17.5 2,12A10,10 0 0,1 12,2M12.5,7V12.25L17,14.92L16.25,16.15L11,13V7H12.5Z";
    }

    public AclQuery getACLQuery() {
        return null;
    }

    public boolean isAvailable() {
        return Workplace.get().isWorklogEnabled() && Workplace.get().isWorklogOpen();
    }

    public void execute() {
        if (!Workplace.get().isWorklogOpen()) {
            Notifications.get().showFlashNotification(Messages.Worklog_isnt_open, null);
            return;
        }
        Notifications.get().submitTask(() -> {
            EntityReference<Worklog> worklogRef = WorklogFxHelper.getWorklog();
            if (worklogRef != null) {
                FxUtil.submitToFxThread(() -> new Dialog().setTitle(Messages.Closing_worklog).setMessage(Messages.Worklog_close_message_action).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Close_worklog, () -> Notifications.get().submitTask(() -> {
                    WorklogFxHelper.closeWorklog(worklogRef);
                    WindowTitleService.get().setStartDate(null);
                    Notifications.get().showFlashNotification(Messages.Worklog_closed, null);
                }, Messages.Closing_worklog2)).showGlobal());
            } else {
                Notifications.get().showFlashNotification(Messages.Worklog_not_found, null);
            }
        }, Messages.Closing_worklog2);
    }
}

