/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.workspace;

import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.assets.AssetHandler;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPane;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomDndTreeView;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomTreeView;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolEditor;
import com.gridnine.xtrip.client.fx.core.ui.navigation.WorkspaceHelper;
import com.gridnine.xtrip.client.fx.core.ui.navigation.WorkspaceModificationEvent;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.workspace.CommonNavToolParametersEditor;
import com.gridnine.xtrip.client.fx.standard.workspace.EmptyNavToolParametersEditor;
import com.gridnine.xtrip.client.fx.standard.workspace.WorkspaceManagerPane;
import com.gridnine.xtrip.client.fx.standard.workspace.event.WorkspaceItemChangedEvent;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.assets.FxWorkspace;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.fx.rpc.WorkspaceService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclPrincipal;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;

public class WorkspaceEditorPane
extends StackPane
implements DevTool {
    private CustomDndTreeView<FxWorkspaceItem> tree;
    private CardsContainer treePane;
    private CardsContainer parametersPane;
    private final Card<EmptyNavToolParametersEditor> emptyEditorCard;
    private final Card<CommonNavToolParametersEditor> commonEditorCard;
    private TreeItem<FxWorkspaceItem> selectedItem;
    private final List<MiscUtil.Pair<NavToolEditor, Card<Node>>> selectedItemEditors = new ArrayList<MiscUtil.Pair<NavToolEditor, Card<Node>>>();
    private final Map<String, List<MiscUtil.Pair<NavToolEditor, Card<Node>>>> cache = new HashMap<String, List<MiscUtil.Pair<NavToolEditor, Card<Node>>>>();
    private final WorkspaceManagerPane managerPane;
    private FxWorkspace workspace;
    private final Consumer<WorkspaceItemChangedEvent> workspaceItemChangeListener;
    private boolean changed;
    private boolean populating;
    private String workspaceOwner;
    private String workspaceUid;

    private static <T> TreeItem<T> findItem(TreeItem<T> item, Predicate<T> predicate) {
        if (predicate.test(item.getValue())) {
            return item;
        }
        for (TreeItem subItem : item.getChildren()) {
            TreeItem<T> result = WorkspaceEditorPane.findItem(subItem, predicate);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    WorkspaceEditorPane(WorkspaceManagerPane wmp) {
        this.managerPane = wmp;
        this.emptyEditorCard = new Card("stub", UiCardsContainer.Style.STATIC, null, (Node)new EmptyNavToolParametersEditor());
        this.commonEditorCard = new Card("commonParameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)new CommonNavToolParametersEditor());
        this.createGUI();
        this.workspaceItemChangeListener = value -> {
            if (this.populating) {
                return;
            }
            if (this.selectedItem != null) {
                if (value.getChangeType() == WorkspaceItemChangedEvent.ChangeType.NAME) {
                    if (this.selectedItem.getParent() == null) {
                        this.managerPane.setCaption(((FxWorkspaceItem)this.selectedItem.getValue()).getName() + " " + "\u2014" + " " + this.workspaceOwner);
                    }
                    this.tree.refresh();
                } else if (value.getChangeType() == WorkspaceItemChangedEvent.ChangeType.TYPE) {
                    this.select();
                    this.read();
                } else if (value.getChangeType() == WorkspaceItemChangedEvent.ChangeType.PARAMETERS) {
                    this.read();
                }
                this.changed = true;
            }
        };
        EventBus.get().subscribe(WorkspaceItemChangedEvent.TYPE, this.workspaceItemChangeListener);
        this.tree.getSelectionModel().selectedItemProperty().addListener(observable -> {
            this.check();
            this.write();
            this.selectedItem = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
            this.select();
            this.read();
            this.managerPane.revalidate();
        });
        Notifications.get().submitTask(() -> {
            this.workspace = WorkspaceHelper.loadWorkspace();
            this.workspaceOwner = this.workspace.getOwner();
            this.workspaceUid = this.workspace.getUid();
            this.populate(true);
        }, wmp.getMutex());
    }

    private void createGUI() {
        this.tree = new CustomDndTreeView();
        this.tree.setShowRoot(true);
        this.tree.setConverter((StringConverter)new StringConverter<FxWorkspaceItem>(){

            public String toString(FxWorkspaceItem object) {
                return object.getName();
            }

            public FxWorkspaceItem fromString(String string) {
                return null;
            }
        });
        this.tree.setIconSupplier(item -> {
            if (((FxWorkspaceItem)item.getValue()).getToolId() != null) {
                NavTool tool = NavTool.forId((String)((FxWorkspaceItem)item.getValue()).getToolId());
                return tool.getShape(item.isLeaf());
            }
            return StandardIconShapes.UNDEFINED;
        });
        this.tree.getControlButtons().add(new CustomTreeView.ControlButton<FxWorkspaceItem>(){

            public IconShape getIconShape() {
                return StandardIconShapes.MOVE_DOWN_14X14;
            }

            public IconIntention getIconIntention() {
                return StandardIconIntentions.TREE_CELL_BUTTON_MOVE;
            }

            public String getDescription() {
                return Messages.Downward;
            }

            public boolean isAvailable(TreeItem<FxWorkspaceItem> item) {
                return item.getParent() != null;
            }

            public boolean isEnabled(TreeItem<FxWorkspaceItem> item) {
                return item.nextSibling() != null;
            }

            public void onAction(TreeItem<FxWorkspaceItem> item) {
                WorkspaceEditorPane.this.moveTreeItem(item, true);
            }
        });
        this.tree.getControlButtons().add(new CustomTreeView.ControlButton<FxWorkspaceItem>(){

            public IconShape getIconShape() {
                return StandardIconShapes.MOVE_UP_14X14;
            }

            public IconIntention getIconIntention() {
                return StandardIconIntentions.TREE_CELL_BUTTON_MOVE;
            }

            public String getDescription() {
                return Messages.Upward;
            }

            public boolean isAvailable(TreeItem<FxWorkspaceItem> item) {
                return item.getParent() != null;
            }

            public boolean isEnabled(TreeItem<FxWorkspaceItem> item) {
                return item.previousSibling() != null;
            }

            public void onAction(TreeItem<FxWorkspaceItem> item) {
                WorkspaceEditorPane.this.moveTreeItem(item, false);
            }
        });
        this.tree.getControlButtons().add(new CustomTreeView.ControlButton<FxWorkspaceItem>(){

            public IconShape getIconShape() {
                return StandardIconShapes.REMOVE_14X14;
            }

            public IconIntention getIconIntention() {
                return StandardIconIntentions.TREE_CELL_BUTTON_ACTION;
            }

            public String getDescription() {
                return Messages.Delete;
            }

            public boolean isAvailable(TreeItem<FxWorkspaceItem> item) {
                return item.getParent() != null;
            }

            public boolean isEnabled(TreeItem<FxWorkspaceItem> item) {
                return true;
            }

            public void onAction(TreeItem<FxWorkspaceItem> item) {
                WorkspaceEditorPane.this.removeTreeItem(item);
            }
        });
        this.tree.getControlButtons().add(new CustomTreeView.ControlButton<FxWorkspaceItem>(){

            public IconShape getIconShape() {
                return StandardIconShapes.ADD_14X14;
            }

            public IconIntention getIconIntention() {
                return StandardIconIntentions.TREE_CELL_BUTTON_ACTION;
            }

            public String getDescription() {
                return Messages.To_Create;
            }

            public boolean isAvailable(TreeItem<FxWorkspaceItem> item) {
                return true;
            }

            public boolean isEnabled(TreeItem<FxWorkspaceItem> item) {
                return true;
            }

            public void onAction(TreeItem<FxWorkspaceItem> item) {
                WorkspaceEditorPane.this.addTreeItem(item, WorkspaceEditorPane.this.createTreeItem(), 0);
            }
        });
        this.tree.setDropPolicy(CustomDndTreeView.DropPolicy.CLASSIC);
        this.tree.setTransferModes(TransferMode.COPY_OR_MOVE);
        this.tree.setRenderer(item -> item.getValue() != null ? ((FxWorkspaceItem)item.getValue()).getName() : null);
        this.tree.setDragLeafChecker((source, mode) -> false);
        this.tree.setDragDetectChecker((source, mode) -> true);
        this.tree.setDragOverChecker((source, target, value, mode, type, location) -> true);
        this.tree.setDragDropHandler((source, target, value, mode, type, location) -> {
            if (target != null) {
                if (source == null) {
                    // empty if block
                }
                if (source != null) {
                    if (mode == TransferMode.MOVE) {
                        this.removeTreeItem(source);
                    }
                    TreeItem<FxWorkspaceItem> child = null;
                    if (mode == TransferMode.MOVE) {
                        child = source;
                    } else if (mode == TransferMode.COPY) {
                        child = this.cloneTreeItem(source);
                    }
                    if (child != null) {
                        if (type == CustomDndTreeView.DropType.SIBLING) {
                            TreeItem parent = target.getParent();
                            if (parent != null) {
                                int index = parent.getChildren().indexOf((Object)target);
                                if (location == CustomDndTreeView.DropLocation.ABOVE) {
                                    this.addTreeItem((TreeItem<FxWorkspaceItem>)parent, child, index);
                                } else if (location == CustomDndTreeView.DropLocation.BELOW) {
                                    this.addTreeItem((TreeItem<FxWorkspaceItem>)parent, child, index + 1);
                                }
                            }
                        } else if (type == CustomDndTreeView.DropType.CHILD) {
                            this.addTreeItem((TreeItem<FxWorkspaceItem>)target, child, 0);
                        }
                    }
                }
            }
        });
        this.treePane = new CardsContainer();
        this.treePane.getStyleClass().add((Object)"tree-pane");
        Card card = new Card("tree", UiCardsContainer.Style.STATIC, Messages.Folders_and_Lists, (Node)new StackPane(new Node[]{this.tree}));
        card.setAdaptiveHeight(true);
        this.treePane.getCards().add((Object)card);
        this.parametersPane = new CardsContainer();
        this.parametersPane.getStyleClass().add((Object)"parameters-panel");
        this.parametersPane.getCards().add(this.emptyEditorCard);
        GridPane workspacePane = new GridPane();
        UiUtil.gridPosition((GridPane)workspacePane, (Node)this.treePane).col(0).row(0).hGrow(Priority.NEVER).vGrow(Priority.ALWAYS).place();
        UiUtil.gridPosition((GridPane)workspacePane, (Node)this.parametersPane).col(1).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        this.getChildren().setAll((Object[])new Node[]{workspacePane});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate(boolean initial) throws Exception {
        this.populating = true;
        try {
            FxWorkspaceItem rootWorkspaceItem = new FxWorkspaceItem();
            rootWorkspaceItem.setName(this.workspace.getName());
            rootWorkspaceItem.setToolId("folder-nav-tool");
            rootWorkspaceItem.getSubItems().addAll(this.workspace.getItems());
            TreeItem root = new TreeItem((Object)rootWorkspaceItem);
            root.addEventHandler(TreeItem.branchCollapsedEvent(), evt -> UiUtil.collapse((TreeItem)evt.getTreeItem()));
            this.populate((TreeItem<FxWorkspaceItem>)root);
            ValueHolder item = new ValueHolder();
            if (initial) {
                List history = ActivityManager.get().getSelectionHistory();
                for (int i = history.size() - 1; i >= 0; --i) {
                    if (!TextUtil.isSame((String)((String)history.get(i)), (String)"workspace-editor") || i <= 0) continue;
                    String token = (String)history.get(i - 1);
                    item.set(CollectionUtil.flatTreeStream(Collections.singletonList(root), object -> object.getChildren()).filter(object -> token.startsWith(((FxWorkspaceItem)object.getValue()).getUid())).findFirst().orElse(null));
                    break;
                }
            } else if (this.selectedItem != null) {
                item.set(WorkspaceEditorPane.findItem(root, itm -> ((FxWorkspaceItem)this.selectedItem.getValue()).equals(itm)));
            }
            FxUtil.waitForFxThread(() -> {
                this.managerPane.setCaption(this.workspace.getName() + " " + "\u2014" + " " + this.workspace.getOwner());
                this.tree.setRoot(root);
                if (item.get() != null) {
                    TreeItem treeItem = (TreeItem)item.get();
                    while (treeItem.getParent() != null) {
                        treeItem.getParent().setExpanded(true);
                        treeItem = treeItem.getParent();
                    }
                    this.tree.getSelectionModel().clearAndSelect(this.tree.getRow((TreeItem)item.get()));
                } else {
                    UiUtil.expand(this.tree, (int)1);
                    this.tree.getSelectionModel().clearAndSelect(0);
                }
            });
        }
        finally {
            this.populating = false;
        }
    }

    private void populate(TreeItem<FxWorkspaceItem> parent) {
        for (FxWorkspaceItem workspaceItem : ((FxWorkspaceItem)parent.getValue()).getSubItems()) {
            TreeItem item = new TreeItem((Object)workspaceItem);
            parent.getChildren().add((Object)item);
            this.populate((TreeItem<FxWorkspaceItem>)item);
        }
    }

    public boolean isDataChanged() {
        this.check();
        return this.changed;
    }

    private void check() {
        if (this.selectedItem == null || this.changed) {
            return;
        }
        if (!this.changed) {
            this.changed = ((CommonNavToolParametersEditor)this.commonEditorCard.getContent()).isDataChanged();
        }
        if (this.changed) {
            return;
        }
        for (MiscUtil.Pair<NavToolEditor, Card<Node>> pair : this.selectedItemEditors) {
            this.changed = ((NavToolEditor)pair.getFirst()).isDataChanged();
            if (!this.changed) continue;
            break;
        }
    }

    private void read() {
        if (this.selectedItem == null) {
            return;
        }
        FxWorkspaceItem item = (FxWorkspaceItem)this.selectedItem.getValue();
        ((CommonNavToolParametersEditor)this.commonEditorCard.getContent()).readData(item);
        this.selectedItemEditors.stream().map(value -> (NavToolEditor)value.getFirst()).forEach(value -> value.readData(item));
        this.tree.refresh();
    }

    private void write() {
        if (this.selectedItem == null) {
            return;
        }
        FxWorkspaceItem item = (FxWorkspaceItem)this.selectedItem.getValue();
        ((CommonNavToolParametersEditor)this.commonEditorCard.getContent()).writeData(item);
        this.selectedItemEditors.stream().map(value -> (NavToolEditor)value.getFirst()).forEach(value -> value.writeData(item));
        this.tree.refresh();
    }

    private void select() {
        this.selectedItemEditors.clear();
        ArrayList<Object> editorCards = new ArrayList<Object>();
        if (this.selectedItem != null) {
            editorCards.add(this.commonEditorCard);
            ((CommonNavToolParametersEditor)this.commonEditorCard.getContent()).getTypeCell().setHidden(this.selectedItem.getParent() == null);
            FxWorkspaceItem item = (FxWorkspaceItem)this.selectedItem.getValue();
            NavTool tool = NavTool.forId((String)item.getToolId());
            if (tool != null) {
                List<Object> editors = this.cache.get(tool.getId());
                if (editors == null) {
                    editors = tool.createEditors().stream().map(value -> new MiscUtil.Pair(value, (Object)value.getContent())).collect(Collectors.toList());
                    this.cache.put(tool.getId(), editors);
                }
                this.selectedItemEditors.addAll(editors);
                editorCards.addAll(editors.stream().map(MiscUtil.Pair::getSecond).collect(Collectors.toList()));
            }
        } else {
            editorCards.add(this.emptyEditorCard);
        }
        this.parametersPane.getCards().setAll(editorCards);
    }

    TreeItem<FxWorkspaceItem> createTreeItem() {
        FxWorkspaceItem workspaceItem = new FxWorkspaceItem();
        workspaceItem.setName(Messages.New_List);
        workspaceItem.setToolId("index-list-nav-tool");
        return new TreeItem((Object)workspaceItem);
    }

    TreeItem<FxWorkspaceItem> cloneTreeItem(TreeItem<FxWorkspaceItem> item) {
        this.write();
        try {
            FxWorkspaceItem workspaceItem = (FxWorkspaceItem)XCloneHelper.clone((XCloneable)((XCloneable)item.getValue()), (boolean)true);
            workspaceItem.setName(workspaceItem.getName() + Messages.The_Copy);
            NavTool tool = NavTool.forId((String)((FxWorkspaceItem)item.getValue()).getToolId());
            workspaceItem.setParameters(tool.getSerializer().serialize(tool.cloneParameters(tool.cleanParameters(tool.getSerializer().deserialize(workspaceItem.getParameters())))));
            this.changed = true;
            return new TreeItem((Object)workspaceItem);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return null;
        }
    }

    void removeTreeItem(TreeItem<FxWorkspaceItem> item) {
        TreeItem parent = item.getParent();
        if (parent != null) {
            ((FxWorkspaceItem)parent.getValue()).getSubItems().remove(item.getValue());
            parent.getChildren().remove(item);
            this.changed = true;
        }
    }

    void addTreeItem(TreeItem<FxWorkspaceItem> item, TreeItem<FxWorkspaceItem> child, int index) {
        ((FxWorkspaceItem)item.getValue()).getSubItems().add(index, child.getValue());
        item.getChildren().add(index, child);
        this.tree.getSelectionModel().select(child);
        this.changed = true;
    }

    void moveTreeItem(TreeItem<FxWorkspaceItem> item, boolean down) {
        TreeItem parent = item.getParent();
        if (parent != null) {
            boolean select;
            int index = parent.getChildren().indexOf(item);
            boolean bl = select = item == this.selectedItem;
            if (index < parent.getChildren().size() - 1 && down) {
                ((FxWorkspaceItem)parent.getValue()).getSubItems().remove(item.getValue());
                parent.getChildren().remove(item);
                ((FxWorkspaceItem)parent.getValue()).getSubItems().add(index + 1, item.getValue());
                parent.getChildren().add(index + 1, item);
                if (select) {
                    this.tree.getSelectionModel().select(item);
                }
                this.changed = true;
            } else if (index > 0 && !down) {
                ((FxWorkspaceItem)parent.getValue()).getSubItems().remove(item.getValue());
                parent.getChildren().remove(item);
                ((FxWorkspaceItem)parent.getValue()).getSubItems().add(index - 1, item.getValue());
                parent.getChildren().add(index - 1, item);
                if (select) {
                    this.tree.getSelectionModel().select(item);
                }
                this.changed = true;
            }
        }
    }

    void previewTreeItem(TreeItem<FxWorkspaceItem> item) {
        this.write();
        NavTool tool = NavTool.forId((String)((FxWorkspaceItem)item.getValue()).getToolId());
        try {
            Object data = tool.cleanParameters(tool.getSerializer().deserialize(((FxWorkspaceItem)item.getValue()).getParameters()));
            tool.execute(String.format("%s-preview", ((FxWorkspaceItem)item.getValue()).getUid()), L10n.replace((String)Messages.Preview, (Object[])new Object[]{((FxWorkspaceItem)item.getValue()).getName()}), L10n.replace((String)Messages.Preview_changes_to_the_workspace, (Object[])new Object[]{((FxWorkspaceItem)item.getValue()).getName()}), data, false, true, false);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    private void flush() {
        this.write();
        this.workspace.setName(((FxWorkspaceItem)this.tree.getRoot().getValue()).getName());
        this.workspace.getItems().clear();
        for (TreeItem item : this.tree.getRoot().getChildren()) {
            this.workspace.getItems().add(item.getValue());
        }
    }

    public void save() {
        this.flush();
        boolean isOwnerChanged = this.isOwnerChanged();
        if (isOwnerChanged) {
            new Dialog().setMessage(Messages.WorkspaceEditorPane_SaveDialog_Message).setSupplmentalMessage(L10n.replace((String)Messages.WorkspaceEditorPane_SaveDialog_SupplmentalMessage, (Object[])new Object[]{this.workspace.getOwner()})).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.WorkspaceEditorPane_SaveDialog_Button_saveForSelf, () -> {
                this.workspace.setOwner(this.workspaceOwner);
                this.workspace.setUid(this.workspaceUid);
                this.saveWithWorkspaceUpdate();
            }).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.WorkspaceEditorPane_SaveDialog_Button_saveForOwner, () -> this.saveWithoutWorkspaceUpdate()).setTitle(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Accepting_required).showGlobal();
        } else {
            this.saveWithWorkspaceUpdate();
        }
    }

    private void saveInternal() throws Exception {
        this.workspace = ((WorkspaceService)RpcServiceManager.get().getService(WorkspaceService.class)).saveWorkspace(ServiceInvocationContext.get(), this.workspace);
        this.changed = false;
        Notifications.get().showFlashNotification(Messages.Workspace_settings_are_saved, null);
    }

    private void saveWithWorkspaceUpdate() {
        Notifications.get().submitTask(() -> {
            this.saveInternal();
            this.populate(false);
            EventBus.get().publishAsync((Event)new WorkspaceModificationEvent(this.workspace));
        }, this.managerPane.getMutex());
    }

    private void saveWithoutWorkspaceUpdate() {
        Notifications.get().submitTask(() -> this.saveInternal(), this.managerPane.getMutex());
    }

    public void load() {
        if (this.changed) {
            Dialog dialog = new Dialog();
            dialog.setTitle(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Accepting_required).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Dont_save, () -> this.loadInternal());
            boolean isOwnerChanged = this.isOwnerChanged();
            if (isOwnerChanged) {
                dialog.setMessage(Messages.WorkspaceEditorPane_SaveDialog_Message).setSupplmentalMessage(L10n.replace((String)Messages.WorkspaceEditorPane_SaveDialog_SupplmentalMessage, (Object[])new Object[]{this.workspace.getOwner()})).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.WorkspaceEditorPane_SaveDialog_Button_saveForSelf, () -> {
                    this.workspace.setOwner(this.workspaceOwner);
                    this.workspace.setUid(this.workspaceUid);
                    this.saveWithWorkspaceUpdate();
                    this.loadInternal();
                }).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.WorkspaceEditorPane_SaveDialog_Button_saveForOwner, () -> {
                    this.saveWithoutWorkspaceUpdate();
                    this.loadInternal();
                });
            } else {
                dialog.setMessage(Messages.Save_Changes).setSupplmentalMessage(null).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_save, () -> {
                    this.saveWithoutWorkspaceUpdate();
                    this.loadInternal();
                });
            }
            dialog.showGlobal();
        } else {
            this.loadInternal();
        }
    }

    private void loadInternal() {
        AssetHandler handler = AssetHandler.forAssetClass(FxWorkspace.class);
        if (handler == null) {
            return;
        }
        AssetsListPane pane = new AssetsListPane(new ObservableMutex(), handler.getAssetType(), handler.getStandardListParameters(), SelectionMode.SINGLE, false);
        new Dialog().setTitle(Messages.Selecting_workspace_settings).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, Messages.Load_standart_settings, () -> Notifications.get().submitTask(() -> {
            this.workspace = ((WorkspaceService)RpcServiceManager.get().getService(WorkspaceService.class)).getDefaultWorkspace(ServiceInvocationContext.get());
            this.workspace.setUid(this.workspaceUid);
            this.workspace.setOwner(this.workspaceOwner);
            WorkspaceHelper.applyACL((FxWorkspace)this.workspace);
            this.populate(false);
            this.changed = true;
        }, this.managerPane.getMutex())).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> Notifications.get().submitTask(() -> {
            List workspaces = pane.getSelectedItems();
            if (workspaces.size() > 0) {
                this.workspace = (FxWorkspace)((AssetService)RpcServiceManager.get().getService(AssetService.class)).find(ServiceInvocationContext.get(), FxWorkspace.class, BaseAsset.Property.uid.name(), (Object)((BaseAsset)workspaces.get(0)).getUid()).getData().get(0);
                WorkspaceHelper.applyACL((FxWorkspace)this.workspace);
            }
            this.populate(false);
            this.changed = true;
        }, this.managerPane.getMutex()), (BooleanExpression)pane.selectionPresentProperty()).setExpandToParent().show((Node)this);
    }

    public void bind() {
        this.flush();
        AssetsListPane pane = new AssetsListPane(new ObservableMutex(), (MultiSupplier)new MultiSupplier<AssetsListPaneConfiguration>(){
            private final AssetHandler<?>[] handlers = new AssetHandler[]{AssetHandler.forAssetClass(AclUser.class), AssetHandler.forAssetClass(AclGroup.class)};

            public int count() {
                return this.handlers.length;
            }

            public String getDisplayName(int idx) {
                return this.handlers[idx].getName();
            }

            public AssetsListPaneConfiguration get(int idx) {
                AssetHandler<?> handler = this.handlers[idx];
                AssetsListPaneConfiguration result = new AssetsListPaneConfiguration(handler);
                result.setPatternSearchEnabled(true);
                result.setSelectionMode(SelectionMode.SINGLE);
                result.setActionsEnabled(false);
                result.applyParameters(handler.getStandardListParameters());
                return result;
            }
        });
        new Dialog().setTitle(Messages.Select_user_or_group).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> Notifications.get().submitTask(() -> {
            List users = pane.getSelectedItems();
            if (users.size() > 0) {
                AclPrincipal principal = (AclPrincipal)users.get(0);
                WorkspaceService workspaceService = (WorkspaceService)RpcServiceManager.get().getService(WorkspaceService.class);
                FxWorkspace userWorkspace = workspaceService.getWorkspace(ServiceInvocationContext.get(), principal.getId(), true);
                this.workspace.setUid(userWorkspace != null ? userWorkspace.getUid() : UUIDGenerator.generate((boolean)true).toString());
                this.workspace.setOwner(principal.getId());
                workspaceService.saveWorkspace(ServiceInvocationContext.get(), this.workspace);
                this.workspace.setUid(this.workspaceUid);
                this.workspace.setOwner(this.workspaceOwner);
                Notifications.get().showFlashNotification(L10n.replace((String)Messages.Copy_is_tied_to_user, (Object[])new Object[]{this.workspace.getName(), principal.getName()}), null);
            }
        }, this.managerPane.getMutex()), (BooleanExpression)pane.selectionPresentProperty()).setExpandToParent().show((Node)this);
    }

    public void export() {
        this.flush();
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Messages.Export_workspace);
        File dir = ClientSettings.get().getFileChooserDirectory();
        if (UiUtil.isFileValid((File)dir) && dir.isDirectory()) {
            fileChooser.setInitialDirectory(dir);
        } else {
            fileChooser.setInitialDirectory(Environment.getDataFolder());
        }
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XML", new String[]{"*.xml"})});
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            ClientSettings.get().setFileChooserDirectory(file.getParentFile());
            ClientSettings.get().save();
            Notifications.get().submitTask(() -> {
                try (FileOutputStream fos = new FileOutputStream(file);){
                    XUtil.serialize((XSerializable)this.workspace, (OutputStream)fos);
                }
                Notifications.get().showFlashNotification(Messages.workspaceEditorPane_settingsExportedToFile + "\n" + file, null);
            }, this.managerPane.getMutex());
        }
    }

    public void importt() {
        if (this.changed) {
            Dialog dialog = new Dialog().setTitle(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Accepting_required).setMessage(Messages.Save_Changes).setSupplmentalMessage(null).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Dont_save, () -> this.importInternal()).setOnCloseRequest(() -> this.importInternal());
            boolean isOwnerChanged = this.isOwnerChanged();
            if (isOwnerChanged) {
                dialog.setMessage(Messages.WorkspaceEditorPane_SaveDialog_Message).setSupplmentalMessage(L10n.replace((String)Messages.WorkspaceEditorPane_SaveDialog_SupplmentalMessage, (Object[])new Object[]{this.workspace.getOwner()})).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.WorkspaceEditorPane_SaveDialog_Button_saveForSelf, () -> {
                    this.workspace.setOwner(this.workspaceOwner);
                    this.workspace.setUid(this.workspaceUid);
                    this.saveWithWorkspaceUpdate();
                    this.importInternal();
                }).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.WorkspaceEditorPane_SaveDialog_Button_saveForOwner, () -> {
                    this.saveWithoutWorkspaceUpdate();
                    this.importInternal();
                });
            } else {
                dialog.setMessage(Messages.Save_Changes).setSupplmentalMessage(null).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_save, () -> {
                    this.saveWithWorkspaceUpdate();
                    this.importInternal();
                });
            }
            dialog.showGlobal();
        } else {
            this.importInternal();
        }
    }

    private void importInternal() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Messages.Import_workspace);
        File dir = ClientSettings.get().getFileChooserDirectory();
        if (UiUtil.isFileValid((File)dir) && dir.isDirectory()) {
            fileChooser.setInitialDirectory(dir);
        } else {
            fileChooser.setInitialDirectory(Environment.getDataFolder());
        }
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XML", new String[]{"*.xml"})});
        File file = fileChooser.showOpenDialog(this.getScene().getWindow());
        if (file != null) {
            ClientSettings.get().setFileChooserDirectory(file.getParentFile());
            ClientSettings.get().save();
            Notifications.get().submitTask(() -> {
                FxWorkspace newWorkspace = new FxWorkspace(this.workspace.getUid());
                newWorkspace.setOwner(this.workspace.getOwner());
                try (FileInputStream fis = new FileInputStream(file);){
                    newWorkspace.fromXML(DocumentBuilderHelper.parse((InputStream)fis).getDocumentElement());
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)Xeption.forDeveloper((String)Messages.Load_workspace_file_error, (Throwable)e, (Object[])new Object[0]));
                    return;
                }
                WorkspaceHelper.applyACL((FxWorkspace)newWorkspace);
                this.workspace = newWorkspace;
                this.populate(false);
                this.changed = true;
            }, this.managerPane.getMutex());
        }
    }

    private boolean isOwnerChanged() {
        return !this.workspaceUid.equals(this.workspace.getUid());
    }

    TreeItem<FxWorkspaceItem> getSelectedItem() {
        return this.selectedItem;
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Arrays.asList(WorkspaceEditorPane.this.treePane, WorkspaceEditorPane.this.parametersPane);
            }

            public String getInfo() {
                return ((Object)((Object)WorkspaceEditorPane.this)).getClass().getSimpleName();
            }
        };
    }
}

