/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.workspace.action;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.workspace.WorkspaceManagerAction;
import com.gridnine.xtrip.client.fx.standard.workspace.WorkspaceManagerPane;
import com.gridnine.xtrip.client.fx.standard.workspace.util.WorkspaceUtil;
import com.gridnine.xtrip.common.fx.assets.FxWorkspace;
import com.gridnine.xtrip.common.fx.rpc.WorkspaceService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.model.assets.Workspace;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.List;
import javafx.scene.control.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertWorkspaceAction
implements WorkspaceManagerAction {
    public String getId() {
        return "convert-workspace";
    }

    public ActionIcon getIcon(WorkspaceManagerPane context) {
        return StandardActionIcons.SAVE;
    }

    public double getWeight() {
        return 60.0;
    }

    public boolean isEnabled(WorkspaceManagerPane context) {
        return true;
    }

    public void execute(Control source, WorkspaceManagerPane context, boolean alt) {
        Notifications.get().submitTask(() -> {
            Logger log = LoggerFactory.getLogger(this.getClass());
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)Workspace.Property.owner.name(), (Object)"maxim"));
            List workspaces = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), Workspace.class, query).getData();
            if (workspaces.size() > 0) {
                FxWorkspace oldWorkspace;
                FxWorkspace fxWorkspace = WorkspaceUtil.toWorkspace((Workspace)workspaces.get(0));
                if (log.isDebugEnabled()) {
                    log.debug(WorkspaceUtil.toString(fxWorkspace));
                }
                if ((oldWorkspace = ((WorkspaceService)RpcServiceManager.get().getService(WorkspaceService.class)).getWorkspace(ServiceInvocationContext.get(), "maxim", true)) != null) {
                    fxWorkspace.setUid(oldWorkspace.getUid());
                }
                ((WorkspaceService)RpcServiceManager.get().getService(WorkspaceService.class)).saveWorkspace(ServiceInvocationContext.get(), fxWorkspace);
            }
        }, context.getMutex());
    }
}

