/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.kkt.common.model.helper;

import com.gridnine.kkt.common.json.JSONObject;
import com.gridnine.kkt.common.model.JsonSerializable;
import java.util.Collections;

public abstract class JsonHelper {
    public static <E extends JsonSerializable> String serialize(E entity) throws Exception {
        JSONObject builder = new JSONObject();
        entity.toJson(builder, Collections.emptySet());
        return JsonHelper.fromJsonObject(builder);
    }

    public static <E extends JsonSerializable> E deserialize(Class<E> type, String content) throws Exception {
        JsonSerializable entity = (JsonSerializable)type.newInstance();
        entity.fromJson(JsonHelper.toJsonObject(content));
        return (E)entity;
    }

    public static JSONObject toJsonObject(String content) {
        return new JSONObject(content);
    }

    public static String fromJsonObject(JSONObject object) {
        return object.toString(4);
    }
}

