/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticUdidsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticVM;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.gds.sabre.CostCodesHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.util.StringConverter;

public class BookingFileProductStatisticsHelper {
    public static void updateMultiTravellerUdidsTable(TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, BookingFileProductStatisticVM model) {
        BookingFileProductStatisticsHelper.setupNameColumn(udidsWidget, model);
        BookingFileProductStatisticsHelper.setupTravellerColumn(udidsWidget, model);
        BookingFileProductStatisticsHelper.setupValueColumn(udidsWidget, model, true);
    }

    public static void updateSingleTravellerUdidsTable(TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, BookingFileProductStatisticVM model) {
        BookingFileProductStatisticsHelper.setupNameColumn(udidsWidget, model);
        BookingFileProductStatisticsHelper.setupValueColumn(udidsWidget, model, false);
        BookingFileProductStatisticsHelper.hideTravellerColumn(udidsWidget);
    }

    private static void hideTravellerColumn(TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget) {
        ComboBoxWidgetColumn travellerColumn = (ComboBoxWidgetColumn)udidsWidget.getColumn("travellerIbe");
        travellerColumn.setHidden(true);
    }

    private static void setupNameColumn(TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, BookingFileProductStatisticVM model) {
        final ComboBoxWidgetColumn nameColumn = (ComboBoxWidgetColumn)udidsWidget.getColumn("name");
        ComboBoxWidgetColumn travellerColumn = (ComboBoxWidgetColumn)udidsWidget.getColumn("travellerIbe");
        IntStream.range(0, udidsWidget.getRowsCount()).forEach(i -> ((ComboBoxWidget)nameColumn.getWidget(i)).setItemsSupplier(() -> model.getProfileCostCodeProperties().stream().filter(ccp -> !ccp.isDependant() || com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductStatisticsHelper.getValidDependants((BookingFileProductStatisticVM)model, (TableWidget)udidsWidget, (Traveller)((Traveller)((ComboBoxWidget)travellerColumn.getWidget(i)).getValue())).contains(ccp)).collect(Collectors.toList())));
        nameColumn.setConverter((StringConverter)new StringConverter<CostCodeProperties>(){

            public String toString(CostCodeProperties prop) {
                return prop == null ? null : prop.getName();
            }

            public CostCodeProperties fromString(String string) {
                return null;
            }
        });
        nameColumn.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler((StringConverter)new StringConverter<CostCodeProperties>(){

            public String toString(CostCodeProperties object) {
                if (nameColumn.getConverter() != null) {
                    return nameColumn.getConverter().toString((Object)object);
                }
                return object == null ? null : object.toString();
            }

            public CostCodeProperties fromString(String string) {
                return null;
            }
        }, nameColumn.getItemsSupplier(), true));
    }

    private static void setupValueColumn(TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, BookingFileProductStatisticVM model, boolean isMultiTraveller) {
        ComboBoxWidgetColumn nameColumn = (ComboBoxWidgetColumn)udidsWidget.getColumn("name");
        TextWidgetColumn valueColumn = (TextWidgetColumn)udidsWidget.getColumn("value");
        TextWidgetColumn localValueColumn = (TextWidgetColumn)udidsWidget.getColumn("localValue");
        TextWidgetColumn englishValueColumn = (TextWidgetColumn)udidsWidget.getColumn("englishValue");
        ComboBoxWidgetColumn travellerIbeColumn = (ComboBoxWidgetColumn)udidsWidget.getColumn("travellerIbe");
        udidsWidget.setOnRowsAction(event -> {
            if (event.getTarget() == udidsWidget && TableRowEvent.ROW_ADD.equals(event.getEventType())) {
                int idx = event.getRowIndex();
                ComboBoxWidget nameWidget = (ComboBoxWidget)nameColumn.getWidget(idx);
                TextFieldWidget valueWidget = (TextFieldWidget)valueColumn.getWidget(idx);
                TextFieldWidget localValueWidget = (TextFieldWidget)localValueColumn.getWidget(idx);
                TextFieldWidget englishValueWidget = (TextFieldWidget)englishValueColumn.getWidget(idx);
                ComboBoxWidget travellerWidget = (ComboBoxWidget)travellerIbeColumn.getWidget(idx);
                nameWidget.setItemsSupplier(() -> model.getProfileCostCodeProperties().stream().filter(ccp -> !ccp.isDependant() || com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductStatisticsHelper.getValidDependants((BookingFileProductStatisticVM)model, (TableWidget)udidsWidget, (Traveller)((Traveller)travellerWidget.getValue())).contains(ccp)).collect(Collectors.toList()));
                BookingFileProductStatisticsHelper.setupTravellerWidget((ComboBoxWidget<CostCodeProperties>)nameWidget, (ComboBoxWidget<Traveller>)travellerWidget);
                BookingFileProductStatisticsHelper.setupValueWidgetsSupplier((CostCodeProperties)nameWidget.getValue(), valueWidget, localValueWidget, englishValueWidget, model);
                BookingFileProductStatisticsHelper.setupValueWidget(udidsWidget, (ComboBoxWidget<CostCodeProperties>)nameWidget, valueWidget, localValueWidget, englishValueWidget, (ComboBoxWidget<Traveller>)travellerWidget, isMultiTraveller, model);
            }
        });
        for (int i = 0; i < udidsWidget.getRowsCount(); ++i) {
            ComboBoxWidget nameWidget = (ComboBoxWidget)nameColumn.getWidget(i);
            TextFieldWidget valueWidget = (TextFieldWidget)valueColumn.getWidget(i);
            TextFieldWidget localValueWidget = (TextFieldWidget)localValueColumn.getWidget(i);
            TextFieldWidget englishValueWidget = (TextFieldWidget)englishValueColumn.getWidget(i);
            ComboBoxWidget travellerWidget = (ComboBoxWidget)travellerIbeColumn.getWidget(i);
            BookingFileProductStatisticsHelper.setupTravellerWidget((ComboBoxWidget<CostCodeProperties>)nameWidget, (ComboBoxWidget<Traveller>)travellerWidget);
            BookingFileProductStatisticsHelper.setupValueWidgetsSupplier((CostCodeProperties)nameWidget.getValue(), valueWidget, localValueWidget, englishValueWidget, model);
            BookingFileProductStatisticsHelper.setupValueWidget(udidsWidget, (ComboBoxWidget<CostCodeProperties>)nameWidget, valueWidget, localValueWidget, englishValueWidget, (ComboBoxWidget<Traveller>)travellerWidget, isMultiTraveller, model);
        }
    }

    private static void setupTravellerColumn(TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, BookingFileProductStatisticVM model) {
        ComboBoxWidgetColumn travellerColumn = (ComboBoxWidgetColumn)udidsWidget.getColumn("travellerIbe");
        travellerColumn.setItemsSupplier(() -> ((BookingFileProductStatisticVM)model).getTravellersIbe());
        travellerColumn.setConverter((StringConverter)new StringConverter<Traveller>(){

            public String toString(Traveller object) {
                return object == null ? null : object.getName();
            }

            public Traveller fromString(String string) {
                return null;
            }
        });
        travellerColumn.setNoNulls(true);
        udidsWidget.setNewRowHandler(udidsVM -> udidsVM.setTravellerIbe((Traveller)model.getStatistic().getUdids().stream().filter(vm -> vm.getTravellerIbe() != null).map(BookingFileProductStatisticUdidsVM::getTravellerIbe).findFirst().orElse(null)));
    }

    private static void setupTravellerWidget(ComboBoxWidget<CostCodeProperties> nameWidget, ComboBoxWidget<Traveller> travellerWidget) {
        travellerWidget.valueProperty().addListener((s, o, n) -> nameWidget.setLive(true));
    }

    private static void setupValueWidget(TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, ComboBoxWidget<CostCodeProperties> nameWidget, TextFieldWidget valueWidget, TextFieldWidget localValueWidget, TextFieldWidget englishValueWidget, ComboBoxWidget<Traveller> travellerWidget, boolean isMultiTraveller, BookingFileProductStatisticVM model) {
        CostCodeProperties costCodeProperties = (CostCodeProperties)nameWidget.getValue();
        nameWidget.valueProperty().addListener((observable, oldValue, newValue) -> BookingFileProductStatisticsHelper.setupValueWidgetsSupplier(newValue, valueWidget, localValueWidget, englishValueWidget, model));
        valueWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
            List costCodes;
            CostCode costCode;
            Collection personCostCodes = null;
            if (model.getPersonCostCodes() != null) {
                Collection<Object> collection = personCostCodes = isMultiTraveller ? (List)model.getPersonCostCodes().get(travellerWidget.getValue()) : model.getPersonCostCodes().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            }
            if (personCostCodes != null) {
                PersonCostCode personCostCode = personCostCodes.stream().filter(pcc -> StatisticsHelper.equalsCostCodeProperties((CostCodeProperties)costCodeProperties, (CostCodeProperties)pcc.getCostCodeProperties()) && Stream.of(pcc.getValue(), pcc.getLocalValue(), pcc.getEnglishValue()).filter(TextUtil::nonBlank).anyMatch(val -> MiscUtil.equals((Object)val, (Object)newValue))).findFirst().orElse(null);
                if (personCostCode != null) {
                    localValueWidget.setValue(personCostCode.getLocalValue());
                    englishValueWidget.setValue(personCostCode.getEnglishValue());
                } else {
                    localValueWidget.setValue(null);
                    englishValueWidget.setValue(null);
                }
            }
            if ((costCode = (CostCode)(costCodes = model.getProfileCostCodes().stream().filter(cc -> StatisticsHelper.equalsCostCodeProperties((CostCodeProperties)costCodeProperties, (CostCodeProperties)cc.getCostCodeProperties())).collect(Collectors.toList())).stream().filter(cc -> MiscUtil.equals((Object)newValue, (Object)cc.getValue())).findFirst().orElse(null)) != null) {
                localValueWidget.setValue(costCode.getLocalValue());
                englishValueWidget.setValue(costCode.getEnglishValue());
            } else if (personCostCodes == null) {
                localValueWidget.setValue(null);
                englishValueWidget.setValue(null);
            }
            costCodes.removeIf(cc -> !MiscUtil.equals((Object)newValue, (Object)cc.getValue()));
            List localValues = costCodes.stream().map(CostCode::getLocalValue).filter(Objects::nonNull).sorted(String::compareTo).collect(Collectors.toList());
            List englishValues = costCodes.stream().map(CostCode::getEnglishValue).filter(Objects::nonNull).sorted(String::compareTo).collect(Collectors.toList());
            if (!localValues.isEmpty()) {
                localValueWidget.setItemsSupplier(() -> localValues);
            } else {
                localValueWidget.setItemsSupplier(null);
            }
            if (!englishValues.isEmpty()) {
                englishValueWidget.setItemsSupplier(() -> englishValues);
            } else {
                englishValueWidget.setItemsSupplier(null);
            }
            if (newValue != null && CostCodesHelper.isCostCodeContainsUnsupportedSymbols((String)newValue)) {
                valueWidget.setValue(oldValue == null ? "" : oldValue);
            } else {
                ComboBoxWidgetColumn nameColumn = (ComboBoxWidgetColumn)udidsWidget.getColumn("name");
                TextWidgetColumn valueColumn = (TextWidgetColumn)udidsWidget.getColumn("value");
                ComboBoxWidgetColumn travellerColumn = (ComboBoxWidgetColumn)udidsWidget.getColumn("travellerIbe");
                int idx = IntStream.range(0, udidsWidget.getRowsCount()).filter(i -> valueWidget.equals(valueColumn.getWidget(i))).findFirst().orElse(-1);
                List old = com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductStatisticsHelper.getValidDependants((BookingFileProductStatisticVM)model, (TableWidget)udidsWidget, (Traveller)((Traveller)travellerWidget.getValue()), (int)idx, (String)oldValue);
                List nova = com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductStatisticsHelper.getValidDependants((BookingFileProductStatisticVM)model, (TableWidget)udidsWidget, (Traveller)((Traveller)travellerWidget.getValue()));
                IntStream.range(0, udidsWidget.getRowsCount()).forEach(i -> {
                    ((ComboBoxWidget)nameColumn.getWidget(i)).setLive(true);
                    CostCodeProperties properties = (CostCodeProperties)((ComboBoxWidget)nameColumn.getWidget(i)).getValue();
                    if (properties != null && properties.isDependant() && MiscUtil.equals((Object)travellerWidget.getValue(), (Object)((ComboBoxWidget)travellerColumn.getWidget(i)).getValue(), (boolean)true) && !old.contains(properties)) {
                        old.add(((ComboBoxWidget)nameColumn.getWidget(i)).getValue());
                    }
                });
                ArrayList<CostCodeProperties> addition = new ArrayList<CostCodeProperties>(nova);
                addition.removeIf(old::contains);
                addition.removeIf(ccp -> IntStream.range(0, udidsWidget.getRowsCount()).anyMatch(i -> MiscUtil.equals((Object)ccp, (Object)((ComboBoxWidget)nameColumn.getWidget(i)).getValue()) && MiscUtil.equals((Object)travellerWidget.getValue(), (Object)((ComboBoxWidget)travellerColumn.getWidget(i)).getValue(), (boolean)true)));
                ArrayList<CostCodeProperties> removal = new ArrayList<CostCodeProperties>(old);
                removal.removeIf(nova::contains);
                addition.forEach(ccp -> {
                    BookingFileProductStatisticUdidsVM vm = new BookingFileProductStatisticUdidsVM();
                    vm.setName(ccp);
                    vm.setTravellerIbe((Traveller)travellerWidget.getValue());
                    udidsWidget.addRow((Object)vm);
                });
                if (!removal.isEmpty()) {
                    IntStream.range(0, udidsWidget.getRowsCount()).filter(i -> removal.contains(((ComboBoxWidget)nameColumn.getWidget(i)).getValue()) && TextUtil.isBlank((String)((TextFieldWidget)valueColumn.getWidget(i)).getValue()) && MiscUtil.equals((Object)travellerWidget.getValue(), (Object)((ComboBoxWidget)travellerColumn.getWidget(i)).getValue(), (boolean)true)).boxed().sorted(Comparator.reverseOrder()).forEach(arg_0 -> ((TableWidget)udidsWidget).removeRow(arg_0));
                }
            }
        });
    }

    private static void setupValueWidgetsSupplier(CostCodeProperties value, TextFieldWidget valueWidget, TextFieldWidget localValueWidget, TextFieldWidget englishValueWidget, BookingFileProductStatisticVM model) {
        if (value != null && CollectionUtil.isNotEmpty((Collection)model.getProfileCostCodes())) {
            List costCodes = model.getProfileCostCodes().stream().filter(costCode -> costCode.getCostCodeProperties() != null && MiscUtil.equals((Object)value.getCategory(), (Object)costCode.getCostCodeProperties().getCategory())).collect(Collectors.toList());
            List costCodeValues = costCodes.stream().map(CostCode::getValue).filter(Objects::nonNull).sorted(String::compareTo).collect(Collectors.toList());
            costCodes.removeIf(cc -> !MiscUtil.equals((Object)cc.getValue(), (Object)valueWidget.getValue()));
            List costCodeLocalValues = costCodes.stream().map(CostCode::getLocalValue).filter(Objects::nonNull).sorted(String::compareTo).collect(Collectors.toList());
            List costCodeEnglishValues = costCodes.stream().map(CostCode::getEnglishValue).filter(Objects::nonNull).sorted(String::compareTo).collect(Collectors.toList());
            if (costCodeValues.isEmpty()) {
                valueWidget.setItemsSupplier(null);
            } else {
                valueWidget.setItemsSupplier(() -> costCodeValues);
            }
            if (costCodeLocalValues.isEmpty()) {
                localValueWidget.setItemsSupplier(null);
            } else {
                localValueWidget.setItemsSupplier(() -> costCodeLocalValues);
            }
            if (costCodeEnglishValues.isEmpty()) {
                englishValueWidget.setItemsSupplier(null);
            } else {
                englishValueWidget.setItemsSupplier(() -> costCodeEnglishValues);
            }
        }
    }
}

