/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.statistic.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.CompactGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.HyperlinkWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.DictBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationRelatedCostCodePropertiesVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpace;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpaceVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidValueVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsDetailsExtraPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsDetailsPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsDetailsUdidTypeContainer;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsPanel;
import com.gridnine.xtrip.client.fx.model.system.BaseVM;
import com.gridnine.xtrip.client.fx.standard.helpers.RpcDictHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.CostCodeType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class OrganizationStatisticControllerInterceptor
extends ControllerInterceptor<OrganizationSpaceVM, OrganizationSpaceController> {
    protected Class<OrganizationSpaceController> getControllerClass() {
        return OrganizationSpaceController.class;
    }

    protected void onCreate(OrganizationSpaceController controller) {
        ((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).setOnRowsAction(event -> this.getEventHandlerForUdidTable(controller, (TableRowEvent)event));
        this.setColumnWidth(((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).getColumns());
    }

    protected void afterReadData(OrganizationSpaceController controller, OrganizationSpaceVM model) {
        for (int udidIndex = 0; udidIndex < ((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).getRowsCount(); ++udidIndex) {
            OrganizationStatisticControllerInterceptor.updateWidget(controller, udidIndex);
        }
        BooleanValueWidgetColumn dependantColumn = (BooleanValueWidgetColumn)((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).getColumn("dependant");
        int viewsSize = ((CompactGroupsWidget)((OrganizationUdidsDetailsPanel)controller.getView().getUdidsDetailsTile().getFullNode()).getExtraParametersCard().getContent()).getViews().size();
        HashSet relatedSet = new HashSet();
        for (int udidDetailIndex = 0; udidDetailIndex < viewsSize; ++udidDetailIndex) {
            OrganizationStatisticControllerInterceptor.updateUdidDetail(controller, udidDetailIndex);
            Set<OrganizationRelatedCostCodePropertiesVM> set = OrganizationStatisticControllerInterceptor.getRelatedCostCodeProperties(controller, udidDetailIndex);
            if (!((BooleanValueWidget)dependantColumn.getWidget(udidDetailIndex)).getValue()) {
                ((BooleanValueWidget)dependantColumn.getWidget(udidDetailIndex)).setDisable(!set.isEmpty());
            }
            relatedSet.addAll(set.stream().map(OrganizationRelatedCostCodePropertiesVM::getUid).collect(Collectors.toSet()));
        }
        if (relatedSet.isEmpty()) {
            return;
        }
        for (int udidIndex = 0; udidIndex < ((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).getRowsCount(); ++udidIndex) {
            if (!((BooleanValueWidget)dependantColumn.getWidget(udidIndex)).getValue()) continue;
            ((BooleanValueWidget)dependantColumn.getWidget(udidIndex)).setDisable(relatedSet.contains(((OrganizationUdidVM)((TableWidget)controller.getUdidsFull().getView().getGeneralCard().getContent()).getData(udidIndex)).getUid()));
        }
    }

    private static void updateWidget(OrganizationSpaceController controller, int udidIndex) {
        ComboBoxWidgetColumn numberColumn = (ComboBoxWidgetColumn)((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).getColumn("number");
        ((ComboBoxWidget)numberColumn.getWidget(udidIndex)).setItemsSupplier(() -> {
            CostCodeType costCodeType = (CostCodeType)((ComboBoxWidget)numberColumn.getWidget(udidIndex)).getValue();
            ArrayList<Object> costCodeTypes = new ArrayList<Object>();
            for (int i = 0; i < ((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).getRowsCount(); ++i) {
                if (i == udidIndex) continue;
                costCodeTypes.add(((ComboBoxWidget)numberColumn.getWidget(i)).getValue());
            }
            return Arrays.stream(CostCodeType.values()).filter(t -> t.equals((Object)costCodeType) || !costCodeTypes.contains(t)).collect(Collectors.toList());
        });
        DictBoxWidgetColumn categoryColumn = (DictBoxWidgetColumn)((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).getColumn("category");
        ((DictBoxWidget)categoryColumn.getWidget(udidIndex)).setListParametersSupplier(() -> {
            DictHandler categoryDictHandler = DictHandler.forDictClass(CostCodeCategory.class);
            DictListParameters params = categoryDictHandler.getStandardListParameters().copy();
            ArrayList categories = new ArrayList();
            ArrayList<DictionaryReference> present = new ArrayList<DictionaryReference>();
            for (int i = 0; i < ((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).getRowsCount(); ++i) {
                if (i == udidIndex) continue;
                present.add(((DictBoxWidget)categoryColumn.getWidget(i)).getValue());
            }
            CountDownLatch downLatch = new CountDownLatch(1);
            Notifications.get().submitTask(() -> {
                try {
                    categories.addAll(RpcDictHelper.loadAll(CostCodeCategory.class).stream().filter(r -> !present.contains(r.toReference())).collect(Collectors.toList()));
                }
                finally {
                    downLatch.countDown();
                }
            }, Messages.Notifications_getting_data);
            try {
                downLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            params.getSearchCriterions().add(new DictQuery.SearchCriterion("code", categories.stream().map(BaseDictionary::getCode).toArray()));
            return params;
        });
    }

    private static void updateUdidDetail(OrganizationSpaceController controller, int udidDetailIndex) {
        OrganizationUdidsDetailsExtraPanel udidDetailsView = (OrganizationUdidsDetailsExtraPanel)((CompactGroupsWidget)((OrganizationUdidsDetailsPanel)controller.getView().getUdidsDetailsTile().getFullNode()).getExtraParametersCard().getContent()).getViews().get(udidDetailIndex);
        String udidDetailsUid = ((OrganizationUdidVM)((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).getData(udidDetailIndex)).getUid();
        TableWidgetColumn relatedCostCodePropertiesColumn = ((TableWidget)udidDetailsView.getUdidValuesCard().getContent()).getColumn("relatedCostCodeProperties");
        BooleanValueWidgetColumn dependantColumn = (BooleanValueWidgetColumn)((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).getColumn("dependant");
        relatedCostCodePropertiesColumn.setHidden(((BooleanValueWidget)dependantColumn.getWidget(udidDetailIndex)).getValue());
        ((TableWidget)udidDetailsView.getUdidValuesCard().getContent()).setOnRowsAction(event -> {
            if (TableRowEvent.ROW_ADD.equals(event.getEventType())) {
                OrganizationStatisticControllerInterceptor.addListener(controller, (ValuesWidget<OrganizationRelatedCostCodePropertiesVM>)((ValuesWidget)relatedCostCodePropertiesColumn.getWidget(event.getRowIndex().intValue())), udidDetailIndex);
                OrganizationStatisticControllerInterceptor.updateWidget((ValuesWidget<OrganizationRelatedCostCodePropertiesVM>)((ValuesWidget)relatedCostCodePropertiesColumn.getWidget(event.getRowIndex().intValue())), controller, udidDetailsUid);
                OrganizationStatisticControllerInterceptor.updateColumnWidth(((TableWidget)udidDetailsView.getUdidValuesCard().getContent()).getColumns());
            } else if (TableRowEvent.ROW_REMOVE.equals(event.getEventType())) {
                TableWidget content = (TableWidget)controller.getUdidsFull().getView().getGeneralCard().getContent();
                for (int i = 0; i < content.getRowsCount(); ++i) {
                    if (!((BooleanValueWidget)((BooleanValueWidgetColumn)content.getColumn("dependant")).getWidget(i)).getValue()) continue;
                    OrganizationStatisticControllerInterceptor.checkDeletion(controller, udidDetailIndex, ((OrganizationUdidVM)content.getData(i)).getUid());
                }
            }
        });
        for (int rowIndex = 0; rowIndex < ((TableWidget)udidDetailsView.getUdidValuesCard().getContent()).getRowsCount(); ++rowIndex) {
            OrganizationStatisticControllerInterceptor.addListener(controller, (ValuesWidget<OrganizationRelatedCostCodePropertiesVM>)((ValuesWidget)relatedCostCodePropertiesColumn.getWidget(rowIndex)), udidDetailIndex);
            OrganizationStatisticControllerInterceptor.updateWidget((ValuesWidget<OrganizationRelatedCostCodePropertiesVM>)((ValuesWidget)relatedCostCodePropertiesColumn.getWidget(rowIndex)), controller, udidDetailsUid);
            OrganizationStatisticControllerInterceptor.updateColumnWidth(((TableWidget)udidDetailsView.getUdidValuesCard().getContent()).getColumns());
        }
    }

    private static List<OrganizationRelatedCostCodePropertiesVM> getRelatedCostCodesPropertiesVM(TableWidget<OrganizationUdidVM> content) {
        ArrayList<OrganizationRelatedCostCodePropertiesVM> result = new ArrayList<OrganizationRelatedCostCodePropertiesVM>();
        ComboBoxWidgetColumn numberColumn = (ComboBoxWidgetColumn)content.getColumn("number");
        DictBoxWidgetColumn categoryColumn = (DictBoxWidgetColumn)content.getColumn("category");
        BooleanValueWidgetColumn dependantColumn = (BooleanValueWidgetColumn)content.getColumn("dependant");
        for (int i = 0; i < content.getRowsCount(); ++i) {
            if (!((BooleanValueWidget)dependantColumn.getWidget(i)).getValue()) continue;
            String number = MiscUtil.toString((Object)(((OrganizationUdidVM)content.getData(i)).getNumber() == null ? ((ComboBoxWidget)numberColumn.getWidget(i)).getValue() : ((OrganizationUdidVM)content.getData(i)).getNumber()));
            String categoryName = MiscUtil.toString((Object)(((OrganizationUdidVM)content.getData(i)).getCategory() == null ? ((DictBoxWidget)categoryColumn.getWidget(i)).getValue() : ((OrganizationUdidVM)content.getData(i)).getCategory()));
            String caption = TextUtil.nonBlankStr((String)number) + (TextUtil.nonBlank((String)categoryName) ? " (" + categoryName + ")" : "");
            OrganizationRelatedCostCodePropertiesVM item = new OrganizationRelatedCostCodePropertiesVM();
            item.setUid(((OrganizationUdidVM)content.getData(i)).getUid());
            item.setCaption(caption);
            result.add(item);
        }
        return result;
    }

    private static void addListener(OrganizationSpaceController controller, ValuesWidget<OrganizationRelatedCostCodePropertiesVM> widget, int udidDetailIndex) {
        widget.getValues().addListener(c -> {
            while (c.next()) {
                c.getAddedSubList().forEach(it -> OrganizationStatisticControllerInterceptor.checkAddition(controller, udidDetailIndex, it.getUid()));
                c.getRemoved().forEach(it -> OrganizationStatisticControllerInterceptor.checkDeletion(controller, udidDetailIndex, it.getUid()));
            }
        });
    }

    private static void checkAddition(OrganizationSpaceController controller, int udidDetailIndex, String uid) {
        TableWidget content = (TableWidget)controller.getUdidsFull().getView().getGeneralCard().getContent();
        content.getColumn("dependant").getWidget(udidDetailIndex).setDisable(true);
        ((TextFieldWidget)((TextWidgetColumn)content.getColumn("relatedCostCodeProperties")).getWidget(udidDetailIndex)).setValue(OrganizationStatisticControllerInterceptor.getRelatedCaption(controller, udidDetailIndex));
        for (int i = 0; i < content.getRowsCount(); ++i) {
            if (!TextUtil.equals((String)((OrganizationUdidVM)content.getData(i)).getUid(), (String)uid, (boolean)true)) continue;
            content.getColumn("dependant").getWidget(i).setDisable(true);
        }
    }

    private static String getRelatedCaption(OrganizationSpaceController controller, int udidDetailIndex) {
        return OrganizationStatisticControllerInterceptor.getRelatedCostCodeProperties(controller, udidDetailIndex).stream().map(OrganizationRelatedCostCodePropertiesVM::getCaption).distinct().collect(Collectors.joining(", "));
    }

    private static Set<OrganizationRelatedCostCodePropertiesVM> getRelatedCostCodeProperties(OrganizationSpaceController controller, int udidDetailIndex) {
        HashSet<OrganizationRelatedCostCodePropertiesVM> relatedCostCodeProperties = new HashSet<OrganizationRelatedCostCodePropertiesVM>();
        for (int i = 0; i < ((TableWidget)((OrganizationUdidsDetailsExtraPanel)((CompactGroupsWidget)controller.getUdidsDetailsFull().getView().getExtraParametersCard().getContent()).getViews().get(udidDetailIndex)).getUdidValuesCard().getContent()).getRowsCount(); ++i) {
            relatedCostCodeProperties.addAll((Collection<OrganizationRelatedCostCodePropertiesVM>)((ValuesWidget)((TableWidget)((OrganizationUdidsDetailsExtraPanel)((CompactGroupsWidget)controller.getUdidsDetailsFull().getView().getExtraParametersCard().getContent()).getViews().get(udidDetailIndex)).getUdidValuesCard().getContent()).getColumn("relatedCostCodeProperties").getWidget(i)).getValues());
        }
        return relatedCostCodeProperties;
    }

    private static void checkDeletion(OrganizationSpaceController controller, int udidDetailIndex, String uid) {
        TableWidgetColumn relatedCodesColumn = ((TableWidget)((OrganizationUdidsDetailsExtraPanel)((CompactGroupsWidget)controller.getUdidsDetailsFull().getView().getExtraParametersCard().getContent()).getViews().get(udidDetailIndex)).getUdidValuesCard().getContent()).getColumn("relatedCostCodeProperties");
        boolean isEmpty = true;
        for (int i = 0; i < ((TableWidget)((OrganizationUdidsDetailsExtraPanel)((CompactGroupsWidget)controller.getUdidsDetailsFull().getView().getExtraParametersCard().getContent()).getViews().get(udidDetailIndex)).getUdidValuesCard().getContent()).getRowsCount(); ++i) {
            if (((ValuesWidget)relatedCodesColumn.getWidget(i)).getValues().isEmpty()) continue;
            isEmpty = false;
            break;
        }
        TableWidget content = (TableWidget)controller.getUdidsFull().getView().getGeneralCard().getContent();
        if (isEmpty) {
            content.getColumn("dependant").getWidget(udidDetailIndex).setDisable(false);
        }
        ((TextFieldWidget)((TextWidgetColumn)content.getColumn("relatedCostCodeProperties")).getWidget(udidDetailIndex)).setValue(OrganizationStatisticControllerInterceptor.getRelatedCaption(controller, udidDetailIndex));
        OrganizationStatisticControllerInterceptor.checkDeletion(controller, uid);
    }

    private static void checkDeletion(OrganizationSpaceController controller, String uid) {
        TableWidget content = (TableWidget)controller.getUdidsFull().getView().getGeneralCard().getContent();
        boolean isPresent = ((CompactGroupsWidget)controller.getUdidsDetailsFull().getView().getExtraParametersCard().getContent()).getViews().stream().anyMatch(p -> {
            TableWidgetColumn relatedCostCodesColumn = ((TableWidget)p.getUdidValuesCard().getContent()).getColumn("relatedCostCodeProperties");
            if (relatedCostCodesColumn.isHidden()) {
                return false;
            }
            for (int i = 0; i < ((TableWidget)p.getUdidValuesCard().getContent()).getRowsCount(); ++i) {
                if (!((ValuesWidget)relatedCostCodesColumn.getWidget(i)).getValues().stream().anyMatch(vm -> TextUtil.equals((String)vm.getUid(), (String)uid, (boolean)true))) continue;
                return true;
            }
            return false;
        });
        if (isPresent) {
            return;
        }
        for (int i = 0; i < content.getRowsCount(); ++i) {
            if (!TextUtil.equals((String)((OrganizationUdidVM)content.getData(i)).getUid(), (String)uid, (boolean)true)) continue;
            content.getColumn("dependant").getWidget(i).setDisable(false);
        }
    }

    private static void updateWidget(ValuesWidget<OrganizationRelatedCostCodePropertiesVM> widget, OrganizationSpaceController controller, String udidDetailsUid) {
        widget.setItemsSupplier(() -> {
            TableWidget content = (TableWidget)controller.getUdidsFull().getView().getGeneralCard().getContent();
            List<OrganizationRelatedCostCodePropertiesVM> relatedCostCodesPropertiesVM = OrganizationStatisticControllerInterceptor.getRelatedCostCodesPropertiesVM((TableWidget<OrganizationUdidVM>)content);
            relatedCostCodesPropertiesVM.removeIf(prop -> TextUtil.equals((String)prop.getUid(), (String)udidDetailsUid, (boolean)true));
            widget.getValues().forEach(v -> relatedCostCodesPropertiesVM.set(relatedCostCodesPropertiesVM.indexOf(relatedCostCodesPropertiesVM.stream().filter(cc -> TextUtil.equals((String)cc.getUid(), (String)v.getUid(), (boolean)true)).findFirst().orElse(null)), (OrganizationRelatedCostCodePropertiesVM)v));
            return relatedCostCodesPropertiesVM;
        });
        widget.setConverter((StringConverter)new StringConverter<OrganizationRelatedCostCodePropertiesVM>(){

            public String toString(OrganizationRelatedCostCodePropertiesVM object) {
                return object != null ? object.getCaption() : null;
            }

            public OrganizationRelatedCostCodePropertiesVM fromString(String string) {
                return null;
            }
        });
    }

    private static void updateColumnWidth(List<TableWidgetColumn<OrganizationUdidValueVM, ?>> columns) {
        columns.get(1).setPrefWidth(Double.valueOf(20.0));
        columns.get(2).setPrefWidth(Double.valueOf(20.0));
        columns.get(3).setPrefWidth(Double.valueOf(35.0));
    }

    private void setColumnWidth(List<TableWidgetColumn<OrganizationUdidVM, ?>> columns) {
        columns.get(0).setPrefWidth(Double.valueOf(4.0));
        columns.get(1).setPrefWidth(Double.valueOf(10.0));
        columns.get(2).setPrefWidth(Double.valueOf(10.0));
        columns.get(3).setPrefWidth(Double.valueOf(10.0));
        columns.get(4).setPrefWidth(Double.valueOf(8.0));
        columns.get(5).setPrefWidth(Double.valueOf(8.0));
        columns.get(6).setPrefWidth(Double.valueOf(6.0));
        columns.get(7).setPrefWidth(Double.valueOf(6.0));
        columns.get(8).setPrefWidth(Double.valueOf(6.0));
        columns.get(9).setPrefWidth(Double.valueOf(6.0));
        columns.get(11).setPrefWidth(Double.valueOf(7.0));
    }

    private void getEventHandlerForUdidTable(OrganizationSpaceController controller, TableRowEvent event) {
        int idx;
        TableWidget udidsTable = (TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent();
        for (int i = 0; i < udidsTable.getRowsCount(); ++i) {
            int index = i;
            ((DictBoxWidget)((DictBoxWidgetColumn)udidsTable.getColumn("category")).getWidget(i)).valueProperty().addListener((obj, oldValue, newValue) -> {
                TextFieldWidget nameWidget = (TextFieldWidget)((TextWidgetColumn)udidsTable.getColumn("name")).getWidget(index);
                if ((nameWidget.getValue() == null || nameWidget.getValue().isEmpty()) && newValue != null) {
                    if (newValue.getCaption() != null && newValue.getCaption().length() > 0) {
                        nameWidget.setValue(newValue.getCaption());
                    } else {
                        nameWidget.setValue(newValue.getCode());
                    }
                }
            });
            ((HyperlinkWidget)((HyperlinkWidgetColumn)udidsTable.getColumn("detailsLink")).getWidget(i)).setOnAction(innerEvent -> {
                CompactGroupsWidget detailsWidget = (CompactGroupsWidget)((OrganizationUdidsDetailsPanel)controller.getView().getUdidsDetailsTile().getFullNode()).getExtraParametersCard().getContent();
                ObservableList list = detailsWidget.getViews();
                if (list.size() > index) {
                    detailsWidget.selectView((Node)detailsWidget.getViews().get(index));
                    controller.getView().expand(controller.getView().getUdidsDetailsTile());
                }
            });
            ((DictBoxWidget)((DictBoxWidgetColumn)udidsTable.getColumn("category")).getWidget(i)).setValueSelectionListener(item -> {
                OrganizationUdidsDetailsUdidTypeContainer cont = (OrganizationUdidsDetailsUdidTypeContainer)((OrganizationUdidsDetailsExtraPanel)((CompactGroupsWidget)((OrganizationUdidsDetailsPanel)((OrganizationSpace)Objects.requireNonNull(RootEntityPane.lookup((Node)controller.getView())).getEditor()).getUdidsDetailsTile().getFullNode()).getExtraParametersCard().getContent()).getViews().get(index)).getUdidTypeCard().getContent();
                cont.getCategoryHiddenNode().setValue(item == null ? null : item.getReference());
                cont.getSabreNameNode().setValue(null);
                cont.getShortSabreNameNode().setValue(null);
            });
            int finalI = i;
            ((BooleanValueWidget)((BooleanValueWidgetColumn)udidsTable.getColumn("dependant")).getWidget(i)).valueProperty().addListener((s, o, n) -> OrganizationStatisticControllerInterceptor.updateUdidDetail(controller, finalI));
        }
        if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
            idx = event.getRowIndex();
            OrganizationStatisticControllerInterceptor.updateWidget(controller, idx);
            OrganizationUdidVM vm = (OrganizationUdidVM)((TableWidget)((OrganizationUdidsPanel)controller.getView().getUdidsTile().getFullNode()).getGeneralCard().getContent()).getData(idx);
            String uid2 = vm.getUid();
            if (uid2 == null) {
                uid2 = UUIDGenerator.generate((boolean)false).toString();
                vm.setUid(uid2);
            }
            OrganizationUdidsDetailsExtraPanel organizationUdidsDetailsPanel = new OrganizationUdidsDetailsExtraPanel(false);
            organizationUdidsDetailsPanel.getProperties().put((Object)"model-uid", (Object)uid2);
            ((CompactGroupsWidget)((OrganizationUdidsDetailsPanel)controller.getView().getUdidsDetailsTile().getFullNode()).getExtraParametersCard().getContent()).getViews().add(idx, (Object)organizationUdidsDetailsPanel);
            OrganizationStatisticControllerInterceptor.updateUdidDetail(controller, idx);
        }
        if (event.getEventType().equals(TableRowEvent.ROW_REMOVE)) {
            idx = event.getRowIndex();
            ObservableList list = ((CompactGroupsWidget)((OrganizationUdidsDetailsPanel)controller.getView().getUdidsDetailsTile().getFullNode()).getExtraParametersCard().getContent()).getViews();
            List uidsPresent = ((TableWidget)controller.getUdidsFull().getView().getGeneralCard().getContent()).getRowsData().stream().map(BaseVM::getUid).filter(Objects::nonNull).collect(Collectors.toList());
            ((CompactGroupsWidget)controller.getUdidsDetailsFull().getView().getExtraParametersCard().getContent()).getViews().forEach(p -> {
                TableWidgetColumn relatedCostCodesColumn = ((TableWidget)p.getUdidValuesCard().getContent()).getColumn("relatedCostCodeProperties");
                if (relatedCostCodesColumn.isHidden()) {
                    return;
                }
                for (int i = 0; i < ((TableWidget)p.getUdidValuesCard().getContent()).getRowsCount(); ++i) {
                    int finalI = i;
                    ((ValuesWidget)relatedCostCodesColumn.getWidget(i)).getValues().stream().filter(vm -> !uidsPresent.contains(vm.getUid())).findFirst().ifPresent(vm -> ((ValuesWidget)relatedCostCodesColumn.getWidget(finalI)).getValues().remove(vm));
                }
            });
            if (list.size() > idx) {
                HashSet uidsToCheck = new HashSet();
                for (int i = 0; i < ((TableWidget)((OrganizationUdidsDetailsExtraPanel)((CompactGroupsWidget)controller.getUdidsDetailsFull().getView().getExtraParametersCard().getContent()).getViews().get(idx)).getUdidValuesCard().getContent()).getRowsCount(); ++i) {
                    uidsToCheck.addAll(OrganizationStatisticControllerInterceptor.getRelatedCostCodeProperties(controller, idx).stream().map(OrganizationRelatedCostCodePropertiesVM::getUid).distinct().collect(Collectors.toList()));
                }
                ((CompactGroupsWidget)((OrganizationUdidsDetailsPanel)controller.getView().getUdidsDetailsTile().getFullNode()).getExtraParametersCard().getContent()).getViews().remove(idx);
                uidsToCheck.forEach(uid -> OrganizationStatisticControllerInterceptor.checkDeletion(controller, uid));
            }
        }
    }
}

