/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.transfers.entity.handlers;

import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferAdditionalServiceVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripCostSumPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripTicketInfoPaneVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler.TransferFXHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalService;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.uidata.TransferProductXtripUIData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.transfers.CommonTransfersHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class TransferProductFXHandler
extends TransferFXHandler {
    public void toVM(Transfer product, TransferProductXtripUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        super.toVM(product, productData, vm, customerProfile);
        boolean negate = product.getStatus() == ProductStatus.REFUND;
        VMHelper.transfer((Collection)product.getAdditionalServices(), (Collection)((BookingFileProductTransferXtripPanelVM)vm).getAdditionalServices(), el -> new BookingFileProductTransferAdditionalServiceVM(), (mod, modVM) -> {
            modVM.setType(mod.getType());
            modVM.setAmount(TransferProductFXHandler.getValue(mod.getPrice(), negate));
            modVM.setCurrency(mod.getCurrency());
            modVM.setVat(TransferProductFXHandler.getValue(mod.getEquivalentVatAmount(), negate));
            modVM.setVatRate(mod.getEquivalentVatRate());
        });
        ((BookingFileProductTransferXtripPanelVM)vm).getGeneral().getTravelerInfo().setTableCaption(product.getTableCaption());
        BookingFileProductTransferXtripTicketInfoPaneVM ticketInfoVM = ((BookingFileProductTransferXtripPanelVM)vm).getGeneral().getTicketInfo();
        ticketInfoVM.setTransferTypeValue(product.getTransferType());
        BookingFileProductTransferXtripCostSumPaneVM sumVM = ((BookingFileProductTransferXtripPanelVM)vm).getCost().getSum();
        BigDecimal additionalSum = CommonTransfersHelper.getAdditionalServiceSum((Transfer)product);
        sumVM.setAdditionalSum(TransferProductFXHandler.getValue(additionalSum, negate));
        BigDecimal vatIncludedAdditional = CommonTransfersHelper.getAdditionalServiceIncludedVatSum((Transfer)product);
        sumVM.setVatIncludedAdditional(TransferProductFXHandler.getValue(vatIncludedAdditional, negate));
        String additionalCurrency = product.getAdditionalServices().stream().map(AdditionalService::getCurrency).filter(Objects::nonNull).findFirst().orElse(null);
        sumVM.setAdditionalCurrency(additionalCurrency);
        sumVM.setTotalSum(CommonTransfersHelper.getTotalPrice((Transfer)product));
        BigDecimal baseVatTotal = Optional.ofNullable(product.getEquivalentFareVatValue()).map(VatValue::getAmount).orElse(BigDecimal.ZERO);
        sumVM.setVatIncludedTotal(TransferProductFXHandler.getValue(baseVatTotal.add(CommonTransfersHelper.getAdditionalServiceIncludedVatSum((Transfer)product)), negate));
    }

    public void fromVM(BaseProductVM vm, Transfer product, TransferProductXtripUIData productData) {
        super.fromVM(vm, product, productData);
        BookingFileProductTransferXtripPanelVM productVM = (BookingFileProductTransferXtripPanelVM)vm;
        product.setTransferType(productVM.getGeneral().getTicketInfo().getTransferTypeValue());
        product.setTableCaption(productVM.getGeneral().getTravelerInfo().getTableCaption());
        VMHelper.transfer((Collection)((BookingFileProductTransferXtripPanelVM)vm).getAdditionalServices(), (Collection)product.getAdditionalServices(), el -> new AdditionalService(), (modVM, mod) -> {
            mod.setType(modVM.getType());
            mod.setPrice(modVM.getAmount());
            mod.setCurrency(modVM.getCurrency());
            mod.setEquivalentVatAmount(modVM.getVat());
            mod.setEquivalentVatRate(modVM.getVatRate());
        });
    }

    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }
}

