/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common;

import com.gridnine.xtrip.common.Environment;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public interface TimeService {
    public static TimeService get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return Environment.getPublished(TimeService.class);
    }

    public Date currentDate();

    default public long currentTimeMillis() {
        return this.currentDate().getTime();
    }

    default public ZonedDateTime getCurrentZonedDateTime() {
        return ZonedDateTime.ofInstant(this.currentDate().toInstant(), ZoneId.systemDefault());
    }

    public static class Holder {
        public static final TimeService INSTANCE = Environment.getPublished(TimeService.class);
    }
}

