/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen;

import com.gridnine.xtrip.common.gen.GenUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Stack;

public class JavaWriter {
    private static final String NL = System.getProperty("line.separator");
    private String compilationUnit;
    private Writer writer;
    private final Stack<String> blockStack = new Stack();

    public void beginCompilationUnit(File baseFolder, String fullName) throws IOException {
        File folder;
        this.compilationUnit = fullName;
        String packageName = GenUtil.getPackageName(this.compilationUnit);
        File file = folder = packageName == null ? baseFolder : new File(baseFolder, packageName.replace(".", File.separator));
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new IOException("failed creating folder " + folder);
        }
        File file2 = new File(folder, GenUtil.getSimpleClassName(this.compilationUnit) + ".java");
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "utf-8");
        this.header();
    }

    public void endCompilationUnit() throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException("no compilation unit started");
        }
        while (!this.blockStack.isEmpty()) {
            this.code(this.blockStack.pop(), new Object[0]);
        }
        this.writer.close();
        this.writer = null;
        this.compilationUnit = null;
    }

    public void code(String codeLine, Object ... args) throws IOException {
        for (int i = 0; i < this.blockStack.size(); ++i) {
            this.writer.append("    ");
        }
        this.writer.append(args == null || args.length == 0 ? codeLine : String.format(codeLine, args)).append(NL);
    }

    public void comment(String text, Object ... args) throws IOException {
        this.code("// " + text, args);
    }

    public void doc(String text, Object ... args) throws IOException {
        this.code("/** " + text + " */", args);
    }

    public void blank() throws IOException {
        this.writer.append(NL);
    }

    public void beginBlock() throws IOException {
        this.code("{", new Object[0]);
        this.blockStack.push("}");
    }

    public void beginBlock(String code, Object ... args) throws IOException {
        this.code(code + " {", args);
        this.blockStack.push("}");
    }

    public void restartBlock(String code, Object ... args) throws IOException {
        this.code(this.blockStack.pop() + ' ' + code + " {", args);
        this.blockStack.push("}");
    }

    public void endBlock() throws IOException {
        this.endBlock(null);
    }

    public void endBlock(String suffix) throws IOException {
        String codeLine = this.blockStack.pop();
        this.code(codeLine + (suffix == null ? "" : suffix), new Object[0]);
        if (!codeLine.endsWith(";")) {
            this.writer.append(NL);
        }
    }

    private void header() throws IOException {
        this.code("/*********************************************************", new Object[0]);
        this.code(" * Gridnine AB http://www.gridnine.com", new Object[0]);
        this.code(" * This is automatically generated file.", new Object[0]);
        this.code(" * Don't change it manually to avoid losing modifications.", new Object[0]);
        this.code(" ********************************************************/", new Object[0]);
        String packageName = GenUtil.getPackageName(this.compilationUnit);
        if (packageName != null) {
            this.code("package %s;", packageName);
        }
        this.writer.append(NL);
    }
}

