/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.model;

import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.gen.model.ModelCodeGenHelper;
import com.gridnine.xtrip.common.meta.BaseProperty;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.ValidationContext;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

public class ValidationContextGenerator {
    public static void generateValidationContextClass(JavaWriter writer, GenerationContext ctx, EntityType ett) throws Exception {
        String vcExtends = "";
        if (!TextUtil.isBlank(ett.getExtendsId())) {
            EntityType extendsType = ModelCodeGenHelper.getEntityType(ctx, ett.getExtendsId());
            if (null == extendsType) {
                throw new IllegalArgumentException("type not found " + ett.getExtendsId());
            }
            if (!ModelCodeGenHelper.isValidatable(extendsType, ctx)) {
                throw new IllegalArgumentException(String.format("super type %s of validatable entity %s must be validatable", ett.getExtendsId(), ett.getId()));
            }
            vcExtends = " extends " + ett.getExtendsId() + "." + ModelCodeGenHelper.genValidationContextClassName(ett.getExtendsId());
        }
        writer.beginBlock("public static class %s%s implements %s", ModelCodeGenHelper.genValidationContextClassName(ett.getId()), vcExtends, ValidationContext.class.getName());
        writer.comment("BEGIN properties", new Object[0]);
        for (Property prop : ett.getProperties().values()) {
            ValidationContextGenerator.generateValidatablePropertyAccessor(writer, prop, ctx);
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (EntityCollection coll : ett.getCollections().values()) {
            ValidationContextGenerator.generateValidatableCollectionAccessors(writer, coll, ett, ctx);
        }
        writer.comment("END collections", new Object[0]);
        writer.beginBlock("public %s<%s> getValidationMessages(final String memberId)", Collection.class.getName(), ValidationMessage.class.getName());
        writer.beginBlock("switch(memberId)", new Object[0]);
        writer.comment("BEGIN properties", new Object[0]);
        for (Property prop : ett.getProperties().values()) {
            writer.beginBlock("case \"%s\":", prop.getId());
            writer.code("return get%sValidationMessages();", GenUtil.capitalize(prop.getId()));
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (EntityCollection coll : ett.getCollections().values()) {
            writer.beginBlock("case \"%s\":", coll.getId());
            writer.code("return get%sValidationMessages();", GenUtil.capitalize(coll.getId()));
            writer.endBlock();
        }
        writer.comment("END collections", new Object[0]);
        writer.beginBlock("default:", new Object[0]);
        if (TextUtil.isBlank(vcExtends)) {
            writer.code("throw new IllegalArgumentException(\"unknown memberId \" + memberId);", new Object[0]);
        } else {
            writer.code("return super.getValidationMessages(memberId);", new Object[0]);
        }
        writer.endBlock();
        writer.endBlock();
        writer.endBlock();
        writer.beginBlock("public %s<%s, %s<%s>> getValidationMessagesForSimpleCollection(final String collectionId)", Map.class.getName(), Integer.class.getName(), Collection.class.getName(), ValidationMessage.class.getName());
        writer.beginBlock("switch(collectionId)", new Object[0]);
        for (EntityCollection coll : ett.getCollections().values()) {
            EntityType elementEt = ctx.getMetaRegistry().getEntities().get(coll.getElementType());
            writer.beginBlock("case \"%s\":", coll.getId());
            writer.code("return get%sListValidationMessages();", GenUtil.capitalize(coll.getId()));
            writer.endBlock();
        }
        writer.beginBlock("default:", new Object[0]);
        if (TextUtil.isBlank(vcExtends)) {
            writer.code("throw new IllegalArgumentException(\"unknown collectionId \" + collectionId);", new Object[0]);
        } else {
            writer.code("return super.getValidationMessagesForSimpleCollection(collectionId);", new Object[0]);
        }
        writer.endBlock();
        writer.endBlock();
        writer.endBlock();
        writer.endBlock();
    }

    private static void generateValidatableCollectionAccessors(JavaWriter writer, EntityCollection coll, EntityType ett, GenerationContext ctx) throws Exception {
        String variableType = String.format("%s<%s>", Collection.class.getName(), ValidationMessage.class.getName());
        String variableInstance = String.format("%s<%s>", HashSet.class.getName(), ValidationMessage.class.getName());
        ModelCodeGenHelper.maybeDeprecated(coll, writer);
        writer.code("private %s %sValidationMessages;", variableType, coll.getId());
        writer.blank();
        ModelCodeGenHelper.maybeDeprecated(coll, writer);
        writer.beginBlock("public %s get%sValidationMessages()", variableType, GenUtil.capitalize(coll.getId()));
        writer.beginBlock("if (%sValidationMessages == null)", coll.getId());
        writer.code("%sValidationMessages = new %s();", coll.getId(), variableInstance);
        writer.endBlock();
        writer.code("return %sValidationMessages;", coll.getId());
        writer.endBlock();
        variableType = String.format("%s<%s, %s<%s>>", Map.class.getName(), Integer.class.getName(), Collection.class.getName(), ValidationMessage.class.getName());
        variableInstance = String.format("%s<%s, %s<%s>>", HashMap.class.getName(), Integer.class.getName(), Collection.class.getName(), ValidationMessage.class.getName());
        ModelCodeGenHelper.maybeDeprecated(coll, writer);
        writer.code("private %s %sListValidationMessages;", variableType, coll.getId());
        writer.blank();
        ModelCodeGenHelper.maybeDeprecated(coll, writer);
        writer.beginBlock("public %s get%sListValidationMessages()", variableType, GenUtil.capitalize(coll.getId()));
        writer.beginBlock("if (%sListValidationMessages == null)", coll.getId());
        writer.code("%sListValidationMessages = new %s();", coll.getId(), variableInstance);
        writer.endBlock();
        writer.code("return %sListValidationMessages;", coll.getId());
        writer.endBlock();
    }

    private static void generateValidatablePropertyAccessor(JavaWriter writer, BaseProperty prop, GenerationContext ctx) throws Exception {
        writer.code("private %s<%s> %sValidationMessages;", Collection.class.getName(), ValidationMessage.class.getName(), prop.getId());
        writer.blank();
        ModelCodeGenHelper.maybeDeprecated(prop, writer);
        writer.beginBlock("public %s<%s> get%sValidationMessages()", Collection.class.getName(), ValidationMessage.class.getName(), GenUtil.capitalize(prop.getId()));
        writer.beginBlock("if (%sValidationMessages == null)", prop.getId());
        writer.code("%sValidationMessages = new %s<%s>();", prop.getId(), LinkedHashSet.class.getName(), ValidationMessage.class.getName());
        writer.endBlock();
        writer.code("return %sValidationMessages;", prop.getId());
        writer.endBlock();
    }
}

