/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.rest;

import com.gridnine.xtrip.common.gen.CodeGen;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.gen.rest.RestCodeGenHelper;
import com.gridnine.xtrip.common.gen.rest.RestCodeGenUtils;
import com.gridnine.xtrip.common.gen.rest.RestEntityGeneric;
import com.gridnine.xtrip.common.gen.rest.ValidationContextGenerator;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.reflection.MetaReflectionHelper;
import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestEnumItem;
import com.gridnine.xtrip.common.meta.rest.RestEnumProperty;
import com.gridnine.xtrip.common.meta.rest.RestEnumType;
import com.gridnine.xtrip.common.meta.rest.RestInformationMessageItem;
import com.gridnine.xtrip.common.meta.rest.RestInformationMessagesType;
import com.gridnine.xtrip.common.meta.rest.RestInterfaceType;
import com.gridnine.xtrip.common.meta.rest.RestMap;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistryHelper;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.meta.rest.RestValidationMessageItem;
import com.gridnine.xtrip.common.meta.rest.RestValidationMessagesType;
import com.gridnine.xtrip.common.model.rest.ValidationContext;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.model.validation.ValidationMessagesFactory;
import com.gridnine.xtrip.common.rest.BaseRestEntity;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.common.rest.InformationMessagesFactory;
import com.gridnine.xtrip.common.rest.util.PropertyValue;
import com.gridnine.xtrip.common.rest.util.ShortName;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestCodeGen
implements CodeGen {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String OMIT_XSS_PROTECTION_FIELD = "omitXssProtection";

    @Override
    public void generate(GenerationContext ctx) throws Exception {
        JavaWriter writer = new JavaWriter();
        for (RestEnumType enm : ctx.getRestMetaRegistry().getEnums().values()) {
            if (!ctx.getRestElementsFilter().accept(enm)) continue;
            this.generateEnum(writer, ctx, enm);
        }
        for (RestEntityType ett : ctx.getRestMetaRegistry().getEntities().values()) {
            if (!ctx.getRestElementsFilter().accept(ett)) continue;
            System.out.println("generate entity " + ett.getId());
            this.generateEntity(writer, ctx, ett);
        }
        for (RestEntityType parent : ctx.getRestMetaRegistry().getEntities().values()) {
            if (!ctx.getRestElementsFilter().accept(parent)) continue;
            System.out.println("populating descendants " + parent.getId());
            ctx.getRestMetaRegistry().getEntities().values().stream().filter(child -> StringUtils.isNotBlank((String)child.getExtendsId())).filter(child -> child.getExtendsId().equals(parent.getId())).forEach(child -> parent.getDescendants().add(child.getId()));
        }
        for (RestValidationMessagesType vmt : ctx.getRestMetaRegistry().getValidationMessages().values()) {
            if (!ctx.getRestElementsFilter().accept(vmt)) continue;
            this.generateValidationMessages(writer, ctx, vmt);
        }
        for (RestInformationMessagesType imt : ctx.getRestMetaRegistry().getInformationMessages().values()) {
            if (!ctx.getRestElementsFilter().accept(imt)) continue;
            this.generateInformationMessages(writer, ctx, imt);
        }
        for (RestInterfaceType it : ctx.getRestMetaRegistry().getInterfaces().values()) {
            if (!ctx.getRestElementsFilter().accept(it)) continue;
            this.generateInterface(writer, ctx, it);
        }
    }

    private void generateEnum(JavaWriter writer, GenerationContext ctx, RestEnumType enm) throws IOException {
        this.log.debug(String.format("generating enum %s", enm.getId()));
        writer.beginCompilationUnit(ctx.getOutFolder(), enm.getId());
        RestCodeGenHelper.generateTypeDoc(writer, ctx, enm, "Enum", enm.getDocumentation());
        if (enm.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.setLength(0);
        buffer.append(StringUtils.join(enm.getInterfaces(), (String)", "));
        if (enm.isShortName()) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(ShortName.class.getName());
        }
        if (enm.isPropertyValue()) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(PropertyValue.class.getName());
        }
        if (buffer.length() > 0) {
            buffer.insert(0, "implements ");
        }
        writer.beginBlock("public enum %s %s", GenUtil.getSimpleClassName(enm.getId()), buffer);
        buffer.setLength(0);
        writer.comment("BEGIN items", new Object[0]);
        if (!CollectionUtil.isEmptyMap(enm.getItems())) {
            int i = 1;
            for (RestEnumItem item : enm.getItems().values()) {
                String doc = RestMetaRegistryHelper.joinStrings(" ", item.getDocumentation(), ctx.getDocLang());
                if (!TextUtil.isBlank(doc)) {
                    writer.doc(doc, new Object[0]);
                }
                buffer.setLength(0);
                buffer.append(item.getId());
                if (!CollectionUtil.isEmpty(item.getValues())) {
                    if (enm.getProperties().size() != item.getValues().size()) {
                        throw new IllegalArgumentException(String.format("enum=[%s] item.values.size != enum.properties.size", enm.getId()));
                    }
                    buffer.append('(');
                    buffer.append(StringUtils.join(item.getValues(), (String)", "));
                    buffer.append(')');
                }
                if (i++ == enm.getItems().size()) {
                    buffer.append(';');
                } else {
                    buffer.append(',');
                }
                writer.code("%s", buffer);
            }
        } else {
            writer.code(";", new Object[0]);
        }
        writer.comment("END items", new Object[0]);
        buffer.setLength(0);
        if (!CollectionUtil.isEmpty(enm.getProperties().values())) {
            writer.blank();
            writer.comment("BEGIN properties", new Object[0]);
            for (RestEnumProperty property : enm.getProperties().values()) {
                String doc = RestMetaRegistryHelper.joinStrings(" ", property.getDocumentation(), ctx.getDocLang());
                if (!TextUtil.isBlank(doc)) {
                    writer.doc(doc, new Object[0]);
                }
                if (property.isDeprecated()) {
                    writer.code("@Deprecated", new Object[0]);
                }
                String javaType = MetaReflectionHelper.getJavaTypeForRest(property.getType(), ctx.getMetaRegistry(), ctx.getRestMetaRegistry(), false);
                writer.code("private %s %s;", javaType, property.getId());
                writer.blank();
                if (!TextUtil.isBlank(doc)) {
                    writer.doc(doc, new Object[0]);
                }
                if (property.isDeprecated()) {
                    writer.code("@Deprecated", new Object[0]);
                }
                String getter = this.getGetterName(property.getId(), "boolean".equals(property.getType()) ? "is" : "get");
                writer.beginBlock("public %s %s()", javaType, getter);
                writer.code("return this.%s;", property.getId());
                writer.endBlock();
            }
            writer.comment("END properties", new Object[0]);
            writer.blank();
        }
        buffer.setLength(0);
        if (!CollectionUtil.isEmpty(enm.getProperties().values())) {
            writer.blank();
            writer.comment("BEGIN constructor", new Object[0]);
            for (RestEnumProperty property : enm.getProperties().values()) {
                String javaType = MetaReflectionHelper.getJavaTypeForRest(property.getType(), ctx.getMetaRegistry(), ctx.getRestMetaRegistry(), false);
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(String.format("final %s %s", javaType, property.getId()));
            }
            writer.beginBlock("private %s(%s)", GenUtil.getSimpleClassName(enm.getId()), buffer);
            buffer.setLength(0);
            for (RestEnumProperty property : enm.getProperties().values()) {
                writer.code("this.%1$s = %1$s;", property.getId());
            }
            writer.endBlock();
            writer.comment("END constructor", new Object[0]);
            writer.blank();
        }
        if (!TextUtil.isBlank(enm.getCodeFragment())) {
            writer.comment("BEGIN code fragment", new Object[0]);
            writer.code(enm.getCodeFragment(), new Object[0]);
            writer.blank();
            writer.comment("END code fragment", new Object[0]);
        }
        writer.beginBlock("public String toString()", new Object[0]);
        writer.code("%s et = %s.get().getEnums().get(getClass().getName());", RestEnumType.class.getName(), RestMetaRegistry.class.getName());
        writer.beginBlock("if (et == null)", new Object[0]);
        writer.code("return name();", new Object[0]);
        writer.endBlock();
        writer.code("%s ei = et.getItems().get(name());", RestEnumItem.class.getName());
        writer.code("return (ei == null) ? name() : ei.getDisplayName();", new Object[0]);
        writer.endBlock();
        buffer.setLength(0);
        if (enm.isShortName()) {
            writer.blank();
            writer.comment("BEGIN shortName()", new Object[0]);
            writer.beginBlock("public String getShortName()", new Object[0]);
            writer.code("%s et = %s.get().getEnums().get(getClass().getName());", RestEnumType.class.getName(), RestMetaRegistry.class.getName());
            writer.beginBlock("if (et == null)", new Object[0]);
            writer.code("return name();", new Object[0]);
            writer.endBlock();
            writer.code("%s ei = et.getItems().get(name());", RestEnumItem.class.getName());
            writer.code("return (ei == null) ? name() : ei.getShortName();", new Object[0]);
            writer.endBlock();
            writer.comment("BEGIN shortName()", new Object[0]);
            writer.blank();
        }
        buffer.setLength(0);
        if (enm.isPropertyValue()) {
            writer.blank();
            writer.comment("BEGIN getProperty()", new Object[0]);
            writer.beginBlock("public Object getProperty(final String name) throws IllegalArgumentException", new Object[0]);
            for (RestEnumProperty property : enm.getProperties().values()) {
                writer.beginBlock("if(\"%s\".equals(name))", property.getId());
                writer.code("return this.%s;", property.getId());
                writer.endBlock();
            }
            writer.code("throw new IllegalArgumentException(\"unknown property \" + name);", new Object[0]);
            writer.endBlock();
            writer.comment("END getProperty()", new Object[0]);
            writer.blank();
        }
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generateEntity(JavaWriter writer, GenerationContext ctx, RestEntityType ett) throws Exception {
        boolean messagesGenerated;
        this.log.debug("generating entity " + ett.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), ett.getId());
        RestCodeGenHelper.generateTypeDoc(writer, ctx, ett, "Entity", ett.getDocumentation());
        RestEntityGeneric entityGeneric = new RestEntityGeneric(ett);
        RestEntityType parent = RestCodeGenUtils.getParent(ctx, ett);
        RestEntityGeneric parentGeneric = parent != null ? new RestEntityGeneric(parent) : null;
        StringBuilder buffer = new StringBuilder();
        buffer.setLength(0);
        buffer.append("public ");
        if (ett.isAbstract()) {
            buffer.append("abstract ");
        }
        buffer.append("class ");
        buffer.append(GenUtil.getSimpleClassName(ett.getId()));
        buffer.append(RestCodeGenUtils.getEntityGeneric(entityGeneric));
        buffer.append(' ');
        buffer.append("extends ");
        if (parent == null) {
            buffer.append(BaseRestEntity.class.getName());
        } else {
            buffer.append(parent.getId());
            buffer.append(RestCodeGenUtils.getExtendGeneric(ctx, ett, parentGeneric));
        }
        buffer.append(' ');
        buffer.append(RestCodeGenUtils.getImplements(ctx, ett));
        if (ett.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock(buffer.toString(), new Object[0]);
        writer.code("private static final long serialVersionUID = %sL;", RestCodeGenHelper.generateSerialVersionUID(ett));
        writer.blank();
        boolean bl = messagesGenerated = ett.isWithMessages() && !RestCodeGenHelper.isParentWithMessages(ett, ctx.getRestMetaRegistry());
        if (messagesGenerated) {
            writer.code("private final %s<%s> messages = new %1$s<%2$s>();", ArrayList.class.getName(), InformationMessage.class.getName());
            writer.blank();
            writer.beginBlock("public %s<%s> getMessages()", List.class.getName(), InformationMessage.class.getName());
            writer.code("return messages;", new Object[0]);
            writer.endBlock();
        }
        writer.comment("BEGIN properties", new Object[0]);
        Iterator<RestMap> omitXssProtectionProp = null;
        for (RestProperty prop : ett.getProperties().values()) {
            if (RestCodeGenUtils.writeProperty(prop, parentGeneric)) {
                this.generateAccessors(writer, prop, ctx, entityGeneric);
            }
            if (!prop.isXssProtected() || omitXssProtectionProp != null) continue;
            omitXssProtectionProp = new RestProperty(prop.getOwner());
            ((BaseMetaElement)((Object)omitXssProtectionProp)).setId(OMIT_XSS_PROTECTION_FIELD);
            ((RestProperty)((Object)omitXssProtectionProp)).setType("boolean");
            ((RestProperty)((Object)omitXssProtectionProp)).setDefaultValue("false");
        }
        if (omitXssProtectionProp != null && RestCodeGenUtils.writeProperty(omitXssProtectionProp, parentGeneric)) {
            this.generateAccessors(writer, (RestProperty)((Object)omitXssProtectionProp), ctx, entityGeneric);
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (RestCollection coll : ett.getCollections().values()) {
            if (!RestCodeGenUtils.writeCollection(coll, parentGeneric)) continue;
            this.generateAccessors(writer, coll, ctx, entityGeneric);
        }
        writer.comment("END collections", new Object[0]);
        writer.comment("BEGIN maps", new Object[0]);
        for (RestMap map : ett.getMaps().values()) {
            this.generateAccessors(writer, map, ctx);
        }
        writer.comment("END maps", new Object[0]);
        if (!TextUtil.isBlank(ett.getCodeFragment())) {
            writer.comment("BEGIN code fragment", new Object[0]);
            writer.code(ett.getCodeFragment(), new Object[0]);
            writer.blank();
            writer.comment("END code fragment", new Object[0]);
        }
        if (RestCodeGenHelper.isValidatable(ett, ctx.getRestMetaRegistry())) {
            String validContextType = RestCodeGenHelper.genValidationContextClassName(ett.getId());
            String validContextName = "validationContext";
            writer.code("private final %s %s = new %s();", validContextType, "validationContext", validContextType);
            writer.blank();
            writer.beginBlock("public %s get%s()", validContextType, GenUtil.capitalize(MiscUtil.getSimpleClassName(ValidationContext.class)));
            writer.code("return %s;", "validationContext");
            writer.endBlock();
        }
        writer.beginBlock("public Object getValue(final String memberId)", ett.getId());
        if (messagesGenerated) {
            writer.beginBlock("if (\"messages\".equals(memberId))", new Object[0]);
            writer.code("return this.messages;", new Object[0]);
            writer.endBlock();
        }
        writer.comment("BEGIN properties", new Object[0]);
        for (RestProperty prop : ett.getProperties().values()) {
            if (!RestCodeGenUtils.writeProperty(prop, parentGeneric)) continue;
            writer.beginBlock("if (\"%s\".equals(memberId))", prop.getId());
            writer.code("return this.%s;", prop.getId());
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (RestCollection coll : ett.getCollections().values()) {
            if (!RestCodeGenUtils.writeCollection(coll, parentGeneric)) continue;
            writer.beginBlock("if (\"%s\".equals(memberId))", coll.getId());
            writer.code("return this.%s;", coll.getId());
            writer.endBlock();
        }
        writer.comment("END collections", new Object[0]);
        writer.comment("BEGIN maps", new Object[0]);
        for (RestMap map : ett.getMaps().values()) {
            writer.beginBlock("if (\"%s\".equals(memberId))", map.getId());
            writer.code("return this.%s;", map.getId());
            writer.endBlock();
        }
        writer.comment("END maps", new Object[0]);
        writer.code("return super.getValue(memberId);", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public void setValue(final String memberId, Object value)", ett.getId());
        writer.comment("BEGIN properties", new Object[0]);
        for (RestProperty prop : ett.getProperties().values()) {
            if (!RestCodeGenUtils.writeProperty(prop, parentGeneric)) continue;
            String type = this.getJavaType(ctx, entityGeneric.getProperties(), prop.getId(), prop.getType(), prop.isOptional());
            writer.beginBlock("if (\"%s\".equals(memberId))", prop.getId());
            writer.code("this.%s = (%s) value;", prop.getId(), type);
            writer.code("return;", new Object[0]);
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.code("super.setValue(memberId, value);", new Object[0]);
        writer.endBlock();
        if (RestCodeGenHelper.isValidatable(ett, ctx.getRestMetaRegistry())) {
            ValidationContextGenerator.generateValidationContextClass(writer, ctx, ett);
        }
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generateValidationMessages(JavaWriter writer, GenerationContext ctx, RestValidationMessagesType vmt) throws IOException {
        this.log.debug("generating validation messages " + vmt.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), vmt.getId());
        RestCodeGenHelper.generateTypeDoc(writer, ctx, vmt, "Validation messages", Collections.emptyList());
        if (vmt.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public final class %s extends %s", GenUtil.getSimpleClassName(vmt.getId()), ValidationMessagesFactory.class.getName());
        for (RestValidationMessageItem item : vmt.getMessages().values()) {
            String spec = "";
            String args = "";
            for (Map.Entry<String, String> entry : item.getParameters().entrySet()) {
                if (spec.length() > 0) {
                    spec = spec + ", ";
                }
                spec = spec + MetaReflectionHelper.getJavaTypeForRest(entry.getValue(), ctx.getMetaRegistry(), ctx.getRestMetaRegistry(), false) + ' ' + entry.getKey();
                args = args + ", " + entry.getKey();
            }
            String doc = RestMetaRegistryHelper.joinStrings(" ", item.getDocumentation(), ctx.getDocLang());
            if (!TextUtil.isBlank(doc)) {
                writer.doc(doc, new Object[0]);
            }
            if (item.isDeprecated()) {
                writer.code("@Deprecated", new Object[0]);
            }
            String getter = this.getGetterName(item.getId(), "get");
            writer.beginBlock("public static %s %s(%s)", ValidationMessage.class.getName(), getter, spec);
            writer.code("return getMessage(\"%s\", \"%s\"%s);", vmt.getId(), item.getId(), args);
            writer.endBlock();
        }
        writer.beginBlock("private %s()", GenUtil.getSimpleClassName(vmt.getId()));
        writer.comment("no-op", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generateInformationMessages(JavaWriter writer, GenerationContext ctx, RestInformationMessagesType imt) throws IOException {
        this.log.debug("generating information messages " + imt.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), imt.getId());
        RestCodeGenHelper.generateTypeDoc(writer, ctx, imt, "Information messages", Collections.emptyList());
        if (imt.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public final class %s extends %s", GenUtil.getSimpleClassName(imt.getId()), InformationMessagesFactory.class.getName());
        for (RestInformationMessageItem item : imt.getMessages().values()) {
            String spec = "";
            String args = "";
            for (Map.Entry<String, String> entry : item.getParameters().entrySet()) {
                if (spec.length() > 0) {
                    spec = spec + ", ";
                }
                spec = spec + MetaReflectionHelper.getJavaTypeForRest(entry.getValue(), ctx.getMetaRegistry(), ctx.getRestMetaRegistry(), false) + ' ' + entry.getKey();
                args = args + ", " + entry.getKey();
            }
            String doc = RestMetaRegistryHelper.joinStrings(" ", item.getDocumentation(), ctx.getDocLang());
            if (!TextUtil.isBlank(doc)) {
                writer.doc(doc, new Object[0]);
            }
            if (item.isDeprecated()) {
                writer.code("@Deprecated", new Object[0]);
            }
            String getter = this.getGetterName(item.getId(), "get");
            writer.beginBlock("public static %s %s(%s)", InformationMessage.class.getName(), getter, spec);
            writer.code("return getMessage(\"%s\", \"%s\"%s);", imt.getId(), item.getId(), args);
            writer.endBlock();
        }
        writer.beginBlock("private %s()", GenUtil.getSimpleClassName(imt.getId()));
        writer.comment("no-op", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private static boolean doMatch(String pattern, String str) {
        return Pattern.compile(pattern).matcher(str).matches();
    }

    private static boolean startsWith(String pattern, String str) {
        return RestCodeGen.doMatch(pattern + "\\p{Upper}.*", str);
    }

    private String getGetterName(String id, String def) {
        if (RestCodeGen.startsWith("is", id) || RestCodeGen.startsWith("has", id)) {
            return id;
        }
        return def + GenUtil.capitalize(id);
    }

    private String getSetterName(String id) {
        if (RestCodeGen.startsWith("is", id)) {
            return "set" + id.substring(2);
        }
        if (RestCodeGen.startsWith("has", id)) {
            return "set" + id.substring(3);
        }
        return "set" + GenUtil.capitalize(id);
    }

    private String getJavaType(GenerationContext ctx, Map<String, String> generics, String id, String type, boolean isOptional) {
        if (generics.containsKey(id)) {
            if (!TextUtil.isBlank(type)) {
                StringBuilder builder = new StringBuilder();
                builder.append(type);
                builder.append('<');
                builder.append(generics.get(id));
                builder.append('>');
                return builder.toString();
            }
            return generics.get(id);
        }
        return MetaReflectionHelper.getJavaTypeForRest(type, ctx.getMetaRegistry(), ctx.getRestMetaRegistry(), isOptional);
    }

    private void generateAccessors(JavaWriter writer, RestProperty prop, GenerationContext ctx, RestEntityGeneric entityGeneric) throws IOException {
        String defaultValue;
        String javaType = this.getJavaType(ctx, entityGeneric.getProperties(), prop.getId(), prop.getType(), prop.isOptional());
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        if (Objects.nonNull(defaultValue = prop.getDefaultValue())) {
            writer.code("private %s %s = %s;", javaType, prop.getId(), defaultValue);
        } else {
            writer.code("private %s %s;", javaType, prop.getId());
        }
        writer.blank();
        String doc = RestMetaRegistryHelper.joinStrings(" ", prop.getDocumentation(), ctx.getDocLang());
        if (!TextUtil.isBlank(doc)) {
            writer.doc(doc, new Object[0]);
        }
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        String getter = this.getGetterName(prop.getId(), "boolean".equals(prop.getType()) ? "is" : "get");
        writer.beginBlock("public %s %s()", javaType, getter);
        writer.code("return this.%s;", prop.getId());
        writer.endBlock();
        if (!TextUtil.isBlank(doc)) {
            writer.doc(doc, new Object[0]);
        }
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        String setter = this.getSetterName(prop.getId());
        writer.beginBlock("public void %s(final %s value)", setter, javaType);
        if (prop.isXssProtected() && "string".equals(prop.getType())) {
            writer.code("this.%s = this.%s ? value : com.gridnine.xtrip.common.rest.util.XssHelper.get().strip(value);", prop.getId(), OMIT_XSS_PROTECTION_FIELD);
        } else {
            writer.code("this.%s = value;", prop.getId());
        }
        writer.endBlock();
    }

    private void generateAccessors(JavaWriter writer, RestCollection coll, GenerationContext ctx, RestEntityGeneric entityGeneric) throws IOException {
        String javaElementType = this.getJavaType(ctx, entityGeneric.getCollections(), coll.getId(), coll.getElementType(), true);
        if (coll.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.code("private final %s<%s> %s = new %1$s<%2$s>();", ArrayList.class.getName(), javaElementType, coll.getId());
        writer.blank();
        String doc = RestMetaRegistryHelper.joinStrings(" ", coll.getDocumentation(), ctx.getDocLang());
        if (!TextUtil.isBlank(doc)) {
            writer.doc(doc, new Object[0]);
        }
        writer.beginBlock("public %s<%s> get%s()", List.class.getName(), javaElementType, GenUtil.capitalize(coll.getId()));
        writer.code("return this.%s;", coll.getId());
        writer.endBlock();
    }

    private void generateAccessors(JavaWriter writer, RestMap map, GenerationContext ctx) throws IOException {
        String javaKeyType;
        boolean enumMap = false;
        if ("string".equals(map.getKeyType())) {
            javaKeyType = "String";
        } else if (ctx.getRestMetaRegistry().getEnums().containsKey(map.getKeyType()) || ctx.getMetaRegistry().getEnums().containsKey(map.getKeyType())) {
            javaKeyType = map.getKeyType();
            enumMap = true;
        } else if (ctx.getMetaRegistry().getDictionaries().containsKey(map.getKeyType())) {
            javaKeyType = String.format("com.gridnine.xtrip.common.model.dict.DictionaryReference<%s>", map.getKeyType());
        } else if ("java.time.LocalDate".equals(map.getKeyType())) {
            javaKeyType = "java.time.LocalDate";
        } else {
            throw new IllegalArgumentException("unsupported map key type " + map.getKeyType());
        }
        String javaValueType = MetaReflectionHelper.getJavaTypeForRest(map.getValueType(), ctx.getMetaRegistry(), ctx.getRestMetaRegistry(), true);
        if (map.isValueCollection()) {
            javaValueType = String.format("%s<%s>", List.class.getName(), javaValueType);
        }
        if (map.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        if (enumMap) {
            writer.code("private final %s<%s, %s> %s = new %1$s<%2$s, %3$s>(%2$s.class);", EnumMap.class.getName(), javaKeyType, javaValueType, map.getId());
        } else {
            writer.code("private final %s<%s, %s> %s = new %1$s<%2$s, %3$s>();", HashMap.class.getName(), javaKeyType, javaValueType, map.getId());
        }
        writer.blank();
        String doc = RestMetaRegistryHelper.joinStrings(" ", map.getDocumentation(), ctx.getDocLang());
        if (!TextUtil.isBlank(doc)) {
            writer.doc(doc, new Object[0]);
        }
        writer.beginBlock("public %s<%s, %s> get%s()", Map.class.getName(), javaKeyType, javaValueType, GenUtil.capitalize(map.getId()));
        writer.code("return %s;", map.getId());
        writer.endBlock();
    }

    private void generateInterface(JavaWriter writer, GenerationContext ctx, RestInterfaceType itf) throws Exception {
        this.log.debug("generating interface " + itf.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), itf.getId());
        RestCodeGenHelper.generateTypeDoc(writer, ctx, itf, "Interface", itf.getDocumentation());
        StringBuilder buffer = new StringBuilder();
        buffer.append(StringUtils.join(itf.getInterfaces(), (String)", "));
        if (buffer.length() > 0) {
            buffer.insert(0, "extends ");
        }
        if (itf.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public interface %s %s", GenUtil.getSimpleClassName(itf.getId()), buffer);
        writer.blank();
        writer.comment("BEGIN properties", new Object[0]);
        for (RestProperty prop : itf.getProperties().values()) {
            this.generateInterfaceAccessors(writer, prop, ctx);
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (RestCollection coll : itf.getCollections().values()) {
            this.generateInterfaceAccessors(writer, coll, ctx);
        }
        writer.comment("END collections", new Object[0]);
        if (!TextUtil.isBlank(itf.getCodeFragment())) {
            writer.comment("BEGIN code fragment", new Object[0]);
            writer.code(itf.getCodeFragment(), new Object[0]);
            writer.blank();
            writer.comment("END code fragment", new Object[0]);
        }
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generateInterfaceAccessors(JavaWriter writer, RestCollection coll, GenerationContext ctx) throws IOException {
        String javaElementType = MetaReflectionHelper.getJavaTypeForRest(coll.getElementType(), ctx.getMetaRegistry(), ctx.getRestMetaRegistry(), true);
        String doc = RestMetaRegistryHelper.joinStrings(" ", coll.getDocumentation(), ctx.getDocLang());
        if (!TextUtil.isBlank(doc)) {
            writer.doc(doc, new Object[0]);
        }
        writer.code("public %s<%s> get%s();", List.class.getName(), javaElementType, GenUtil.capitalize(coll.getId()));
    }

    private void generateInterfaceAccessors(JavaWriter writer, RestProperty prop, GenerationContext ctx) throws IOException {
        String javaType = MetaReflectionHelper.getJavaTypeForRest(prop.getType(), ctx.getMetaRegistry(), ctx.getRestMetaRegistry(), prop.isOptional());
        String doc = RestMetaRegistryHelper.joinStrings(" ", prop.getDocumentation(), ctx.getDocLang());
        if (prop.isCreateGetter()) {
            if (!TextUtil.isBlank(doc)) {
                writer.doc(doc, new Object[0]);
            }
            if (prop.isDeprecated()) {
                writer.code("@Deprecated", new Object[0]);
            }
            String getter = this.getGetterName(prop.getId(), "boolean".equals(prop.getType()) ? "is" : "get");
            writer.code("public %s %s();", javaType, getter);
        }
        if (prop.isCreateSetter()) {
            if (!TextUtil.isBlank(doc)) {
                writer.doc(doc, new Object[0]);
            }
            if (prop.isDeprecated()) {
                writer.code("@Deprecated", new Object[0]);
            }
            String setter = this.getSetterName(prop.getId());
            writer.code("public void %s(final %s value);", setter, javaType);
        }
    }
}

