/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.rest;

import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.rest.RestCodeGenHelper;
import com.gridnine.xtrip.common.gen.rest.RestEntityGeneric;
import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public final class RestCodeGenUtils {
    private RestCodeGenUtils() {
    }

    public static boolean writeCollection(RestCollection entityCollection, RestEntityGeneric parentGeneric) {
        if (parentGeneric == null) {
            return true;
        }
        return !parentGeneric.getCollections().containsKey(entityCollection.getId());
    }

    public static boolean writeProperty(RestProperty entityProperty, RestEntityGeneric parentGeneric) {
        if (parentGeneric == null) {
            return true;
        }
        return !parentGeneric.getProperties().containsKey(entityProperty.getId());
    }

    public static String getImplements(GenerationContext ctx, RestEntityType entity) {
        Objects.requireNonNull(entity);
        StringBuilder res = new StringBuilder();
        for (String itf : entity.getInterfaces()) {
            RestCodeGenUtils.comma(res);
            res.append(itf);
        }
        if (RestCodeGenHelper.isValidatable(entity, ctx.getRestMetaRegistry())) {
            RestCodeGenUtils.comma(res);
            res.append(Validatable.class.getName());
        }
        if (res.length() > 0) {
            res.insert(0, "implements ");
        }
        return res.toString();
    }

    public static String getEntityGeneric(RestEntityGeneric entityGeneric) {
        Objects.requireNonNull(entityGeneric);
        if (CollectionUtil.isEmptyMap(entityGeneric.getGenerics())) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        for (Map.Entry<String, String> generic : entityGeneric.getGenerics().entrySet()) {
            RestCodeGenUtils.comma(res);
            res.append(generic.getValue());
            res.append(' ');
            res.append(generic.getKey());
        }
        res.insert(0, '<');
        res.append('>');
        return res.toString();
    }

    public static String getExtendGeneric(GenerationContext ctx, RestEntityType entity, RestEntityGeneric parentGeneric) {
        if (CollectionUtil.isEmptyMap(parentGeneric.getGenerics())) {
            return "";
        }
        if (!entity.getProperties().keySet().containsAll(parentGeneric.getProperties().keySet())) {
            throw new RuntimeException(String.format("entity=[%s] don't contain all generic parent=[%s] properties", entity.getId(), parentGeneric.getId()));
        }
        if (!entity.getCollections().keySet().containsAll(parentGeneric.getCollections().keySet())) {
            throw new RuntimeException(String.format("entity=[%s] don't contain all generic parent=[%s] collections", entity.getId(), parentGeneric.getId()));
        }
        HashSet<String> generics = new HashSet<String>();
        StringBuilder res = new StringBuilder();
        for (Map.Entry<String, String> property : parentGeneric.getProperties().entrySet()) {
            if (generics.contains(property.getValue())) continue;
            RestCodeGenUtils.comma(res);
            generics.add(property.getValue());
            res.append(entity.getProperties().get(property.getKey()).getType());
        }
        for (Map.Entry<String, String> collection : parentGeneric.getCollections().entrySet()) {
            if (generics.contains(collection.getValue())) continue;
            RestCodeGenUtils.comma(res);
            generics.add(collection.getValue());
            res.append(entity.getCollections().get(collection.getKey()).getElementType());
        }
        res.insert(0, '<');
        res.append('>');
        return res.toString();
    }

    public static RestEntityType getParent(GenerationContext ctx, RestEntityType entity) {
        Objects.requireNonNull(entity);
        if (TextUtil.isBlank(entity.getExtendsId())) {
            return null;
        }
        RestEntityType res = ctx.getRestMetaRegistry().getEntities().get(entity.getExtendsId());
        if (res == null) {
            throw new IllegalArgumentException("unsupported base entity type " + entity.getExtendsId());
        }
        return res;
    }

    public static void comma(StringBuilder builder) {
        if (builder != null && builder.length() > 0) {
            builder.append(", ");
        }
    }
}

