/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.rest;

import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class RestEntityGeneric {
    private final String id;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Map<String, String> collections = new LinkedHashMap<String, String>();
    private final Map<String, String> generics = new LinkedHashMap<String, String>();

    public RestEntityGeneric(RestEntityType type) {
        String g;
        Objects.requireNonNull(type);
        this.id = type.getId();
        for (RestProperty property : type.getProperties().values()) {
            if (TextUtil.isBlank(property.getGeneric())) continue;
            g = StringUtils.normalizeSpace((String)property.getGeneric());
            if (!this.generics.containsKey(g)) {
                this.generics.put(g, "T".concat(String.valueOf(this.generics.size() + 1)));
            }
            this.properties.put(property.getId(), this.generics.get(g));
        }
        for (RestCollection collection : type.getCollections().values()) {
            if (TextUtil.isBlank(collection.getGeneric())) continue;
            g = StringUtils.normalizeSpace((String)collection.getGeneric());
            if (!this.generics.containsKey(g)) {
                this.generics.put(g, "T".concat(String.valueOf(this.generics.size() + 1)));
            }
            this.collections.put(collection.getId(), this.generics.get(g));
        }
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getGenerics() {
        return this.generics;
    }

    public Map<String, String> getCollections() {
        return this.collections;
    }
}

