/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.rest;

import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.gen.rest.RestCodeGenHelper;
import com.gridnine.xtrip.common.meta.reflection.MetaReflectionHelper;
import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestMap;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.model.rest.ValidationContext;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class ValidationContextGenerator {
    public static void generateValidationContextClass(JavaWriter writer, GenerationContext ctx, RestEntityType ett) throws Exception {
        String vcExtends = "";
        if (!TextUtil.isBlank(ett.getExtendsId())) {
            RestEntityType extendsType = RestCodeGenHelper.getEntityType(ctx, ett.getExtendsId());
            if (null == extendsType) {
                throw new IllegalArgumentException("type not found " + ett.getExtendsId());
            }
            if (RestCodeGenHelper.isValidatable(extendsType, ctx.getRestMetaRegistry())) {
                vcExtends = " extends " + ett.getExtendsId() + "." + RestCodeGenHelper.genValidationContextClassName(ett.getExtendsId());
            }
        }
        writer.beginBlock("public static class %s%s implements %s", RestCodeGenHelper.genValidationContextClassName(ett.getId()), vcExtends, ValidationContext.class.getName());
        writer.comment("BEGIN properties", new Object[0]);
        for (RestProperty prop : ett.getProperties().values()) {
            ValidationContextGenerator.generateValidatablePropertyAccessor(writer, prop, ctx);
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (RestCollection coll : ett.getCollections().values()) {
            ValidationContextGenerator.generateValidatableCollectionAccessors(writer, coll, ett, ctx);
        }
        writer.comment("END collections", new Object[0]);
        writer.comment("BEGIN maps", new Object[0]);
        for (RestMap map : ett.getMaps().values()) {
            ValidationContextGenerator.generateValidatableMapAccessors(writer, map, ett, ctx);
        }
        writer.comment("END maps", new Object[0]);
        writer.beginBlock("public %s<%s> getValidationMessages(final String memberId)", Collection.class.getName(), ValidationMessage.class.getName());
        writer.comment("BEGIN properties", new Object[0]);
        for (RestProperty prop : ett.getProperties().values()) {
            writer.beginBlock("if (\"%s\".equals(memberId))", prop.getId());
            writer.code("return %sValidationMessages;", prop.getId());
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (RestCollection coll : ett.getCollections().values()) {
            writer.beginBlock("if (\"%s\".equals(memberId))", coll.getId());
            writer.code("return %sValidationMessages;", coll.getId());
            writer.endBlock();
        }
        writer.comment("END collections", new Object[0]);
        writer.comment("BEGIN maps", new Object[0]);
        for (RestMap map : ett.getMaps().values()) {
            writer.beginBlock("if (\"%s\".equals(memberId))", map.getId());
            writer.code("return %sValidationMessages;", map.getId());
            writer.endBlock();
        }
        writer.comment("END maps", new Object[0]);
        if (TextUtil.isBlank(vcExtends)) {
            writer.code("throw new IllegalArgumentException(\"unknown memberId \" + memberId);", new Object[0]);
        } else {
            writer.code("return super.getValidationMessages(memberId);", new Object[0]);
        }
        writer.endBlock();
        writer.beginBlock("public %s<%s, %s<%s>> getValidationMessagesForSimpleCollection(final String collectionId)", Map.class.getName(), Object.class.getName(), Collection.class.getName(), ValidationMessage.class.getName());
        for (RestCollection coll : ett.getCollections().values()) {
            writer.beginBlock("if (\"%s\".equals(collectionId))", coll.getId());
            writer.code("return (%s)%sListValidationMessages;", Map.class.getName(), coll.getId());
            writer.endBlock();
        }
        for (RestMap map : ett.getMaps().values()) {
            writer.beginBlock("if (\"%s\".equals(collectionId))", map.getId());
            writer.code("return (%s)%sListValidationMessages;", Map.class.getName(), map.getId());
            writer.endBlock();
        }
        if (TextUtil.isBlank(vcExtends)) {
            writer.code("throw new IllegalArgumentException(\"unknown collectionId \" + collectionId);", new Object[0]);
        } else {
            writer.code("return super.getValidationMessagesForSimpleCollection(collectionId);", new Object[0]);
        }
        writer.endBlock();
        writer.endBlock();
    }

    private static void generateValidatableCollectionAccessors(JavaWriter writer, RestCollection coll, RestEntityType ett, GenerationContext ctx) throws Exception {
        String variableType = String.format("%s<%s>", Collection.class.getName(), ValidationMessage.class.getName());
        String variableInstance = String.format("%s<%s>", LinkedHashSet.class.getName(), ValidationMessage.class.getName());
        RestCodeGenHelper.maybeDeprecated(coll, writer);
        writer.code("private final %s %sValidationMessages = new %s();", variableType, coll.getId(), variableInstance);
        writer.blank();
        RestCodeGenHelper.maybeDeprecated(coll, writer);
        writer.beginBlock("public %s get%sValidationMessages()", variableType, GenUtil.capitalize(coll.getId()));
        writer.code("return %sValidationMessages;", coll.getId());
        writer.endBlock();
        variableType = String.format("%s<%s, %s<%s>>", Map.class.getName(), Integer.class.getName(), Collection.class.getName(), ValidationMessage.class.getName());
        variableInstance = String.format("%s<%s, %s<%s>>", HashMap.class.getName(), Integer.class.getName(), Collection.class.getName(), ValidationMessage.class.getName());
        RestCodeGenHelper.maybeDeprecated(coll, writer);
        writer.code("private final %s %sListValidationMessages = new %s();", variableType, coll.getId(), variableInstance);
        writer.blank();
        RestCodeGenHelper.maybeDeprecated(coll, writer);
        writer.beginBlock("public %s get%sListValidationMessages()", variableType, GenUtil.capitalize(coll.getId()));
        writer.code("return %sListValidationMessages;", coll.getId());
        writer.endBlock();
    }

    private static void generateValidatableMapAccessors(JavaWriter writer, RestMap map, RestEntityType ett, GenerationContext ctx) throws Exception {
        String variableType = String.format("%s<%s>", Collection.class.getName(), ValidationMessage.class.getName());
        String variableInstance = String.format("%s<%s>", LinkedHashSet.class.getName(), ValidationMessage.class.getName());
        RestCodeGenHelper.maybeDeprecated(map, writer);
        writer.code("private final %s %sValidationMessages = new %s();", variableType, map.getId(), variableInstance);
        writer.blank();
        RestCodeGenHelper.maybeDeprecated(map, writer);
        writer.beginBlock("public %s get%sValidationMessages()", variableType, GenUtil.capitalize(map.getId()));
        writer.code("return %sValidationMessages;", map.getId());
        writer.endBlock();
        String keyType = MetaReflectionHelper.getJavaTypeForRest(map.getKeyType(), ctx.getMetaRegistry(), ctx.getRestMetaRegistry(), true);
        variableType = String.format("%s<%s, %s<%s>>", Map.class.getName(), keyType, Collection.class.getName(), ValidationMessage.class.getName());
        variableInstance = String.format("%s<%s, %s<%s>>", HashMap.class.getName(), keyType, Collection.class.getName(), ValidationMessage.class.getName());
        RestCodeGenHelper.maybeDeprecated(map, writer);
        writer.code("private final %s %sListValidationMessages = new %s();", variableType, map.getId(), variableInstance);
        writer.blank();
        RestCodeGenHelper.maybeDeprecated(map, writer);
        writer.beginBlock("public %s get%sListValidationMessages()", variableType, GenUtil.capitalize(map.getId()));
        writer.code("return %sListValidationMessages;", map.getId());
        writer.endBlock();
    }

    private static void generateValidatablePropertyAccessor(JavaWriter writer, RestProperty prop, GenerationContext ctx) throws Exception {
        writer.code("private final %s<%s> %sValidationMessages = new %s<%s>();", Collection.class.getName(), ValidationMessage.class.getName(), prop.getId(), LinkedHashSet.class.getName(), ValidationMessage.class.getName());
        writer.blank();
        RestCodeGenHelper.maybeDeprecated(prop, writer);
        writer.beginBlock("public %s<%s> get%sValidationMessages()", Collection.class.getName(), ValidationMessage.class.getName(), GenUtil.capitalize(prop.getId()));
        writer.code("return %sValidationMessages;", prop.getId());
        writer.endBlock();
    }
}

