/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.swagger;

import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.YamlWriter;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.EnumItem;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestEnumItem;
import com.gridnine.xtrip.common.meta.rest.RestEnumType;
import com.gridnine.xtrip.common.meta.rest.RestMap;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistryHelper;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.meta.rest.RestService;
import com.gridnine.xtrip.common.meta.rest.RestServiceGroup;
import com.gridnine.xtrip.common.meta.rest.RestServiceOperation;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SwaggerCodeGen {
    public void generate(GenerationContext ctx, String prefix, String lang) throws Exception {
        YamlWriter writer = new YamlWriter();
        RestMetaRegistry registry = ctx.getRestMetaRegistry();
        MetaRegistry modelRegistry = ctx.getMetaRegistry();
        for (RestService service : registry.getServices().values()) {
            String mapDescription;
            String collectionDescription;
            String propertyDescription;
            String id = service.getId();
            File dir = new File(ctx.getOutFolder(), prefix + id);
            dir.mkdirs();
            File file = new File(dir, id + ".yaml");
            writer.beginFile(file);
            writer.property("openapi", "3.0.0");
            writer.object("info");
            String description = SwaggerCodeGen.getDescription(RestMetaRegistryHelper.joinStrings(" ", service.getDocumentation(), lang));
            if (TextUtil.nonBlank(description)) {
                writer.property("description", description);
            }
            writer.property("version", "latest");
            String serviceTitle = RestMetaRegistryHelper.joinStrings(" ", service.getTitle(), lang);
            if (TextUtil.nonBlank(serviceTitle)) {
                writer.property("title", serviceTitle);
            }
            writer.end();
            writer.list("servers");
            writer.property("url", "https://localhost:9090/" + service.getPath());
            writer.end();
            if (!service.getGroups().isEmpty()) {
                writer.list("tags");
                for (RestServiceGroup group : service.getGroups().values()) {
                    writer.item();
                    writer.property("name", group.getId());
                    writer.property("description", RestMetaRegistryHelper.joinStrings(" ", group.getTitle(), lang));
                }
                writer.end();
            }
            writer.object("paths");
            HashSet<String> types = new HashSet<String>();
            Map paths = service.getOperations().values().stream().collect(Collectors.groupingBy(RestServiceOperation::getPath, TreeMap::new, Collectors.toList()));
            HashSet<RestServiceOperation> binaryRequests = new HashSet<RestServiceOperation>();
            HashSet<RestServiceOperation> skipRequest = new HashSet<RestServiceOperation>();
            HashSet validatedResponses = new HashSet();
            for (Map.Entry entry : paths.entrySet()) {
                RestServiceOperation.ResultDescriptor result;
                RestServiceOperation.EntityDescriptor entity;
                RestServiceOperation.ParametersDescriptor params;
                String description2;
                String title;
                writer.object("/" + (String)entry.getKey());
                HashSet<RestServiceOperation> validatedOperation = new HashSet<RestServiceOperation>();
                for (RestServiceOperation operation : (List)entry.getValue()) {
                    writer.object(operation.getMethod().toLowerCase());
                    writer.list("tags");
                    writer.item();
                    writer.property(operation.getGroupId());
                    writer.end();
                    title = SwaggerCodeGen.getDescription(RestMetaRegistryHelper.joinStrings(" ", operation.getTitle(), lang));
                    if (TextUtil.nonBlank(title)) {
                        writer.property("summary", title);
                    }
                    if (TextUtil.nonBlank(description2 = SwaggerCodeGen.getDescription(RestMetaRegistryHelper.joinStrings(" ", service.getDocumentation(), lang)))) {
                        writer.property("description", description2);
                    }
                    writer.property("operationId", operation.getId());
                    params = operation.getParametersDescriptor();
                    entity = operation.getEntityDescriptor();
                    this.generateOperationParameter(writer, registry, modelRegistry, types, binaryRequests, skipRequest, operation, params, entity, lang);
                    result = operation.getResultDescriptor();
                    writer.object("responses");
                    boolean hasValidation = this.isValidateble(registry, params);
                    if (TextUtil.nonBlank(operation.getValidatingRouteId()) && hasValidation) {
                        validatedOperation.add(operation);
                    }
                    if (result != null || hasValidation) {
                        writer.key("200");
                        writer.property("description", "OK");
                        writer.object("content");
                        if (result != null && ("com.gridnine.xtrip.common.model.system.BinaryData".equals(result.getTypeId()) || "com.gridnine.xtrip.common.model.system.DownloadableData".equals(result.getTypeId()))) {
                            writer.object("application/force-download");
                        } else {
                            writer.object("application/json");
                        }
                        writer.object("schema");
                        String type = TextUtil.capitalize(operation.getId()) + "Response";
                        writer.property("$ref", "#/components/schemas/" + type);
                        writer.end();
                        writer.end();
                        writer.end();
                        writer.end();
                        if (null == result || result.isOptional()) {
                            writer.key("204");
                            writer.property("description", "OK");
                            writer.end();
                        }
                    } else {
                        writer.key("200");
                        writer.property("description", "OK");
                        writer.end();
                    }
                    writer.key("400");
                    writer.property("description", "Error");
                    writer.object("content");
                    writer.object("application/json");
                    writer.object("schema");
                    writer.property("$ref", "#/components/schemas/error-response");
                    types.add("error-response");
                    writer.end();
                    writer.end();
                    writer.end();
                    writer.end();
                    writer.end();
                    writer.end();
                }
                writer.end();
                if (validatedOperation.isEmpty()) continue;
                validatedResponses.addAll(validatedOperation);
                writer.object("/" + (String)entry.getKey() + "/validate");
                for (RestServiceOperation operation : validatedOperation) {
                    writer.object(operation.getMethod().toLowerCase());
                    writer.list("tags");
                    writer.item();
                    writer.property(operation.getGroupId());
                    writer.end();
                    title = SwaggerCodeGen.getDescription(RestMetaRegistryHelper.joinStrings(" ", operation.getTitle(), lang));
                    if (TextUtil.nonBlank(title)) {
                        writer.property("summary", title);
                    }
                    if (TextUtil.nonBlank(description2 = SwaggerCodeGen.getDescription(RestMetaRegistryHelper.joinStrings(" ", service.getDocumentation(), lang)))) {
                        writer.property("description", description2);
                    }
                    writer.property("operationId", operation.getId() + "Validate");
                    params = operation.getParametersDescriptor();
                    entity = operation.getEntityDescriptor();
                    this.generateOperationParameter(writer, registry, modelRegistry, types, binaryRequests, skipRequest, operation, params, entity, lang);
                    result = operation.getResultDescriptor();
                    writer.object("responses");
                    writer.key("200");
                    writer.property("description", "OK");
                    writer.object("content");
                    writer.object("application/json");
                    writer.object("schema");
                    String type = TextUtil.capitalize(operation.getId()) + "ValidatedResponse";
                    writer.property("$ref", "#/components/schemas/" + type);
                    writer.end();
                    writer.end();
                    writer.end();
                    writer.end();
                    if (null == result || result.isOptional()) {
                        writer.key("204");
                        writer.property("description", "OK");
                        writer.end();
                    }
                    writer.end();
                    writer.end();
                }
                writer.end();
            }
            writer.end();
            writer.object("components");
            writer.object("schemas");
            writer.object("Severity");
            writer.property("type", "string");
            writer.list("enum");
            writer.item();
            writer.property("ERROR");
            writer.item();
            writer.property("INFO");
            writer.item();
            writer.property("WARNING");
            writer.end();
            writer.end();
            for (RestEnumType enumType : registry.getEnums().values()) {
                writer.object(this.getTypeShortName(enumType.getId()));
                String description3 = RestMetaRegistryHelper.joinStrings(" ", enumType.getDocumentation(), lang);
                if (TextUtil.nonBlank(description3)) {
                    writer.property("description", SwaggerCodeGen.getDescription(description3));
                }
                writer.property("type", "string");
                writer.list("enum");
                for (RestEnumItem item : enumType.getItems().values()) {
                    writer.item();
                    writer.property(item.getId());
                }
                writer.end();
                writer.end();
            }
            for (RestServiceOperation operation : service.getOperations().values()) {
                String type;
                RestServiceOperation.ParametersDescriptor params = operation.getParametersDescriptor();
                RestServiceOperation.EntityDescriptor entity = operation.getEntityDescriptor();
                if (!(params == null && entity == null || skipRequest.contains(operation))) {
                    String type2 = TextUtil.capitalize(operation.getId()) + "Request";
                    writer.object(type2);
                    writer.property("type", "object");
                    writer.object("properties");
                    if (params != null) {
                        writer.object("parameters");
                        if (params.isCollection()) {
                            writer.property("type", "array");
                            writer.object("items");
                            this.writeType2(writer, params.getTypeId(), registry, modelRegistry, types);
                            writer.end();
                        } else {
                            this.writeType2(writer, params.getTypeId(), registry, modelRegistry, types);
                        }
                        writer.end();
                        writer.end();
                    }
                    if (entity != null) {
                        writer.object("entity");
                        this.writeType(writer, entity.getTypeId(), registry, modelRegistry, types);
                        writer.end();
                        writer.end();
                    }
                    writer.end();
                }
                if (params != null && binaryRequests.contains(operation)) {
                    String binaryType = TextUtil.capitalize(operation.getId()) + "FormDataRequest";
                    writer.object(binaryType);
                    writer.property("type", "object");
                    RestEntityType entityType = registry.getEntities().get(params.getTypeId());
                    String entityDescription = RestMetaRegistryHelper.joinStrings(" ", entityType.getDocumentation(), lang);
                    if (TextUtil.nonBlank(entityDescription)) {
                        writer.property("description", SwaggerCodeGen.getDescription(entityDescription));
                    }
                    writer.object("properties");
                    while (entityType != null) {
                        for (RestProperty prop : entityType.getProperties().values()) {
                            writer.object(prop.getId());
                            propertyDescription = RestMetaRegistryHelper.joinStrings(" ", prop.getDocumentation(), lang);
                            if (TextUtil.nonBlank(propertyDescription)) {
                                writer.property("description", SwaggerCodeGen.getDescription(propertyDescription));
                            }
                            if ("com.gridnine.xtrip.common.model.system.DownloadableData".equals(prop.getType()) || "com.gridnine.xtrip.common.model.system.BinaryData".equals(prop.getType())) {
                                writer.property("type", "string");
                                writer.property("format", "binary");
                            } else {
                                this.writeType(writer, prop.getType(), registry, modelRegistry, types);
                            }
                            if (prop.isOptional()) {
                                writer.property("nullable", true);
                            }
                            writer.end();
                        }
                        for (RestCollection collection : entityType.getCollections().values()) {
                            writer.object(collection.getId());
                            collectionDescription = RestMetaRegistryHelper.joinStrings(" ", collection.getDocumentation(), lang);
                            if (TextUtil.nonBlank(collectionDescription)) {
                                writer.property("description", SwaggerCodeGen.getDescription(collectionDescription));
                            }
                            writer.property("type", "array");
                            writer.object("items");
                            this.writeType(writer, collection.getElementType(), registry, modelRegistry, types);
                            writer.end();
                            writer.end();
                        }
                        for (RestMap map : entityType.getMaps().values()) {
                            writer.object(map.getId());
                            mapDescription = RestMetaRegistryHelper.joinStrings(" ", map.getDocumentation(), lang);
                            if (TextUtil.nonBlank(mapDescription)) {
                                writer.property("description", SwaggerCodeGen.getDescription(mapDescription));
                            }
                            writer.property("type", "object");
                            writer.end();
                        }
                        entityType = entityType.getExtendsId() != null ? registry.getEntities().get(entityType.getExtendsId()) : null;
                    }
                    writer.end();
                    writer.end();
                }
                RestServiceOperation.ResultDescriptor result = operation.getResultDescriptor();
                boolean hasValidation = this.isValidateble(registry, params);
                if (result != null || hasValidation) {
                    type = TextUtil.capitalize(operation.getId()) + "Response";
                    writer.object(type);
                    if (result != null && !result.isCollection() && ("com.gridnine.xtrip.common.model.system.BinaryData".equals(result.getTypeId()) || "com.gridnine.xtrip.common.model.system.DownloadableData".equals(result.getTypeId()))) {
                        writer.property("type", "string");
                        writer.property("format", "binary");
                    } else {
                        writer.property("type", "object");
                        writer.object("properties");
                        if (result != null) {
                            writer.object("result");
                            if (result.isCollection()) {
                                writer.property("type", "array");
                                writer.object("items");
                                this.writeType2(writer, result.getTypeId(), registry, modelRegistry, types);
                                writer.end();
                            } else {
                                this.writeType2(writer, result.getTypeId(), registry, modelRegistry, types);
                            }
                            writer.end();
                        }
                        if (hasValidation) {
                            writer.object("validatedParameters");
                            writer.property("$ref", "#/components/schemas/" + this.getTypeShortName(params.getTypeId()) + "ValidatedParameters");
                            writer.end();
                        }
                        writer.object("messages");
                        writer.property("$ref", "#/components/schemas/messages");
                        types.add("messages");
                        writer.end();
                        writer.end();
                    }
                    writer.end();
                }
                if (!validatedResponses.contains(operation)) continue;
                type = TextUtil.capitalize(operation.getId()) + "ValidatedResponse";
                writer.object(type);
                writer.property("type", "object");
                writer.object("properties");
                writer.object("validatedParameters");
                writer.property("$ref", "#/components/schemas/" + this.getTypeShortName(params.getTypeId()) + "ValidatedParameters");
                writer.end();
                writer.end();
                writer.end();
            }
            writer.object("InformationMessage");
            writer.property("type", "object");
            writer.object("properties");
            writer.object("text");
            writer.property("type", "string");
            writer.end();
            writer.object("code");
            writer.property("type", "string");
            writer.end();
            writer.object("severity");
            writer.property("$ref", "#/components/schemas/Severity");
            writer.end();
            writer.end();
            writer.end();
            for (RestEntityType entity : registry.getEntities().values()) {
                boolean hasValidatableExtends;
                RestEntityType entityType;
                boolean hasExtends;
                writer.object(this.getTypeShortName(entity.getId()));
                String entityDescription = RestMetaRegistryHelper.joinStrings(" ", entity.getDocumentation(), lang);
                if (TextUtil.nonBlank(entityDescription)) {
                    writer.property("description", SwaggerCodeGen.getDescription(entityDescription));
                }
                boolean bl = hasExtends = entity.getExtendsId() != null;
                if (hasExtends) {
                    writer.list("allOf");
                    writer.property("$ref", "#/components/schemas/" + this.getTypeShortName(entity.getExtendsId()));
                    writer.item();
                }
                writer.property("type", "object");
                if (!(entity.getProperties().isEmpty() && entity.getCollections().isEmpty() && entity.getMaps().isEmpty())) {
                    writer.object("properties");
                    for (RestProperty prop : entity.getProperties().values()) {
                        writer.object(prop.getId());
                        String propertyDescription2 = RestMetaRegistryHelper.joinStrings(" ", prop.getDocumentation(), lang);
                        if (TextUtil.nonBlank(propertyDescription2)) {
                            writer.property("description", SwaggerCodeGen.getDescription(propertyDescription2));
                        }
                        this.writeType(writer, prop.getType(), registry, modelRegistry, types);
                        if (prop.isOptional()) {
                            writer.property("nullable", true);
                        }
                        writer.end();
                    }
                    if (entity.isWithMessages()) {
                        writer.object("messages");
                        writer.property("type", "array");
                        writer.object("items");
                        writer.property("$ref", "#/components/schemas/InformationMessage");
                        writer.end();
                        writer.end();
                    }
                    for (RestCollection collection : entity.getCollections().values()) {
                        writer.object(collection.getId());
                        String collectionDescription2 = RestMetaRegistryHelper.joinStrings(" ", collection.getDocumentation(), lang);
                        if (TextUtil.nonBlank(collectionDescription2)) {
                            writer.property("description", SwaggerCodeGen.getDescription(collectionDescription2));
                        }
                        writer.property("type", "array");
                        writer.object("items");
                        this.writeType(writer, collection.getElementType(), registry, modelRegistry, types);
                        writer.end();
                        writer.end();
                    }
                    for (RestMap map : entity.getMaps().values()) {
                        writer.object(map.getId());
                        String mapDescription2 = RestMetaRegistryHelper.joinStrings(" ", map.getDocumentation(), lang);
                        if (TextUtil.nonBlank(mapDescription2)) {
                            writer.property("description", SwaggerCodeGen.getDescription(mapDescription2));
                        }
                        writer.property("type", "object");
                        writer.object("additionalProperties");
                        if (map.isValueCollection()) {
                            writer.property("type", "array");
                            writer.object("items");
                            this.writeType(writer, map.getValueType(), registry, modelRegistry, types);
                            writer.end();
                        } else {
                            this.writeType(writer, map.getValueType(), registry, modelRegistry, types);
                        }
                        writer.end();
                        writer.end();
                    }
                    writer.end();
                }
                if (hasExtends) {
                    writer.end();
                }
                writer.end();
                boolean isValidatable = entity.isValidatable();
                if (!isValidatable) {
                    String typeId = entity.getId();
                    isValidatable = validatedResponses.stream().anyMatch(o -> typeId.equals(o.getParametersDescriptor().getTypeId()));
                }
                if (!isValidatable) continue;
                writer.object(this.getTypeShortName(entity.getId()) + "ValidatedParameters");
                if (TextUtil.nonBlank(entityDescription)) {
                    writer.property("description", SwaggerCodeGen.getDescription(entityDescription));
                }
                String entityId = entity.getExtendsId();
                while (entityId != null && !(entityType = registry.getEntities().get(entityId)).isValidatable()) {
                    entityId = entityType.getExtendsId();
                }
                boolean bl2 = hasValidatableExtends = entityId != null;
                if (hasValidatableExtends) {
                    writer.list("allOf");
                    writer.property("$ref", "#/components/schemas/" + this.getTypeShortName(entity.getExtendsId()) + "ValidatedParameters");
                    writer.item();
                }
                writer.property("type", "object");
                if (!(entity.getProperties().isEmpty() && entity.getCollections().isEmpty() && entity.getMaps().isEmpty())) {
                    writer.object("properties");
                    for (RestProperty prop : entity.getProperties().values()) {
                        writer.object(prop.getId());
                        propertyDescription = RestMetaRegistryHelper.joinStrings(" ", prop.getDocumentation(), lang);
                        if (TextUtil.nonBlank(propertyDescription)) {
                            writer.property("description", SwaggerCodeGen.getDescription(propertyDescription));
                        }
                        writer.property("$ref", "#/components/schemas/validation-messages");
                        types.add("validation-messages");
                        writer.end();
                    }
                    for (RestCollection collection : entity.getCollections().values()) {
                        writer.object(collection.getId());
                        collectionDescription = RestMetaRegistryHelper.joinStrings(" ", collection.getDocumentation(), lang);
                        if (TextUtil.nonBlank(collectionDescription)) {
                            writer.property("description", SwaggerCodeGen.getDescription(collectionDescription));
                        }
                        writer.property("type", "object");
                        writer.end();
                    }
                    for (RestMap map : entity.getMaps().values()) {
                        writer.object(map.getId());
                        mapDescription = RestMetaRegistryHelper.joinStrings(" ", map.getDocumentation(), lang);
                        if (TextUtil.nonBlank(mapDescription)) {
                            writer.property("description", SwaggerCodeGen.getDescription(mapDescription));
                        }
                        writer.property("type", "object");
                        writer.end();
                    }
                    writer.end();
                }
                if (hasValidatableExtends) {
                    writer.end();
                }
                writer.end();
            }
            for (String typeId : types) {
                EnumType enumType = modelRegistry.getEnums().get(typeId);
                if (null == enumType) continue;
                writer.object(this.getTypeShortName(enumType.getId()));
                writer.property("type", "string");
                writer.list("enum");
                for (EnumItem item : enumType.getItems().values()) {
                    writer.item();
                    writer.property(item.getId());
                }
                writer.end();
                writer.end();
            }
            if (types.contains("reference")) {
                types.remove("reference");
                writer.object("reference");
                writer.property("type", "object");
                writer.object("properties");
                writer.object("uid");
                writer.property("type", "string");
                writer.end();
                writer.object("type");
                writer.property("type", "string");
                writer.end();
                writer.object("caption");
                writer.property("type", "string");
                writer.end();
                writer.end();
                writer.end();
            }
            if (types.contains("dictionary")) {
                types.remove("dictionary");
                writer.object("dictionary");
                writer.property("type", "object");
                writer.object("properties");
                writer.object("code");
                writer.property("type", "string");
                writer.end();
                writer.object("type");
                writer.property("type", "string");
                writer.end();
                writer.object("caption");
                writer.property("type", "string");
                writer.end();
                writer.end();
                writer.end();
            }
            if (types.contains("validation-list-messages")) {
                types.remove("validation-list-messages");
                writer.object("validation-list-messages");
                writer.property("type", "object");
                writer.object("additionalProperties");
                writer.property("$ref", "#/components/schemas/validation-messages");
                writer.end();
                writer.end();
                types.add("validation-messages");
            }
            if (types.contains("validation-map-messages")) {
                types.remove("validation-map-messages");
                writer.object("validation-map-messages");
                writer.property("type", "object");
                writer.object("additionalProperties");
                writer.property("$ref", "#/components/schemas/validation-messages");
                writer.end();
                writer.end();
                types.add("validation-messages");
            }
            if (types.contains("validation-messages")) {
                types.remove("validation-messages");
                writer.object("validation-messages");
                writer.property("type", "array");
                writer.object("items");
                writer.property("type", "string");
                writer.end();
                writer.end();
            }
            if (types.contains("error-response")) {
                types.remove("error-response");
                writer.object("error-response");
                writer.property("type", "object");
                writer.object("properties");
                writer.object("userErrorMessage");
                writer.property("type", "string");
                writer.end();
                writer.object("messages");
                writer.property("$ref", "#/components/schemas/messages");
                types.add("messages");
                writer.end();
                writer.end();
                writer.end();
            }
            if (types.contains("messages")) {
                types.remove("messages");
                writer.object("messages");
                writer.property("type", "array");
                writer.object("items");
                writer.property("type", "object");
                writer.end();
                writer.end();
            }
            writer.end();
            writer.end();
            writer.endFile();
        }
    }

    private boolean isValidateble(RestMetaRegistry registry, RestServiceOperation.ParametersDescriptor params) {
        if (null == params) {
            return false;
        }
        String typeId = params.getTypeId();
        if ("com.gridnine.xtrip.common.model.system.BinaryData".equals(params.getTypeId())) {
            return false;
        }
        while (typeId != null) {
            RestEntityType entityType = registry.getEntities().get(typeId);
            if (null == entityType) {
                return false;
            }
            if (entityType.isValidatable()) {
                return true;
            }
            typeId = entityType.getExtendsId();
        }
        return false;
    }

    private void generateOperationParameter(YamlWriter writer, RestMetaRegistry registry, MetaRegistry modelRegistry, Collection<String> types, Set<RestServiceOperation> binaryRequests, Set<RestServiceOperation> skipRequest, RestServiceOperation operation, RestServiceOperation.ParametersDescriptor params, RestServiceOperation.EntityDescriptor entity, String lang) throws IOException {
        if (params != null || entity != null) {
            String type = TextUtil.capitalize(operation.getId()) + "Request";
            if ("GET".equals(operation.getMethod())) {
                if (params != null) {
                    skipRequest.add(operation);
                    writer.list("parameters");
                    RestEntityType entityType = registry.getEntities().get(params.getTypeId());
                    if (null == entityType) {
                        throw new IllegalArgumentException("no type " + params.getTypeId() + " found");
                    }
                    String entityDescription = RestMetaRegistryHelper.joinStrings(" ", entityType.getDocumentation(), lang);
                    if (TextUtil.nonBlank(entityDescription)) {
                        writer.property("description", SwaggerCodeGen.getDescription(entityDescription));
                    }
                    while (entityType != null) {
                        for (RestProperty prop : entityType.getProperties().values()) {
                            writer.item();
                            writer.property("in", "query");
                            writer.property("name", prop.getId());
                            String propertyDescription = RestMetaRegistryHelper.joinStrings(" ", prop.getDocumentation(), lang);
                            if (TextUtil.nonBlank(propertyDescription)) {
                                writer.property("description", SwaggerCodeGen.getDescription(propertyDescription));
                            }
                            writer.object("schema");
                            this.writeType(writer, prop.getType(), registry, modelRegistry, types);
                            writer.end();
                            if (prop.isOptional()) continue;
                            writer.property("required", true);
                        }
                        for (RestCollection collection : entityType.getCollections().values()) {
                            writer.item();
                            writer.property("in", "query");
                            writer.property("name", collection.getId());
                            String collectionDescription = RestMetaRegistryHelper.joinStrings(" ", collection.getDocumentation(), lang);
                            if (TextUtil.nonBlank(collectionDescription)) {
                                writer.property("description", SwaggerCodeGen.getDescription(collectionDescription));
                            }
                            writer.object("schema");
                            writer.property("type", "array");
                            writer.object("items");
                            this.writeType(writer, collection.getElementType(), registry, modelRegistry, types);
                            writer.end();
                            writer.end();
                        }
                        for (RestMap map : entityType.getMaps().values()) {
                            writer.item();
                            writer.property("in", "query");
                            writer.property("name", map.getId());
                            String mapDescription = RestMetaRegistryHelper.joinStrings(" ", map.getDocumentation(), lang);
                            if (TextUtil.nonBlank(mapDescription)) {
                                writer.property("description", SwaggerCodeGen.getDescription(mapDescription));
                            }
                            writer.object("schema");
                            writer.property("type", "object");
                            writer.object("additionalProperties");
                            this.writeType(writer, map.getValueType(), registry, modelRegistry, types);
                            writer.end();
                            writer.end();
                        }
                        entityType = entityType.getExtendsId() != null ? registry.getEntities().get(entityType.getExtendsId()) : null;
                    }
                    writer.end();
                } else {
                    writer.emptyList("parameters");
                }
            } else {
                writer.object("requestBody");
                writer.property("required", true);
                writer.object("content");
                if (null == entity && "com.gridnine.xtrip.common.model.system.BinaryData".equals(params.getTypeId())) {
                    writer.object("application/octet-stream");
                    writer.object("schema");
                    writer.property("type", "string");
                    writer.property("format", "binary");
                    writer.end();
                    writer.end();
                    skipRequest.add(operation);
                } else {
                    if (params != null) {
                        boolean hasBinary = false;
                        RestEntityType entityType = registry.getEntities().get(params.getTypeId());
                        while (entityType != null) {
                            if (entityType.getProperties().values().stream().anyMatch(p -> "com.gridnine.xtrip.common.model.system.DownloadableData".equals(p.getType()) || "com.gridnine.xtrip.common.model.system.BinaryData".equals(p.getType()))) {
                                hasBinary = true;
                                break;
                            }
                            entityType = entityType.getExtendsId() != null ? registry.getEntities().get(entityType.getExtendsId()) : null;
                        }
                        if (hasBinary) {
                            binaryRequests.add(operation);
                            writer.object("multipart/form-data");
                            writer.object("schema");
                            String binaryType = TextUtil.capitalize(operation.getId()) + "FormDataRequest";
                            writer.property("$ref", "#/components/schemas/" + binaryType);
                            writer.end();
                            writer.end();
                        }
                    }
                    writer.object("application/json");
                    writer.object("schema");
                    writer.property("$ref", "#/components/schemas/" + type);
                    writer.end();
                    writer.end();
                }
                writer.end();
                writer.end();
            }
        } else {
            writer.emptyList("parameters");
        }
    }

    private void writeType(YamlWriter writer, String type, RestMetaRegistry restRegistry, MetaRegistry modelRegistry, Collection<String> types) throws IOException {
        switch (type) {
            case "string": 
            case "boolean": {
                writer.property("type", type);
                return;
            }
            case "int": {
                writer.property("type", "integer");
                writer.property("format", "int32");
                return;
            }
            case "long": {
                writer.property("type", "integer");
                writer.property("format", "int64");
                return;
            }
            case "byte": {
                writer.property("type", "integer");
                writer.property("minimum", "-128");
                writer.property("maximum", "127");
                return;
            }
            case "float": {
                writer.property("type", "number");
                writer.property("format", "float");
                return;
            }
            case "double": {
                writer.property("type", "number");
                writer.property("format", "double");
                return;
            }
            case "big-int": {
                writer.property("type", "integer");
                return;
            }
            case "big-decimal": {
                writer.property("type", "number");
                return;
            }
            case "char": {
                writer.property("type", "string");
                writer.property("minLength", 1);
                writer.property("maxLength", 1);
                return;
            }
            case "timestamp": 
            case "date-time": 
            case "date-time-local": 
            case "date-time-local-java": {
                writer.property("type", "string");
                writer.property("format", "date-time");
                return;
            }
            case "date-local": 
            case "date-local-java": {
                writer.property("type", "string");
                writer.property("format", "date");
                return;
            }
            case "time-local": 
            case "time-local-java": {
                writer.property("type", "string");
                writer.property("format", "time");
                return;
            }
            case "bytes": 
            case "byte[]": 
            case "com.gridnine.xtrip.common.model.system.DownloadableData": 
            case "com.gridnine.xtrip.common.model.system.BinaryData": {
                writer.property("type", "string");
                writer.property("format", "base64");
                return;
            }
            case "json-object": {
                writer.property("type", "object");
                return;
            }
        }
        if (type.startsWith("collection<")) {
            writer.property("type", "array");
            writer.object("items");
            String t = type.substring(10);
            writer.property("$ref", "#/components/schemas/" + this.getTypeShortName(t));
            writer.end();
            return;
        }
        if (restRegistry.getEntities().containsKey(type)) {
            writer.property("$ref", "#/components/schemas/" + this.getTypeShortName(type));
            return;
        }
        if (restRegistry.getEnums().containsKey(type)) {
            writer.property("$ref", "#/components/schemas/" + this.getTypeShortName(type));
            return;
        }
        if (BaseDictionary.class.getName().equals(type) || modelRegistry.getDictionaries().containsKey(type)) {
            writer.property("$ref", "#/components/schemas/dictionary");
            types.add("dictionary");
            return;
        }
        if (modelRegistry.getEnums().containsKey(type)) {
            writer.property("$ref", "#/components/schemas/" + this.getTypeShortName(type));
            types.add(type);
            return;
        }
        EntityType entityType = modelRegistry.getEntities().get(type);
        if (entityType != null && MetaRegistryHelper.isRoot(entityType) || BaseEntity.class.getName().equals(type)) {
            writer.property("$ref", "#/components/schemas/reference");
            types.add("reference");
            return;
        }
        throw new IllegalArgumentException("invalid type " + type);
    }

    private void writeType2(YamlWriter writer, String type, RestMetaRegistry restRegistry, MetaRegistry modelRegistry, Collection<String> types) throws IOException {
        switch (type) {
            case "String": 
            case "java.lang.String": {
                writer.property("type", "string");
            }
            case "boolean": 
            case "Boolean": 
            case "java.lang.Boolean": {
                writer.property("type", "boolean");
                return;
            }
            case "int": 
            case "Integer": 
            case "java.lang.Integer": {
                writer.property("type", "integer");
                writer.property("format", "int32");
                return;
            }
            case "long": 
            case "Long": 
            case "java.lang.Long": {
                writer.property("type", "integer");
                writer.property("format", "int64");
                return;
            }
            case "byte": 
            case "Byte": 
            case "java.lang.Byte": {
                writer.property("type", "integer");
                writer.property("minimum", "-128");
                writer.property("maximum", "127");
                return;
            }
            case "float": 
            case "Float": 
            case "java.lang.Float": {
                writer.property("type", "number");
                writer.property("format", "float");
                return;
            }
            case "double": 
            case "Double": 
            case "java.lang.Double": {
                writer.property("type", "number");
                writer.property("format", "double");
                return;
            }
            case "java.math.BigInteger": {
                writer.property("type", "integer");
                return;
            }
            case "java.math.BigDecimal": {
                writer.property("type", "number");
                return;
            }
            case "char": 
            case "Character": 
            case "java.lang.Character": {
                writer.property("type", "string");
                writer.property("minLength", 1);
                writer.property("maxLength", 1);
                return;
            }
            case "java.util.Date": 
            case "org.joda.time.LocalDateTime": 
            case "java.time.LocalDateTime": {
                writer.property("type", "string");
                writer.property("format", "date-time");
                return;
            }
            case "org.joda.time.LocalDate": 
            case "java.time.LocalDate": {
                writer.property("type", "string");
                writer.property("format", "date");
                return;
            }
            case "org.joda.time.LocalTime": 
            case "java.time.LocalTime": {
                writer.property("type", "string");
                writer.property("format", "time");
                return;
            }
            case "byte[]": 
            case "com.gridnine.xtrip.common.model.system.DownloadableData": 
            case "com.gridnine.xtrip.common.model.system.BinaryData": {
                writer.property("type", "string");
                writer.property("format", "base64");
                return;
            }
            case "org.json.JSONObject": {
                writer.property("type", "object");
                return;
            }
        }
        if (restRegistry.getEntities().containsKey(type)) {
            writer.property("$ref", "#/components/schemas/" + this.getTypeShortName(type));
            return;
        }
        if (restRegistry.getEnums().containsKey(type)) {
            writer.property("$ref", "#/components/schemas/" + this.getTypeShortName(type));
            return;
        }
        if (BaseDictionary.class.getName().equals(type) || modelRegistry.getDictionaries().containsKey(type)) {
            writer.property("$ref", "#/components/schemas/dictionary");
            types.add("dictionary");
            return;
        }
        if (modelRegistry.getEnums().containsKey(type)) {
            writer.property("$ref", "#/components/schemas/" + this.getTypeShortName(type));
            types.add(type);
            return;
        }
        EntityType entityType = modelRegistry.getEntities().get(type);
        if (entityType != null && MetaRegistryHelper.isRoot(entityType) || BaseEntity.class.getName().equals(type)) {
            writer.property("$ref", "#/components/schemas/reference");
            types.add("reference");
            return;
        }
        throw new IllegalArgumentException("invalid type " + type);
    }

    private String getTypeShortName(String type) {
        int i = type.lastIndexOf(46);
        return i != -1 ? type.substring(i + 1) : type;
    }

    private static String getDescription(String description) {
        return description != null ? description.replaceAll("<[^>]*>|</[^>]*>", "") : null;
    }

    public static void main(String ... args) {
        System.out.println(SwaggerCodeGen.getDescription("<p></p>"));
    }
}

