/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.incidents;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gracefulstop.ShutdownStatus;
import com.gridnine.xtrip.common.ibus.LocalMessageContext;
import com.gridnine.xtrip.common.incidents.IncidentsContext;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.incidents.IncidentsIgnorableException;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.logging.ServiceInvocationLoggingHelper;
import com.gridnine.xtrip.common.user.UserData;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.apache.commons.lang.time.FastDateFormat;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.transport.http.WebServerError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncidentsLog {
    public static final ExceptionDecomposer STANDARD_EXCEPTION_DECOMPOSER = t -> t.getCause() != null ? Stream.of(t.getCause()) : null;
    private static final Map<Class<?>, ExceptionDecomposer> exceptionDecomposers = new HashMap();
    public static final ExceptionRule SIMPLE_EXCEPTION_IGNORE_RULE;
    private static final Map<Class<?>, ExceptionRule> exceptionIgnoreRules;
    private static final Set<Class<?>> unignorableExceptions;
    private static final Map<Class<?>, ExceptionRule> exceptionAdminRules;
    private static final Map<Class<?>, ExceptionRule> exceptionUserRules;
    private static final Logger logger;
    private static final Logger adminLogger;
    private static final Logger userLogger;
    private static final FastDateFormat DATE_FORMAT;

    public static void registerExceptionDecomposer(Class<?> cls, ExceptionDecomposer decomposer) {
        exceptionDecomposers.put(cls, decomposer);
    }

    private static Stream<Throwable> decompose(Throwable t) {
        for (Map.Entry<Class<?>, ExceptionDecomposer> decomposerEntry : exceptionDecomposers.entrySet()) {
            Stream<Throwable> s;
            if (!decomposerEntry.getKey().isInstance(t) || (s = decomposerEntry.getValue().decompose(t)) == null) continue;
            return s.flatMap(IncidentsLog::decompose);
        }
        return Stream.of(t);
    }

    public static void registerUnignorableException(Class<?> cls) {
        unignorableExceptions.add(cls);
    }

    public static void registerExceptionIgnoreRule(Class<?> cls, ExceptionRule rule) {
        if (!unignorableExceptions.contains(cls)) {
            exceptionIgnoreRules.put(cls, rule);
        }
    }

    public static void unregisterExceptionIgnoreRule(Class<?> cls) {
        exceptionIgnoreRules.remove(cls);
    }

    public static boolean isIgnore(Throwable t) {
        return IncidentsLog.decompose(t).allMatch(IncidentsLog::isIgnoreCause);
    }

    private static boolean isIgnoreCause(Throwable t) {
        for (Map.Entry<Class<?>, ExceptionRule> ruleEntry : exceptionIgnoreRules.entrySet()) {
            if (!ruleEntry.getKey().isInstance(t) || !ruleEntry.getValue().matches(t)) continue;
            return true;
        }
        return false;
    }

    public static void registerExceptionAdminRule(Class<?> cls, ExceptionRule rule) {
        exceptionAdminRules.put(cls, rule);
    }

    public static boolean isAdmin(Throwable t) {
        return IncidentsLog.decompose(t).allMatch(IncidentsLog::isAdminCause);
    }

    private static boolean isAdminCause(Throwable t) {
        for (Map.Entry<Class<?>, ExceptionRule> ruleEntry : exceptionAdminRules.entrySet()) {
            if (!ruleEntry.getKey().isInstance(t) || !ruleEntry.getValue().matches(t)) continue;
            return true;
        }
        return false;
    }

    public static void registerExceptionUserRule(Class<?> cls, ExceptionRule rule) {
        exceptionUserRules.put(cls, rule);
    }

    public static boolean isUser(Throwable t) {
        return IncidentsLog.decompose(t).allMatch(IncidentsLog::isUserCause);
    }

    private static boolean isUserCause(Throwable t) {
        for (Map.Entry<Class<?>, ExceptionRule> ruleEntry : exceptionUserRules.entrySet()) {
            if (!ruleEntry.getKey().isInstance(t) || !ruleEntry.getValue().matches(t)) continue;
            return true;
        }
        return false;
    }

    public static void reportException(String message, Throwable t) {
        if (!IncidentsLog.isIgnore(t)) {
            IncidentsHelper.addStackTraceElement(t, IncidentsLog.modifyStackTrace());
            if (IncidentsLog.isAdmin(t)) {
                adminLogger.error(message, t);
            } else if (IncidentsLog.isUser(t)) {
                userLogger.error(message, t);
            } else if (ShutdownStatus.isShutdown()) {
                logger.warn(message, t);
            } else {
                logger.error(message, t);
            }
        }
    }

    private static String enrichMessage(String message) {
        String clientStacktrace;
        StackTraceElement[] stackTrace = IncidentsHelper.addStackTraceElement(Thread.currentThread().getStackTrace(), IncidentsLog.modifyStackTrace());
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        for (int i = 2; i < stackTrace.length; ++i) {
            sb.append("\n\tat ").append(stackTrace[i].toString());
        }
        LocalMessageContext.Source ibus = LocalMessageContext.getLocalMessageContext();
        if (ibus != null) {
            StackTraceElement[] ibusStackTrace = ibus.getStackTrace();
            sb.append("\nbus:");
            for (StackTraceElement stackTraceElement : ibusStackTrace) {
                sb.append("\n\tat ").append(stackTraceElement.toString());
            }
        }
        if ((clientStacktrace = ServiceInvocationLoggingHelper.getThreadLocalClientStacktrace()) != null) {
            sb.append("\nclient:\n").append(clientStacktrace);
        }
        return sb.toString();
    }

    public static void reportStackTrace(String message) {
        message = IncidentsLog.enrichMessage(message);
        if (ShutdownStatus.isShutdown()) {
            logger.warn(message);
        } else {
            logger.error(message);
        }
    }

    public static void reportAdminStackTrace(String message) {
        message = IncidentsLog.enrichMessage(message);
        adminLogger.error(message);
    }

    public static void reportUserStackTrace(String message) {
        message = IncidentsLog.enrichMessage(message);
        userLogger.error(message);
    }

    private static StackTraceElement[] modifyStackTrace() {
        return (StackTraceElement[])Stream.concat(Stream.of(IncidentsHelper.getContextStackTraceElement("ApplicationId", Environment.getApplicationId()), IncidentsHelper.getContextStackTraceElement("GitRevision", Environment.getGitRevision()), IncidentsHelper.getContextStackTraceElement("Login", UserData.get().getCurrentUser()), IncidentsHelper.getContextStackTraceElement("Date", DATE_FORMAT.format(new Date()))), IncidentsContext.getContext().entrySet().stream().map(entry -> IncidentsHelper.getContextStackTraceElement((String)entry.getKey(), (String)entry.getValue()))).toArray(StackTraceElement[]::new);
    }

    static {
        IncidentsLog.registerExceptionDecomposer(ExecutionException.class, STANDARD_EXCEPTION_DECOMPOSER);
        IncidentsLog.registerExceptionDecomposer(UndeclaredThrowableException.class, STANDARD_EXCEPTION_DECOMPOSER);
        IncidentsLog.registerExceptionDecomposer(IncidentsIgnorableException.class, STANDARD_EXCEPTION_DECOMPOSER);
        SIMPLE_EXCEPTION_IGNORE_RULE = t -> true;
        exceptionIgnoreRules = new HashMap();
        unignorableExceptions = new HashSet();
        IncidentsLog.registerExceptionIgnoreRule(WebServerError.class, SIMPLE_EXCEPTION_IGNORE_RULE);
        IncidentsLog.registerExceptionIgnoreRule(CannotConnectException.class, SIMPLE_EXCEPTION_IGNORE_RULE);
        IncidentsLog.registerExceptionIgnoreRule(IncidentsIgnorableException.class, t -> ((IncidentsIgnorableException)((Object)t)).isIgnoreIncidents());
        IncidentsLog.registerExceptionIgnoreRule(ServiceException.class, e -> ((ServiceException)e).isForUser());
        exceptionAdminRules = new HashMap();
        IncidentsLog.registerExceptionAdminRule(ServiceException.class, e -> ((ServiceException)e).isForAdmin());
        exceptionUserRules = new HashMap();
        IncidentsLog.registerExceptionUserRule(ServiceException.class, e -> ((ServiceException)e).isForUser());
        logger = LoggerFactory.getLogger(IncidentsLog.class);
        adminLogger = LoggerFactory.getLogger((String)IncidentsLog.class.getName().concat("Admin"));
        userLogger = LoggerFactory.getLogger((String)IncidentsLog.class.getName().concat("User"));
        DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss:SSS");
    }

    public static interface ExceptionRule {
        public boolean matches(Throwable var1);
    }

    public static interface ExceptionDecomposer {
        public Stream<Throwable> decompose(Throwable var1);
    }
}

