/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RussianNumberConverter {
    protected static final String SEPARATOR = " ";
    private static final String MINUS = "\u043c\u0438\u043d\u0443\u0441";
    private static final String INFINITY = "\u0431\u0435\u0441\u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0441\u0442\u044c";
    private static final String[] teens = new String[]{"\u043e\u0434\u0438\u043d\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0434\u0432\u0435\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0447\u0435\u0442\u044b\u0440\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u043f\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0432\u043e\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0434\u0435\u0432\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c"};
    private static final String[] tens = new String[]{"\u0434\u0435\u0441\u044f\u0442\u044c", "\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c", "\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c", "\u0441\u043e\u0440\u043e\u043a", "\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442", "\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442", "\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442", "\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442", "\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e"};
    private static final String[] hundreds = new String[]{"\u0441\u0442\u043e", "\u0434\u0432\u0435\u0441\u0442\u0438", "\u0442\u0440\u0438\u0441\u0442\u0430", "\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430", "\u043f\u044f\u0442\u044c\u0441\u043e\u0442", "\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442", "\u0441\u0435\u043c\u044c\u0441\u043e\u0442", "\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442", "\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442"};
    private static final String[] exponent = new String[]{"", "\u0442\u044b\u0441\u044f\u0447\u0430", "\u043c\u0438\u043b\u043b\u0438\u043e\u043d", "\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434", "\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043d\u043e\u043d\u0438\u043b\u043b\u0438\u043e\u043d", "\u0434\u0435\u0446\u0438\u043b\u043b\u0438\u043e\u043d", "\u0443\u043d\u0434\u0435\u0446\u0438\u043b\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u0434\u0435\u0446\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u0434\u0435\u0446\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u0443\u043e\u0440\u0434\u0435\u0446\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0434\u0435\u0446\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0434\u0435\u0446\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0434\u0435\u0446\u0438\u043b\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0434\u0435\u0446\u0438\u043b\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0434\u0435\u0446\u0438\u043b\u043b\u0438\u043e\u043d", "\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0443\u043d\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u0443\u043e\u0440\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0432\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0443\u043d\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0442\u0440\u0438\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0443\u043d\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u043a\u0432\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0443\u043d\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043a\u0432\u0438\u043d\u043a\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0443\u043d\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0441\u0435\u043a\u0441\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0443\u043d\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0441\u0435\u043f\u0442\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0443\u043d\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043e\u043a\u0442\u043e\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0443\u043d\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0434\u0443\u043e\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0435\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043a\u0432\u0438\u043d\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043a\u0441\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043e\u043a\u0442\u043e\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043d\u043e\u043d\u0430\u0433\u0438\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d", "\u0446\u0435\u043d\u0442\u0438\u043b\u043b\u0438\u043e\u043d"};
    private static final Map<Gender, String[]> digits = new HashMap<Gender, String[]>();
    private static final Map<Declension, String> thousands = new HashMap<Declension, String>();

    protected WordsData convertNumber(String number, Gender gender) {
        String numberString = number;
        StringBuilder numberWords = new StringBuilder();
        Declension numberDeclension = null;
        if (numberString.substring(0, 1).equals("-")) {
            numberWords.append(MINUS);
            numberString = numberString.substring(1);
        }
        if (numberString.length() > exponent.length * 3) {
            numberWords.append(INFINITY);
            return new WordsData(numberWords.toString(), Declension.THIRD);
        }
        List<String> splitNumbers = this.splitNumber(numberString);
        for (int i = 0; i < splitNumbers.size(); ++i) {
            String splitNumber = splitNumbers.get(i);
            int pow = splitNumbers.size() - i - 1;
            WordsData wordsData = null;
            wordsData = pow == 0 ? this.convertNumberGroup(splitNumber, gender) : (pow == 1 ? this.convertNumberGroup(splitNumber, Gender.FEMININE) : this.convertNumberGroup(splitNumber, Gender.MASCULINE));
            String numberGroupWords = wordsData.words;
            Declension numberGroupDeclension = wordsData.declension;
            if (numberGroupWords == null) continue;
            if (numberWords.length() > 0) {
                numberWords.append(SEPARATOR);
            }
            numberWords.append(numberGroupWords);
            if (pow == 1) {
                numberWords.append(SEPARATOR);
                numberWords.append(thousands.get((Object)numberGroupDeclension));
            } else if (pow > 1) {
                numberWords.append(SEPARATOR);
                numberWords.append(exponent[pow]);
                if (numberGroupDeclension == Declension.SECOND) {
                    numberWords.append("\u0430");
                } else if (numberGroupDeclension == Declension.THIRD) {
                    numberWords.append("\u043e\u0432");
                }
            }
            numberDeclension = numberGroupDeclension;
        }
        return new WordsData(numberWords.length() > 0 ? numberWords.toString() : null, numberDeclension);
    }

    private WordsData convertNumberGroup(String number, Gender gender) {
        StringBuilder numberWords = new StringBuilder();
        Declension numberDeclension = null;
        int digit = Integer.parseInt(number);
        int e = digit % 10;
        int d = digit % 100 / 10;
        int s = digit % 1000 / 100;
        if (s > 0) {
            numberWords.append(hundreds[s - 1]);
            numberDeclension = Declension.THIRD;
        }
        if (d > 0) {
            if (numberWords.length() > 0) {
                numberWords.append(SEPARATOR);
            }
            if (d == 1 && e > 0) {
                numberWords.append(teens[e - 1]);
                numberDeclension = Declension.THIRD;
                e = 0;
            } else {
                numberWords.append(tens[d - 1]);
                numberDeclension = Declension.THIRD;
            }
        }
        if (e > 0) {
            if (numberWords.length() > 0) {
                numberWords.append(SEPARATOR);
            }
            numberWords.append(digits.get((Object)gender)[e - 1]);
            numberDeclension = e == 1 ? Declension.FIRST : (e < 5 ? Declension.SECOND : Declension.THIRD);
        }
        return new WordsData(numberWords.length() > 0 ? numberWords.toString() : null, numberDeclension);
    }

    private List<String> splitNumber(String number) {
        String last;
        ArrayList<String> numbers = new ArrayList<String>();
        String first = number.substring(0, number.length() % 3);
        if (first.length() > 0) {
            numbers.add(first);
        }
        if ((last = number.substring(first.length())).length() > 0) {
            numbers.addAll(Arrays.asList(last.split("(?<=\\G.{3})")));
        }
        return numbers;
    }

    static {
        digits.put(Gender.NEUTER, new String[]{"\u043e\u0434\u043d\u043e", "\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u0435\u0442\u044b\u0440\u0435", "\u043f\u044f\u0442\u044c", "\u0448\u0435\u0441\u0442\u044c", "\u0441\u0435\u043c\u044c", "\u0432\u043e\u0441\u0435\u043c\u044c", "\u0434\u0435\u0432\u044f\u0442\u044c"});
        digits.put(Gender.MASCULINE, new String[]{"\u043e\u0434\u0438\u043d", "\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u0435\u0442\u044b\u0440\u0435", "\u043f\u044f\u0442\u044c", "\u0448\u0435\u0441\u0442\u044c", "\u0441\u0435\u043c\u044c", "\u0432\u043e\u0441\u0435\u043c\u044c", "\u0434\u0435\u0432\u044f\u0442\u044c"});
        digits.put(Gender.FEMININE, new String[]{"\u043e\u0434\u043d\u0430", "\u0434\u0432\u0435", "\u0442\u0440\u0438", "\u0447\u0435\u0442\u044b\u0440\u0435", "\u043f\u044f\u0442\u044c", "\u0448\u0435\u0441\u0442\u044c", "\u0441\u0435\u043c\u044c", "\u0432\u043e\u0441\u0435\u043c\u044c", "\u0434\u0435\u0432\u044f\u0442\u044c"});
        thousands.put(Declension.FIRST, "\u0442\u044b\u0441\u044f\u0447\u0430");
        thousands.put(Declension.SECOND, "\u0442\u044b\u0441\u044f\u0447\u0438");
        thousands.put(Declension.THIRD, "\u0442\u044b\u0441\u044f\u0447");
    }

    protected static enum Declension {
        FIRST,
        SECOND,
        THIRD;

    }

    protected static enum Gender {
        NEUTER,
        MASCULINE,
        FEMININE;

    }

    protected static class WordsData {
        public final String words;
        public final Declension declension;

        public WordsData(String words, Declension declension) {
            this.words = words;
            this.declension = declension;
        }
    }
}

