/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n.model;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Resources {
    private static boolean tryToUseEnglish = true;
    private static final int MAX_NUM_LOCALES = 8;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final URL base;
    private final String baseName;
    private final ConcurrentHashMap<Locale, Properties> bundles = new ConcurrentHashMap(8, 0.95f, 1);

    public Resources(URL baseUrl) {
        this.base = baseUrl;
        String name = this.base.getPath();
        int p = name.lastIndexOf(47);
        if (p != -1) {
            name = name.substring(p + 1);
        }
        if ((p = name.indexOf(46)) != -1) {
            name = name.substring(0, p);
        }
        this.baseName = "l10n/" + name;
    }

    public Resources(URL baseUrl, String baseFileName) {
        this.base = baseUrl;
        this.baseName = baseFileName;
    }

    public String getResource(String key) {
        return this.getResource(key, LocaleManager.get().getCurrentLocale());
    }

    public String getResource(String key, Locale locale) {
        String result = this.findResource(key, locale);
        if (result != null) {
            return result;
        }
        this.log.warn(String.format("no resource with key %s found for locale %s", key, locale));
        return key;
    }

    public String findResource(String key) {
        return this.findResource(key, LocaleManager.get().getCurrentLocale());
    }

    public String findResource(String key, Locale locale) {
        String result = null;
        try {
            result = this.getBundle(locale).getProperty(key);
        }
        catch (IOException ioe) {
            this.log.error(String.format("failed loading bundle %s for locale %s", this, locale), (Throwable)ioe);
        }
        if (result == null && !Locale.ENGLISH.getLanguage().equals(locale.getLanguage()) && tryToUseEnglish) {
            try {
                result = this.getBundle(Locale.ENGLISH).getProperty(key);
            }
            catch (IOException ioe) {
                this.log.error(String.format("failed loading bundle %s for locale %s", this, Locale.ENGLISH), (Throwable)ioe);
            }
            if (result != null) {
                this.log.warn(String.format("no resource with key %s found for locale %s but exists for default locale", key, locale));
            }
        }
        return result;
    }

    private Properties getBundle(Locale locale) throws IOException {
        Properties result = this.bundles.get(locale);
        if (result == null) {
            Properties savedResult;
            result = this.loadBundle(locale);
            if (result == null) {
                if (!Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                    result = this.loadBundle(Locale.ENGLISH);
                }
                if (result == null) {
                    result = this.loadBundle(null);
                }
                if (result == null) {
                    this.log.warn(String.format("no resources found for locale %s and base %s", locale, this.base + this.baseName));
                    result = new Properties();
                }
            }
            if ((savedResult = this.bundles.putIfAbsent(locale, result)) != null) {
                return savedResult;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadBundle(Locale locale) throws IOException {
        URL url = this.lookup(locale);
        if (url == null) {
            return null;
        }
        Properties result = new Properties();
        InputStream strm = IoUtil.getResourceInputStream(url);
        InputStreamReader rdr = new InputStreamReader(strm, "utf-8");
        try {
            if (url.getPath().toLowerCase().endsWith(".xml")) {
                result.loadFromXML(strm);
            } else {
                result.load(rdr);
            }
        }
        finally {
            ((Reader)rdr).close();
            strm.close();
        }
        this.log.debug(String.format("loaded resources from %s for locale %s", url, locale));
        return result;
    }

    private URL lookup(Locale locale) throws IOException {
        if (locale == null) {
            return this.lookup(this.baseName);
        }
        URL result = this.lookup(this.baseName + '_' + locale.toString());
        if (result != null) {
            return result;
        }
        if (!TextUtil.isBlank(locale.getVariant()) && (result = this.lookup(this.baseName + '_' + locale.getLanguage() + '_' + locale.getCountry())) != null) {
            return result;
        }
        if (TextUtil.isBlank(locale.getCountry()) && (result = this.lookup(this.baseName + '_' + locale.getLanguage() + '_' + locale.getLanguage().toUpperCase())) != null) {
            return result;
        }
        return this.lookup(this.baseName + '_' + locale.getLanguage());
    }

    private URL lookup(String name) throws IOException {
        URL url = new URL(this.base, name + ".properties");
        if (IoUtil.isResourceExists(url)) {
            return url;
        }
        this.log.debug("resources file not found: " + url);
        url = new URL(this.base, name + ".xml");
        if (IoUtil.isResourceExists(url)) {
            return url;
        }
        this.log.debug("resources file not found: " + url);
        return null;
    }

    public static void setTryToUseEnglish(boolean tryToUseEnglish) {
        Resources.tryToUseEnglish = tryToUseEnglish;
    }

    public String toString() {
        return String.format("{Resources: base=%s, baseName=%s}", this.base, this.baseName);
    }
}

