/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.lockmanager;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import java.util.Objects;

public final class LockKeyBuilder {
    private static final String LOCK_NAME = "CLASS:%s,UID:%s,TAG:%s";
    private static final String STANDARD_LOCK_TAG = "integration-bus";
    private final String uid;
    private final Class<?> cls;
    private String tag;

    public LockKeyBuilder(String uid, Class<?> cls) throws NullPointerException {
        this.uid = Objects.requireNonNull(uid);
        this.cls = Objects.requireNonNull(cls);
    }

    public LockKeyBuilder(EntityReference<?> reference) throws NullPointerException {
        this(reference.getUid(), reference.getType());
    }

    public LockKeyBuilder(EntityContainer<?> container) throws NullPointerException {
        this(container.getUid(), container.getEntityType());
    }

    public LockKeyBuilder(BaseAsset baseAsset) throws NullPointerException {
        this(baseAsset.getUid(), baseAsset.getClass());
    }

    public LockKeyBuilder tag(String tag) {
        this.tag = tag;
        return this;
    }

    public static LockKeyBuilder newInstance(Object obj) throws RuntimeException {
        Objects.requireNonNull(obj);
        if (obj instanceof EntityReference) {
            return new LockKeyBuilder((EntityReference)obj);
        }
        if (obj instanceof EntityContainer) {
            return new LockKeyBuilder((EntityContainer)obj);
        }
        if (obj instanceof BaseAsset) {
            return new LockKeyBuilder((BaseAsset)obj);
        }
        throw new IllegalArgumentException("not suupoted cls=" + obj.getClass().getName());
    }

    public String build() {
        if (Objects.isNull(this.tag)) {
            this.tag = STANDARD_LOCK_TAG;
        }
        return "CLASS:" + this.cls.getName() + ",UID:" + this.uid + ",TAG:" + this.tag;
    }
}

