/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.lockmanager;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.lockmanager.LockKeyBuilder;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class LockUtil {
    private LockUtil() {
        throw new RuntimeException("don't do this");
    }

    public static LockManager getLockManager() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return Environment.getPublished(LockManager.class);
    }

    public static String getLockKey(String uid, Class<?> cls, String tag) {
        return new LockKeyBuilder(uid, cls).tag(tag).build();
    }

    public static String getLockKey(String uid, Class<?> type) {
        return LockUtil.getLockKey(uid, type, null);
    }

    public static String getLockKey(EntityReference<?> reference, String tag) {
        return LockUtil.getLockKey(reference.getUid(), reference.getType(), tag);
    }

    public static String getLockKey(EntityReference<?> reference) {
        return LockUtil.getLockKey(reference, null);
    }

    public static String getLockKey(EntityContainer<?> container, String tag) {
        return LockUtil.getLockKey(container.getUid(), container.getEntityType(), tag);
    }

    public static String getLockKey(EntityContainer<?> container) {
        return LockUtil.getLockKey(container, null);
    }

    public static String getLockKey(BaseAsset asset, String tag) {
        return LockUtil.getLockKey(asset.getUid(), asset.getClass(), tag);
    }

    public static String getLockKey(BaseAsset asset) {
        return LockUtil.getLockKey(asset, null);
    }

    private static TimeoutException addContext(TimeoutException e, String name) {
        IncidentsHelper.addStackTraceElement(e, IncidentsHelper.getContextStackTraceElement("lock", name));
        return e;
    }

    public static <V, E extends Exception> V lock(String name, CallableWithException<V, E> body) throws E, InterruptedException, TimeoutException {
        return (V)LockUtil.lock(name, 30L, TimeUnit.MINUTES, body, () -> {
            throw LockUtil.addContext(new TimeoutException("unable to get lock (timeout)"), name);
        });
    }

    public static <V, T extends BaseEntity, E extends Exception> V lock(EntityReference<T> ref, CallableWithException<V, E> body) throws E, InterruptedException, TimeoutException {
        return LockUtil.lock(LockUtil.getLockKey(ref), body);
    }

    public static <V, T extends BaseEntity, E extends Exception> V lock(EntityContainer<T> entity, CallableWithException<V, E> body) throws E, InterruptedException, TimeoutException {
        return LockUtil.lock(LockUtil.getLockKey(entity), body);
    }

    public static <V, T extends BaseAsset, E extends Exception> V lock(T asset, CallableWithException<V, E> body) throws E, InterruptedException, TimeoutException {
        return LockUtil.lock(LockUtil.getLockKey(asset), body);
    }

    public static <V, E extends Exception> V lock(String uid, Class<?> clazz, CallableWithException<V, E> body) throws E, InterruptedException, TimeoutException {
        return LockUtil.lock(LockUtil.getLockKey(uid, clazz), body);
    }

    private static EntityStorageLoadParameters getResolveParams() {
        return (EntityStorageLoadParameters)((EntityStorageLoadParameters)((EntityStorageLoadParameters)new EntityStorageActualizeParameters().noCache()).context("irrelevance-tolerant-query", Boolean.FALSE)).context(EntityStorage.NO_PHYSICAL_STORAGE_CACHE, Boolean.TRUE);
    }

    public static <V, T extends BaseEntity, E extends Exception> V lock(EntityReference<T> ref, CallableWithParameterAndException<EntityContainer<T>, V, E> body) throws E, InterruptedException, TimeoutException {
        return (V)LockUtil.lock(LockUtil.getLockKey(ref), () -> body.call(EntityStorage.get().resolve(ref, LockUtil.getResolveParams())));
    }

    public static <V, T extends BaseEntity, E extends Exception> V lock(EntityContainer<T> entity, CallableWithParameterAndException<EntityContainer<T>, V, E> body) throws E, InterruptedException, TimeoutException {
        return LockUtil.lock(entity.toReference(), body);
    }

    public static <V, T extends BaseAsset, E extends Exception> V lock(T asset, CallableWithParameterAndException<T, V, E> body) throws E, InterruptedException, TimeoutException {
        return (V)LockUtil.lock(LockUtil.getLockKey(asset), () -> body.call(AssetsStorage.get().load(asset.getClass(), asset.getUid())));
    }

    public static <V, T extends BaseAsset, E extends Exception> V lock(String uid, Class<T> clazz, CallableWithParameterAndException<T, V, E> body) throws E, InterruptedException, TimeoutException {
        return (V)LockUtil.lock(LockUtil.getLockKey(uid, clazz), () -> body.call(AssetsStorage.get().load(clazz, uid)));
    }

    public static <E extends Exception> void lock(String name, RunnableWithException<E> body) throws E, InterruptedException, TimeoutException {
        LockUtil.lock(name, 30L, TimeUnit.MINUTES, body, () -> {
            throw LockUtil.addContext(new TimeoutException("unable to get lock (timeout)"), name);
        });
    }

    public static <T extends BaseEntity, E extends Exception> void lock(EntityReference<T> ref, RunnableWithException<E> body) throws E, InterruptedException, TimeoutException {
        LockUtil.lock(LockUtil.getLockKey(ref), body);
    }

    public static <T extends BaseEntity, E extends Exception> void lock(EntityContainer<T> entity, RunnableWithException<E> body) throws E, InterruptedException, TimeoutException {
        LockUtil.lock(LockUtil.getLockKey(entity), body);
    }

    public static <T extends BaseAsset, E extends Exception> void lock(T asset, RunnableWithException<E> body) throws E, InterruptedException, TimeoutException {
        LockUtil.lock(LockUtil.getLockKey(asset), body);
    }

    public static <E extends Exception> void lock(String uid, Class<?> clazz, RunnableWithException<E> body) throws E, InterruptedException, TimeoutException {
        LockUtil.lock(LockUtil.getLockKey(uid, clazz), body);
    }

    public static <T extends BaseEntity, E extends Exception> void lock(EntityReference<T> ref, RunnableWithParameterAndException<EntityContainer<T>, E> body) throws E, InterruptedException, TimeoutException {
        LockUtil.lock(LockUtil.getLockKey(ref), () -> body.run(EntityStorage.get().resolve(ref, LockUtil.getResolveParams())));
    }

    public static <T extends BaseEntity, E extends Exception> void lock(EntityContainer<T> entity, RunnableWithParameterAndException<EntityContainer<T>, E> body) throws E, InterruptedException, TimeoutException {
        LockUtil.lock(entity.toReference(), body);
    }

    public static <T extends BaseAsset, E extends Exception> void lock(T asset, RunnableWithParameterAndException<T, E> body) throws E, InterruptedException, TimeoutException {
        LockUtil.lock(LockUtil.getLockKey(asset), () -> body.run(AssetsStorage.get().load(asset.getClass(), asset.getUid())));
    }

    public static <T extends BaseAsset, E extends Exception> void lock(String uid, Class<T> clazz, RunnableWithParameterAndException<T, E> body) throws E, InterruptedException, TimeoutException {
        LockUtil.lock(LockUtil.getLockKey(uid, clazz), () -> body.run(AssetsStorage.get().load(clazz, uid)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception, E2 extends Exception> void lock(String name, long time, TimeUnit unit, RunnableWithException<E> body, RunnableWithException<E2> fail) throws E, E2, InterruptedException {
        try (NamedLock lock = LockUtil.getLockManager().getLock(name);){
            if (!lock.tryLock(time, unit)) {
                fail.run();
                return;
            }
            try {
                body.run();
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static <T extends BaseEntity, E extends Exception, E2 extends Exception> void lock(EntityReference<T> ref, long time, TimeUnit unit, RunnableWithException<E> body, RunnableWithException<E2> fail) throws E, E2, InterruptedException {
        LockUtil.lock(LockUtil.getLockKey(ref), time, unit, body, fail);
    }

    public static <T extends BaseEntity, E extends Exception, E2 extends Exception> void lock(EntityContainer<T> entity, long time, TimeUnit unit, RunnableWithException<E> body, RunnableWithException<E2> fail) throws E, E2, InterruptedException {
        LockUtil.lock(LockUtil.getLockKey(entity), time, unit, body, fail);
    }

    public static <T extends BaseAsset, E extends Exception, E2 extends Exception> void lock(T asset, long time, TimeUnit unit, RunnableWithException<E> body, RunnableWithException<E2> fail) throws E, E2, InterruptedException {
        LockUtil.lock(LockUtil.getLockKey(asset), time, unit, body, fail);
    }

    public static <E extends Exception, E2 extends Exception> void lock(String uid, Class<?> clazz, long time, TimeUnit unit, RunnableWithException<E> body, RunnableWithException<E2> fail) throws E, E2, InterruptedException {
        LockUtil.lock(LockUtil.getLockKey(uid, clazz), time, unit, body, fail);
    }

    public static <T extends BaseEntity, E extends Exception, E2 extends Exception> void lock(EntityReference<T> ref, long time, TimeUnit unit, RunnableWithParameterAndException<EntityContainer<T>, E> body, RunnableWithException<E2> fail) throws E, E2, InterruptedException {
        LockUtil.lock(LockUtil.getLockKey(ref), time, unit, () -> body.run(EntityStorage.get().resolve(ref, LockUtil.getResolveParams())), fail);
    }

    public static <T extends BaseEntity, E extends Exception, E2 extends Exception> void lock(EntityContainer<T> entity, long time, TimeUnit unit, RunnableWithParameterAndException<EntityContainer<T>, E> body, RunnableWithException<E2> fail) throws E, E2, InterruptedException {
        LockUtil.lock(entity.toReference(), time, unit, body, fail);
    }

    public static <T extends BaseAsset, E extends Exception, E2 extends Exception> void lock(T asset, long time, TimeUnit unit, RunnableWithParameterAndException<T, E> body, RunnableWithException<E2> fail) throws E, E2, InterruptedException {
        LockUtil.lock(LockUtil.getLockKey(asset), time, unit, () -> body.run(AssetsStorage.get().load(asset.getClass(), asset.getUid())), fail);
    }

    public static <T extends BaseAsset, E extends Exception, E2 extends Exception> void lock(String uid, Class<T> clazz, long time, TimeUnit unit, RunnableWithParameterAndException<T, E> body, RunnableWithException<E2> fail) throws E, E2, InterruptedException {
        LockUtil.lock(LockUtil.getLockKey(uid, clazz), time, unit, () -> body.run(AssetsStorage.get().load(clazz, uid)), fail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V, E extends Exception, E2 extends Exception> V lock(String name, long time, TimeUnit unit, CallableWithException<V, E> body, CallableWithException<V, E2> fail) throws E, E2, InterruptedException {
        Throwable throwable = null;
        try (NamedLock lock = LockUtil.getLockManager().getLock(name);){
            V v;
            if (!lock.tryLock(time, unit)) {
                V v2 = fail.call();
                return v2;
            }
            try {
                v = body.call();
            }
            catch (Throwable throwable2) {
                try {
                    lock.unlock();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            lock.unlock();
            return v;
        }
    }

    public static <V, T extends BaseEntity, E extends Exception, E2 extends Exception> V lock(EntityReference<T> ref, long time, TimeUnit unit, CallableWithException<V, E> body, CallableWithException<V, E2> fail) throws E, E2, InterruptedException {
        return LockUtil.lock(LockUtil.getLockKey(ref), time, unit, body, fail);
    }

    public static <V, T extends BaseEntity, E extends Exception, E2 extends Exception> V lock(EntityContainer<T> entity, long time, TimeUnit unit, CallableWithException<V, E> body, CallableWithException<V, E2> fail) throws E, E2, InterruptedException {
        return LockUtil.lock(LockUtil.getLockKey(entity), time, unit, body, fail);
    }

    public static <V, T extends BaseAsset, E extends Exception, E2 extends Exception> V lock(T asset, long time, TimeUnit unit, CallableWithException<V, E> body, CallableWithException<V, E2> fail) throws E, E2, InterruptedException {
        return LockUtil.lock(LockUtil.getLockKey(asset), time, unit, body, fail);
    }

    public static <V, E extends Exception, E2 extends Exception> V lock(String uid, Class<?> clazz, long time, TimeUnit unit, CallableWithException<V, E> body, CallableWithException<V, E2> fail) throws E, E2, InterruptedException {
        return LockUtil.lock(LockUtil.getLockKey(uid, clazz), time, unit, body, fail);
    }

    public static <V, T extends BaseEntity, E extends Exception, E2 extends Exception> V lock(EntityReference<T> ref, long time, TimeUnit unit, CallableWithParameterAndException<EntityContainer<T>, V, E> body, CallableWithException<V, E2> fail) throws E, E2, InterruptedException {
        return (V)LockUtil.lock(LockUtil.getLockKey(ref), time, unit, () -> body.call(EntityStorage.get().resolve(ref, LockUtil.getResolveParams())), fail);
    }

    public static <V, T extends BaseEntity, E extends Exception, E2 extends Exception> V lock(EntityContainer<T> entity, long time, TimeUnit unit, CallableWithParameterAndException<EntityContainer<T>, V, E> body, CallableWithException<V, E2> fail) throws E, E2, InterruptedException {
        return LockUtil.lock(entity.toReference(), time, unit, body, fail);
    }

    public static <V, T extends BaseAsset, E extends Exception, E2 extends Exception> V lock(T asset, long time, TimeUnit unit, CallableWithParameterAndException<T, V, E> body, CallableWithException<V, E2> fail) throws E, E2, InterruptedException {
        return (V)LockUtil.lock(LockUtil.getLockKey(asset), time, unit, () -> body.call(AssetsStorage.get().load(asset.getClass(), asset.getUid())), fail);
    }

    public static <V, T extends BaseAsset, E extends Exception, E2 extends Exception> V lock(String uid, Class<T> clazz, long time, TimeUnit unit, CallableWithParameterAndException<T, V, E> body, CallableWithException<V, E2> fail) throws E, E2, InterruptedException {
        return (V)LockUtil.lock(LockUtil.getLockKey(uid, clazz), time, unit, () -> body.call(AssetsStorage.get().load(clazz, uid)), fail);
    }

    @FunctionalInterface
    public static interface RunnableWithParameterAndException<P, E extends Exception> {
        public void run(P var1) throws E;
    }

    @FunctionalInterface
    public static interface CallableWithParameterAndException<P, V, E extends Exception> {
        public V call(P var1) throws E;
    }

    @FunctionalInterface
    public static interface RunnableWithException<E extends Exception> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface CallableWithException<V, E extends Exception> {
        public V call() throws E;
    }

    private static class Holder {
        public static final LockManager INSTANCE = Environment.getPublished(LockManager.class);

        private Holder() {
        }
    }
}

