/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class EntityType
extends BaseClassType {
    private boolean root;
    private final Set<String> interfaces = new LinkedHashSet<String>();
    private final Map<String, Property> properties = new LinkedHashMap<String, Property>();
    private final Map<String, EntityCollection> collections = new LinkedHashMap<String, EntityCollection>();
    private final Set<String> entityRenamers = new HashSet<String>();
    private boolean cached;
    private boolean cachedReference;
    private boolean validatable;
    private boolean nestedActualize = true;
    private boolean hidden;

    EntityType() {
    }

    public boolean isRoot() {
        return this.root;
    }

    public List<String> getInterfaces() {
        return Collections.unmodifiableList(new ArrayList<String>(this.interfaces));
    }

    public Map<String, Property> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, EntityCollection> getCollections() {
        return Collections.unmodifiableMap(this.collections);
    }

    public Set<String> getEntityRenamers() {
        return this.entityRenamers;
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean isCachedReference() {
        return this.cachedReference;
    }

    public boolean isValidatable() {
        return this.validatable;
    }

    public boolean isNestedActualize() {
        return this.nestedActualize;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        this.root = this.root || XHelper.readBoolean(elm, "@root", false);
        this.cached = this.cached || XHelper.readBoolean(elm, "@cached", false);
        this.cachedReference = this.cachedReference || XHelper.readBoolean(elm, "@cachedReference", false);
        this.nestedActualize = this.nestedActualize && XHelper.readBoolean(elm, "@nestedActualize", true);
        this.hidden = this.hidden || XHelper.readBoolean(elm, "@hidden", false);
        for (Element itfElm : XmlUtil.getElements(elm, "interface")) {
            this.interfaces.add(XmlUtil.getValue(itfElm, "@id"));
        }
        for (Element propElm : XmlUtil.getElements(elm, "property")) {
            String propId = XHelper.readString(propElm, "@id");
            Property prop = this.properties.get(propId);
            if (prop == null) {
                prop = new Property(this.getId());
                this.properties.put(propId, prop);
            }
            prop.fromXml(propElm, res);
        }
        for (Element collElm : XmlUtil.getElements(elm, "collection")) {
            String collId = XHelper.readString(collElm, "@id");
            EntityCollection coll = this.collections.get(collId);
            if (coll == null) {
                coll = new EntityCollection(this.getId());
                this.collections.put(collId, coll);
            }
            coll.fromXml(collElm, res);
        }
        for (Element collElm : XmlUtil.getElements(elm, "entity-renamer")) {
            this.entityRenamers.add(XHelper.readString(collElm, "@className"));
        }
        this.validatable = this.validatable || XHelper.readBoolean(elm, "@validatable", false);
    }
}

