/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class IndexCollection
extends BaseMetaElement {
    private String type;
    private String elementType;
    private boolean searchable;
    private boolean filterable;
    private boolean viewable;
    private boolean system;
    private boolean dbIndexed;
    private boolean aggregated = false;
    private boolean orderIgnoreCase;
    private boolean fxImplicit;
    private String format;
    private String scope;
    private String projection;
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();
    private final String owner;

    IndexCollection(String ownerId) {
        this.owner = ownerId;
    }

    public String getType() {
        return this.type;
    }

    public String getElementType() {
        return this.elementType;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean isDbIndexed() {
        return this.dbIndexed;
    }

    public boolean isAggregated() {
        return this.aggregated;
    }

    public String getFormat() {
        return this.format;
    }

    public String getScope() {
        return this.scope;
    }

    public String getProjection() {
        return this.projection;
    }

    public boolean isOrderIgnoreCase() {
        return this.orderIgnoreCase;
    }

    public boolean isFxImplicit() {
        return this.fxImplicit;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    protected String getResourceKey() {
        return this.owner + '.' + this.getId();
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        if (TextUtil.isBlank(this.type)) {
            this.type = XHelper.readString(elm, "@type");
        }
        if (TextUtil.isBlank(this.elementType)) {
            this.elementType = XHelper.readString(elm, "@element-type");
        }
        this.searchable = this.searchable || XHelper.readBoolean(elm, "@searchable", true);
        this.filterable = this.filterable || XHelper.readBoolean(elm, "@filterable", true);
        this.viewable = this.viewable || XHelper.readBoolean(elm, "@viewable", true);
        boolean bl = this.system = this.system || XHelper.readBoolean(elm, "@system", false);
        if (TextUtil.isBlank(this.format)) {
            this.format = XHelper.readString(elm, "@format");
        }
        for (Element paramElm : XmlUtil.getElements(elm, "param")) {
            this.parameters.put(XHelper.readString(paramElm, "@name"), XHelper.readString(paramElm, "@value"));
        }
        this.dbIndexed = this.dbIndexed || XHelper.readBoolean(elm, "@dbIndexed", true);
        this.aggregated = XHelper.readBoolean(elm, "@aggregated", this.aggregated);
        if (TextUtil.isBlank(this.scope)) {
            this.scope = XHelper.readString(elm, "@scope");
        }
        this.orderIgnoreCase = this.orderIgnoreCase || XHelper.readBoolean(elm, "@order-ignore-case", false);
        this.fxImplicit = this.fxImplicit || XHelper.readBoolean(elm, "@fx-implicit", false);
        this.projection = XHelper.readString(elm, "@projection");
    }
}

