/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.export;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.export.BaseExportedElementType;
import com.gridnine.xtrip.common.meta.export.ExportMetadataProvider;
import com.gridnine.xtrip.common.meta.export.ExportedCustomEntityDescriptor;
import com.gridnine.xtrip.common.meta.export.ExportedEntityType;
import com.gridnine.xtrip.common.meta.export.ExportedObjectsMetadataHelper;
import com.gridnine.xtrip.common.model.Xeption;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExportMetaRegistry
extends ExportMetadataProvider {
    private final Map<String, ExportedEntityType> entities = new HashMap<String, ExportedEntityType>();
    private final Map<BaseExportedElementType, List<URL>> sources = new HashMap<BaseExportedElementType, List<URL>>();
    private final Map<BaseExportedElementType, String> fullIds = new HashMap<BaseExportedElementType, String>();
    private final Map<String, Resources> resources = new HashMap<String, Resources>();
    private final Map<String, ExportedCustomEntityDescriptor> customEntitiesDescriptors = new HashMap<String, ExportedCustomEntityDescriptor>();

    @Override
    public ExportedEntityType getEntity(String entityId) {
        ExportedEntityType result = this.entities.get(entityId);
        if (result == null) {
            throw Xeption.forDeveloper("entity {0} is not registered", entityId);
        }
        return result;
    }

    @Override
    public Map<String, ExportedEntityType> getEntities() {
        return this.entities;
    }

    public <E extends BaseExportedElementType> void addSources(E elm, URL uri, String elmId) {
        List<URL> urls = this.sources.get(elm);
        this.fullIds.put(elm, elmId);
        if (urls == null) {
            urls = new ArrayList<URL>();
            this.sources.put(elm, urls);
        }
        urls.add(uri);
        Resources res = this.resources.get(uri.toString());
        if (res == null) {
            this.resources.put(uri.toString(), new Resources(uri));
        }
    }

    public List<URL> getSources(BaseExportedElementType elm) {
        return this.sources.get(elm);
    }

    @Override
    public String getDisplayName(BaseExportedElementType type, Locale loc) {
        String fullId = this.fullIds.get(type);
        for (URL url : this.sources.get(type)) {
            String descr;
            Resources res = this.resources.get(url.toString());
            if (res == null || (descr = res.getResource(fullId + ".name", loc)) == null) continue;
            return descr;
        }
        return null;
    }

    @Override
    public String getDocumentation(BaseExportedElementType type, Locale loc) {
        String fullId = this.fullIds.get(type);
        for (URL url : this.sources.get(type)) {
            Resources res = this.resources.get(url.toString());
            if (res == null) continue;
            String descr = res.findResource(fullId + ".description", loc);
            if (descr != null) {
                return descr;
            }
            String fullId2 = ExportedObjectsMetadataHelper.getPropertyName(fullId);
            if (!fullId.equals(fullId2) && (descr = res.findResource(fullId2 + ".description", loc)) != null) {
                return descr;
            }
            descr = res.getResource(fullId + ".doc", loc);
            if (descr == null) continue;
            return descr;
        }
        return null;
    }

    @Override
    public ExportedCustomEntityDescriptor getCustomEntityDescriptor(String entityId) {
        return this.customEntitiesDescriptors.get(entityId);
    }

    public Map<String, ExportedCustomEntityDescriptor> getCustomEntityDescriptors() {
        return this.customEntitiesDescriptors;
    }
}

