/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.export.parser;

import com.gridnine.xtrip.common.meta.export.BaseExportedElementType;
import com.gridnine.xtrip.common.meta.export.ExportMetaRegistry;
import com.gridnine.xtrip.common.meta.export.ExportedCollectionType;
import com.gridnine.xtrip.common.meta.export.ExportedElementDataType;
import com.gridnine.xtrip.common.meta.export.ExportedEntityType;
import com.gridnine.xtrip.common.meta.export.ExportedPropertyType;
import com.gridnine.xtrip.common.meta.export.ExportedRootEntityType;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ExportedObjectsMetadataXmlParser {
    private static Logger log = LoggerFactory.getLogger(ExportedObjectsMetadataXmlParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRegistry(ExportMetaRegistry registry, URL meta) throws Exception {
        log.debug("registering exchange meta data from " + meta);
        try (InputStream strm = meta.openStream();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setSchema(schemaFactory.newSchema(ExportedObjectsMetadataXmlParser.class.getResource("export_meta_1_0.xsd")));
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException ex) throws SAXException {
                    throw ex;
                }

                @Override
                public void fatalError(SAXParseException ex) throws SAXException {
                    throw ex;
                }

                @Override
                public void warning(SAXParseException ex) {
                }
            });
            Element root = docBuilder.parse(strm).getDocumentElement();
            for (Element entityElm : XmlUtil.getElements(root, "entity")) {
                ExportedObjectsMetadataXmlParser.addEntity(registry, entityElm, meta);
            }
            for (Element entityElm : XmlUtil.getElements(root, "root-entity")) {
                ExportedObjectsMetadataXmlParser.addRootEntity(registry, entityElm, meta);
            }
        }
        log.info("view model data registered from " + meta);
    }

    private static void addRootEntity(ExportMetaRegistry registry, Element entityElm, URL meta) {
        String id = XHelper.readString(entityElm, "@id");
        ExportedRootEntityType exportedEntity = (ExportedRootEntityType)registry.getEntities().get(id);
        if (exportedEntity == null) {
            exportedEntity = new ExportedRootEntityType();
            exportedEntity.setId(id);
            registry.getEntities().put(id, exportedEntity);
        }
        ExportedObjectsMetadataXmlParser.updateEntity(exportedEntity, entityElm, registry, meta);
        exportedEntity.setRootTagName(XHelper.readString(entityElm, "@rootTagName"));
        exportedEntity.setXsdNamespace(XHelper.readString(entityElm, "@xsdNamespace"));
    }

    private static void addEntity(ExportMetaRegistry registry, Element entityElm, URL meta) throws Exception {
        String id = XHelper.readString(entityElm, "@id");
        ExportedEntityType exportedEntity = registry.getEntities().get(id);
        if (exportedEntity == null) {
            exportedEntity = new ExportedEntityType();
            exportedEntity.setId(id);
            registry.getEntities().put(id, exportedEntity);
        }
        ExportedObjectsMetadataXmlParser.updateEntity(exportedEntity, entityElm, registry, meta);
    }

    private static void updateEntity(ExportedEntityType exportedEntity, Element entityElm, ExportMetaRegistry registry, URL meta) {
        exportedEntity.setDateFormat(XHelper.readString(entityElm, "@dateFormat"));
        exportedEntity.setDateTimeFormat(XHelper.readString(entityElm, "@dateTimeFormat"));
        registry.addSources(exportedEntity, meta, exportedEntity.getId());
        for (Element item : XmlUtil.getChildren(entityElm)) {
            BaseExportedElementType prop;
            String nodeName = item.getNodeName();
            if ("property".equals(nodeName)) {
                String propertyId = XHelper.readString(item, "@id");
                prop = exportedEntity.getProperties().get(propertyId);
                if (prop == null) {
                    prop = new ExportedPropertyType();
                    prop.setId(propertyId);
                    exportedEntity.getProperties().put(propertyId, (ExportedPropertyType)prop);
                }
                ((ExportedPropertyType)prop).setType(ExportedObjectsMetadataXmlParser.parseType(XHelper.readString(item, "@type")));
                ((ExportedPropertyType)prop).setEntityId(XHelper.readString(item, "@entityId"));
                registry.addSources(prop, meta, String.format("%s.%s", exportedEntity.getId(), prop.getId()));
                continue;
            }
            if ("collection".equals(nodeName)) {
                String collectionId = XHelper.readString(item, "@id");
                prop = exportedEntity.getCollections().get(collectionId);
                if (prop == null) {
                    prop = new ExportedCollectionType();
                    prop.setId(collectionId);
                    exportedEntity.getCollections().put(collectionId, (ExportedCollectionType)prop);
                }
                for (Element typeElm : XmlUtil.getElements(item, "item")) {
                    ((ExportedCollectionType)prop).getPossibleElements().put(XHelper.readString(typeElm, "@tagName"), XHelper.readString(typeElm, "@type"));
                }
                String extenderClass = XHelper.readString(item, "@extenderClass");
                if (!TextUtil.isBlank(extenderClass)) {
                    ((ExportedCollectionType)prop).setExtenderClass(extenderClass);
                }
                registry.addSources(prop, meta, String.format("%s.%s", exportedEntity.getId(), prop.getId()));
                continue;
            }
            throw Xeption.forDeveloper("unsupported child type {0} in entity {1}", nodeName, exportedEntity.getId());
        }
    }

    private static ExportedElementDataType parseType(String value) {
        if (null == value) {
            return null;
        }
        String thing = value.toUpperCase().replace("-", "");
        if ("REF".equals(thing)) {
            return ExportedElementDataType.REFERENCE;
        }
        if ("BOOL".equals(thing)) {
            return ExportedElementDataType.BOOLEAN;
        }
        if ("INT".equals(thing)) {
            return ExportedElementDataType.INTEGER;
        }
        if ("DECIMAL".equals(thing)) {
            return ExportedElementDataType.BIGDECIMAL;
        }
        return ExportedElementDataType.valueOf(thing);
    }

    private ExportedObjectsMetadataXmlParser() {
    }
}

