/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.reflection;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.meta.BaseProperty;
import com.gridnine.xtrip.common.meta.DictionaryProperty;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.json.JSONObject;

public class MetaReflectionHelper {
    private static final Map<String, String> PRIMITIVE_TYPES = new HashMap<String, String>();

    public static String getTypeForIntrospection(BaseProperty prop) throws Exception {
        return MetaReflectionHelper.getTypeForIntrospection(prop, MetaRegistry.get());
    }

    public static String getTypeForIntrospection(BaseProperty prop, MetaRegistry metaRegistry) throws Exception {
        String type;
        boolean isReference = true;
        if (prop instanceof Property) {
            isReference = ((Property)prop).isReference();
        } else if (prop instanceof IndexProperty) {
            isReference = metaRegistry.getEntities().containsKey(prop.getType()) || metaRegistry.getEntityRefs().containsKey(prop.getType());
        } else if (prop instanceof DictionaryProperty) {
            isReference = ((DictionaryProperty)prop).isReference();
        } else {
            throw new IllegalArgumentException("unexpected type " + prop.getClass().getName());
        }
        if (prop.isLocalizable()) {
            type = L10nString.class.getName();
        } else if (metaRegistry.getDictionaries().containsKey(prop.getType())) {
            type = String.format("%s<%s>", DictionaryReference.class.getName(), prop.getType());
        } else if (prop.getType().contains("||")) {
            String[] classNames = prop.getType().split("[|]{2}");
            type = String.format("%s<%s, %s>", NestedEntityReference.class.getName(), classNames[0], classNames[1]);
        } else if (isReference) {
            String subtype = prop.getType();
            EntityType ett = metaRegistry.getEntities().get(prop.getType());
            if (ett == null || ett.isAbstract()) {
                subtype = "? extends " + subtype;
            }
            type = EntityReference.class.getName() + "<" + subtype + ">";
        } else {
            type = "compressed".equals(prop.getType()) ? "byte[]" : ("text".equals(prop.getType()) ? "String" : (PRIMITIVE_TYPES.containsKey(prop.getType()) ? PRIMITIVE_TYPES.get(prop.getType()) : prop.getType()));
        }
        return type;
    }

    public static String getTypeForIntrospection(EntityCollection coll, MetaRegistry metaRegistry) throws Exception {
        String type;
        boolean isReference;
        boolean bl = isReference = metaRegistry.getEntities().containsKey(coll.getElementType()) || metaRegistry.getEntityRefs().containsKey(coll.getElementType());
        if (metaRegistry.getDictionaries().containsKey(coll.getElementType())) {
            type = String.format("%s<%s>", DictionaryReference.class.getName(), coll.getElementType());
        } else if (coll.getElementType().contains("||")) {
            String[] classNames = coll.getElementType().split("[|]{2}");
            type = String.format("%s<%s, %s>", NestedEntityReference.class.getName(), classNames[0], classNames[1]);
        } else if (isReference) {
            String subtype = coll.getElementType();
            EntityType ett = metaRegistry.getEntities().get(coll.getElementType());
            if (ett == null || ett.isAbstract()) {
                subtype = "? extends " + subtype;
            }
            type = EntityReference.class.getName() + "<" + subtype + ">";
        } else {
            type = "text".equals(coll.getElementType()) ? "String" : (PRIMITIVE_TYPES.containsKey(coll.getElementType()) ? PRIMITIVE_TYPES.get(coll.getElementType()) : coll.getElementType());
        }
        return type;
    }

    public static String getJavaTypeForRest(String type, MetaRegistry modelRegistry, RestMetaRegistry restRegistry, boolean noPrimitive) {
        if ("string".equals(type)) {
            return "String";
        }
        if ("boolean".equals(type)) {
            return noPrimitive ? "Boolean" : "boolean";
        }
        if ("bytes".equals(type) || "byte[]".equals(type)) {
            return "byte[]";
        }
        if ("byte".equals(type)) {
            return noPrimitive ? "Byte" : "byte";
        }
        if ("char".equals(type)) {
            return noPrimitive ? "Character" : "char";
        }
        if ("int".equals(type)) {
            return noPrimitive ? "Integer" : "int";
        }
        if ("long".equals(type)) {
            return noPrimitive ? "Long" : "long";
        }
        if ("float".equals(type)) {
            return noPrimitive ? "Float" : "float";
        }
        if ("double".equals(type)) {
            return noPrimitive ? "Double" : "double";
        }
        if ("big-int".equals(type)) {
            return BigInteger.class.getName();
        }
        if ("big-decimal".equals(type)) {
            return BigDecimal.class.getName();
        }
        if ("timestamp".equals(type)) {
            return Date.class.getName();
        }
        if ("date-local".equals(type)) {
            return org.joda.time.LocalDate.class.getName();
        }
        if ("date-local-java".equals(type)) {
            return LocalDate.class.getName();
        }
        if ("time-local".equals(type)) {
            return LocalTime.class.getName();
        }
        if ("time-local-java".equals(type)) {
            return java.time.LocalTime.class.getName();
        }
        if ("date-time-local".equals(type)) {
            return LocalDateTime.class.getName();
        }
        if ("date-time-local-java".equals(type)) {
            return java.time.LocalDateTime.class.getName();
        }
        if ("date-time".equals(type)) {
            return DateTime.class.getName();
        }
        if ("json-object".equals(type)) {
            return JSONObject.class.getName();
        }
        if (type.startsWith("collection<")) {
            return Collection.class.getName() + type.substring(10);
        }
        if (restRegistry.getEntities().containsKey(type) || restRegistry.getEnums().containsKey(type) || modelRegistry.getEnums().containsKey(type)) {
            return type;
        }
        if (BaseDictionary.class.getName().equals(type) || modelRegistry.getDictionaries().containsKey(type)) {
            return DictionaryReference.class.getName() + '<' + type + '>';
        }
        if ("com.gridnine.xtrip.common.model.system.DownloadableData".equals(type) || "com.gridnine.xtrip.common.model.system.BinaryData".equals(type)) {
            return type;
        }
        EntityType entityType = modelRegistry.getEntities().get(type);
        if (entityType != null && MetaRegistryHelper.isRoot(entityType) || BaseEntity.class.getName().equals(type)) {
            return EntityReference.class.getName() + '<' + type + '>';
        }
        throw new IllegalArgumentException("invalid type " + type);
    }

    public static String getTypeForIntrospection(String type, MetaRegistry modelRegistry, RestMetaRegistry restRegistry, boolean noPrimitive) {
        String result = MetaReflectionHelper.getJavaTypeForRest(type, modelRegistry, restRegistry, noPrimitive);
        int i = result.indexOf(60);
        return -1 == i ? result : result.substring(0, i);
    }

    public static String getOriginalType(String type, MetaRegistry modelRegistry, RestMetaRegistry restRegistry) {
        if (restRegistry.getEntities().containsKey(type) || restRegistry.getEnums().containsKey(type) || modelRegistry.getEnums().containsKey(type)) {
            return type;
        }
        if (BaseDictionary.class.getName().equals(type) || modelRegistry.getDictionaries().containsKey(type)) {
            return type;
        }
        EntityType entityType = modelRegistry.getEntities().get(type);
        if (entityType != null && MetaRegistryHelper.isRoot(entityType)) {
            return type;
        }
        return null;
    }

    private MetaReflectionHelper() {
    }

    static {
        PRIMITIVE_TYPES.put("byte", "Byte");
        PRIMITIVE_TYPES.put("short", "Short");
        PRIMITIVE_TYPES.put("int", "Integer");
        PRIMITIVE_TYPES.put("long", "Long");
        PRIMITIVE_TYPES.put("float", "Float");
        PRIMITIVE_TYPES.put("double", "Double");
        PRIMITIVE_TYPES.put("boolean", "Boolean");
        PRIMITIVE_TYPES.put("char", "Character");
    }
}

