/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.rest;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.rest.BaseRestType;
import com.gridnine.xtrip.common.meta.rest.RestEnumItem;
import com.gridnine.xtrip.common.meta.rest.RestEnumProperty;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.w3c.dom.Element;

public class RestEnumType
extends BaseRestType {
    private final Set<String> interfaces = new LinkedHashSet<String>();
    private final Map<String, RestEnumItem> items = new LinkedHashMap<String, RestEnumItem>();
    private final Map<String, RestEnumProperty> properties = new LinkedHashMap<String, RestEnumProperty>();
    private boolean shortName;
    private boolean propertyValue;

    public Map<String, RestEnumItem> getItems() {
        return this.items;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public Map<String, RestEnumProperty> getProperties() {
        return this.properties;
    }

    public boolean isShortName() {
        return this.shortName;
    }

    public void setShortName(boolean shortName) {
        this.shortName = shortName;
    }

    public boolean isPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(boolean propertyValue) {
        this.propertyValue = propertyValue;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        this.shortName = this.shortName || XHelper.readBoolean(elm, "@shortName", false);
        this.propertyValue = this.propertyValue || XHelper.readBoolean(elm, "@propertyValue", false);
        Arrays.stream(XmlUtil.getElements(elm, "interface")).filter(Objects::nonNull).forEach(i -> this.interfaces.add(XmlUtil.getValue(i, "@id")));
        Arrays.stream(XmlUtil.getElements(elm, "item")).filter(Objects::nonNull).forEach(i -> {
            String itemId = XHelper.readString(i, "@id");
            if (!this.items.containsKey(itemId)) {
                this.items.put(itemId, new RestEnumItem(this.getId()));
            }
            this.items.get(itemId).fromXml((Element)i, res);
        });
        Element properties = XmlUtil.getElement(elm, "properties");
        if (properties != null) {
            Arrays.stream(XmlUtil.getElements(properties, "property")).filter(Objects::nonNull).forEach(p -> {
                String propertyId = XHelper.readString(p, "@id");
                if (!this.properties.containsKey(propertyId)) {
                    this.properties.put(propertyId, new RestEnumProperty(this.getId()));
                }
                this.properties.get(propertyId).fromXml((Element)p, res);
            });
        }
    }
}

