/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.rest;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.rest.BaseServiceMetaElement;
import com.gridnine.xtrip.common.meta.rest.RestStringWithLang;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class RestServiceOperation
extends BaseServiceMetaElement {
    private String groupId;
    private String method;
    private String path;
    private String routeId;
    private String validatingRouteId;
    private String openRouteId;
    private String permissionDeniedRouteId;
    private Boolean auth;
    private ParametersDescriptor parametersDescriptor;
    private EntityDescriptor entityDescriptor;
    private ResultDescriptor resultDescriptor;
    private Boolean websocket;
    private Boolean corsSupported;
    private Boolean hideDocs;
    private final List<RestStringWithLang> documentation = new ArrayList<RestStringWithLang>();

    public String getGroupId() {
        return this.groupId;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public String getValidatingRouteId() {
        return this.validatingRouteId;
    }

    public String getOpenRouteId() {
        return this.openRouteId;
    }

    public Boolean getAuth() {
        return this.auth;
    }

    public ParametersDescriptor getParametersDescriptor() {
        return this.parametersDescriptor;
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public ResultDescriptor getResultDescriptor() {
        return this.resultDescriptor;
    }

    public Boolean getWebsocket() {
        return this.websocket;
    }

    public Boolean getCorsSupported() {
        return this.corsSupported;
    }

    public Boolean getHideDocs() {
        return this.hideDocs;
    }

    public List<RestStringWithLang> getDocumentation() {
        return this.documentation;
    }

    public String getPermissionDeniedRouteId() {
        return this.permissionDeniedRouteId;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        Element descrElm;
        super.fromXml(elm, res);
        if (TextUtil.isBlank(this.groupId)) {
            this.groupId = XHelper.readString(elm, "@group-id");
        }
        if (TextUtil.isBlank(this.method)) {
            this.method = XHelper.readString(elm, "@method");
        }
        if (TextUtil.isBlank(this.path)) {
            this.path = XHelper.readString(elm, "@path");
        }
        if (TextUtil.isBlank(this.routeId)) {
            this.routeId = XHelper.readString(elm, "@route");
        }
        if (TextUtil.isBlank(this.validatingRouteId)) {
            this.validatingRouteId = XHelper.readString(elm, "@validating-route");
        }
        if (TextUtil.isBlank(this.openRouteId)) {
            this.openRouteId = XHelper.readString(elm, "@open-route");
        }
        this.permissionDeniedRouteId = XHelper.readString(elm, "@permissionDeniedRoute");
        if (this.auth == null) {
            this.auth = XHelper.readBoolean(elm, "@auth");
        }
        if ((descrElm = XmlUtil.getElement(elm, "parameters")) != null) {
            this.parametersDescriptor = new ParametersDescriptor();
            this.parametersDescriptor.fromXml(descrElm);
        }
        if ((descrElm = XmlUtil.getElement(elm, "entity")) != null) {
            this.entityDescriptor = new EntityDescriptor();
            this.entityDescriptor.fromXml(descrElm);
        }
        if ((descrElm = XmlUtil.getElement(elm, "result")) != null) {
            this.resultDescriptor = new ResultDescriptor();
            this.resultDescriptor.fromXml(descrElm);
        }
        if (this.websocket == null) {
            this.websocket = XHelper.readBoolean(elm, "@websocket");
        }
        if (this.corsSupported == null) {
            this.corsSupported = XHelper.readBoolean(elm, "@corsSupported");
        }
        if (this.hideDocs == null) {
            this.hideDocs = XHelper.readBoolean(elm, "@hideDocs");
        }
        for (Element docElm : XmlUtil.getElements(elm, "documentation")) {
            RestStringWithLang doc = new RestStringWithLang();
            doc.fromXml(docElm);
            if (TextUtil.isBlank(doc.getValue())) continue;
            this.documentation.add(doc);
        }
    }

    public static class ResultDescriptor
    extends BaseDescriptor {
        private boolean collection;

        ResultDescriptor() {
        }

        public boolean isCollection() {
            return this.collection;
        }

        @Override
        void fromXml(Element elm) {
            super.fromXml(elm);
            this.collection = XHelper.readBoolean(elm, "@collection", true);
        }
    }

    public static class EntityDescriptor
    extends BaseDescriptor {
        EntityDescriptor() {
        }
    }

    public static class ParametersDescriptor
    extends BaseDescriptor {
        private boolean collection;

        ParametersDescriptor() {
        }

        public boolean isCollection() {
            return this.collection;
        }

        @Override
        void fromXml(Element elm) {
            super.fromXml(elm);
            this.collection = XHelper.readBoolean(elm, "@collection", false);
        }
    }

    public static abstract class BaseDescriptor {
        private String typeId;
        private boolean optional;
        private final List<DocumentationItem> documentation = new ArrayList<DocumentationItem>();

        BaseDescriptor() {
        }

        public String getTypeId() {
            return this.typeId;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public List<DocumentationItem> getDocumentation() {
            return this.documentation;
        }

        void fromXml(Element elm) {
            this.typeId = XHelper.readString(elm, "@type-id");
            this.optional = XHelper.readBoolean(elm, "@optional", false);
            for (Element childElm : XmlUtil.getChildren(elm)) {
                if ("documentation".equals(childElm.getNodeName())) {
                    this.documentation.add(new DocumentationItem(DocumentationItemType.DESCRIPTION, childElm.getAttribute("lang"), XmlUtil.getValue(childElm)));
                    continue;
                }
                if (!"example".equals(childElm.getNodeName())) continue;
                this.documentation.add(new DocumentationItem(DocumentationItemType.EXAMPLE, childElm.getAttribute("lang"), XmlUtil.getValue(childElm)));
            }
        }
    }

    public static class DocumentationItem {
        private final DocumentationItemType type;
        private final String lang;
        private final String content;

        DocumentationItem(DocumentationItemType t, String l, String c) {
            this.type = t;
            this.lang = l;
            this.content = c;
        }

        public DocumentationItemType getType() {
            return this.type;
        }

        public String getLang() {
            return this.lang;
        }

        public String getContent() {
            return this.content;
        }
    }

    public static enum DocumentationItemType {
        DESCRIPTION,
        EXAMPLE;

    }
}

