/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiLabel;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.meta.ui.UiTilesSpace;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UiMetaRegistry
implements Disposable {
    private static final Schema SCHEMA;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, List<URL>> sources = new HashMap<String, List<URL>>();
    private final Map<String, List<URL>> modelSources = new HashMap<String, List<URL>>();
    private final Map<String, List<URL>> labelSources = new HashMap<String, List<URL>>();
    protected final Map<String, UiTilesSpace> spaces = new HashMap<String, UiTilesSpace>();
    protected final Map<String, BaseUiContainer> containers = new HashMap<String, BaseUiContainer>();
    protected final Map<String, BaseUiWidget> sharedWidgets = new HashMap<String, BaseUiWidget>();
    protected final Map<String, UiLabel> labels = new HashMap<String, UiLabel>();
    protected final Map<String, UiModel> models = new HashMap<String, UiModel>();
    protected final Map<String, UiAclResource> aclResources = new HashMap<String, UiAclResource>();

    public static UiMetaRegistry get() {
        return Environment.getPublished(UiMetaRegistry.class);
    }

    public void register(final URL meta) throws Exception {
        Element root;
        this.log.debug("registering meta data from " + meta);
        try (InputStream strm = meta.openStream();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            if (SCHEMA != null) {
                factory.setSchema(SCHEMA);
            }
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException ex) throws SAXException {
                    System.out.println(meta);
                    throw ex;
                }

                @Override
                public void fatalError(SAXParseException ex) throws SAXException {
                    System.out.println(meta);
                    throw ex;
                }

                @Override
                public void warning(SAXParseException ex) {
                }
            });
            root = docBuilder.parse(strm).getDocumentElement();
        }
        final Resources resources = new Resources(meta);
        ProcessingCallback callback = new ProcessingCallback(){

            @Override
            public <C extends BaseUiContainer> C getOrCreateContainer(String id, Supplier<C> supplier) {
                BaseUiContainer result = UiMetaRegistry.this.containers.get(id);
                if (result == null) {
                    result = (BaseUiContainer)supplier.get();
                    UiMetaRegistry.this.containers.put(id, result);
                }
                UiMetaRegistry.this.addSource(id, meta);
                return (C)result;
            }

            @Override
            public <W extends BaseUiWidget> W getOrCreateWidget(String id, Supplier<W> supplier) {
                if (id == null) {
                    return (W)((BaseUiWidget)supplier.get());
                }
                BaseUiWidget result = UiMetaRegistry.this.sharedWidgets.get(id);
                if (result == null) {
                    result = (BaseUiWidget)supplier.get();
                    UiMetaRegistry.this.sharedWidgets.put(id, result);
                }
                return (W)result;
            }

            @Override
            public UiLabel getOrCreateLabel(Element elm) {
                UiLabel result;
                if (elm == null) {
                    return null;
                }
                String id = XHelper.readString(elm, "@id");
                if (id == null) {
                    result = new UiLabel();
                } else {
                    result = UiMetaRegistry.this.labels.get(id);
                    if (result == null) {
                        result = new UiLabel();
                        result.id = id;
                        UiMetaRegistry.this.labels.put(id, result);
                    }
                    UiMetaRegistry.this.addSource(result, meta);
                }
                result.resources.add(resources);
                if (result.content == null) {
                    result.content = XHelper.readString(elm, ".");
                }
                return result;
            }

            @Override
            public void register(UiAclResource res) {
                if (UiMetaRegistry.this.aclResources.containsKey(res.getId())) {
                    throw Xeption.forDeveloper("duplicate ACL resource ID [{0}]", res.getId());
                }
                UiMetaRegistry.this.aclResources.put(res.getId(), res);
            }
        };
        for (Element childElm : XmlUtil.getChildren(root)) {
            BaseUiWidget widget;
            if ("model".equals(childElm.getTagName())) {
                String className = XHelper.readString(childElm, "@class");
                UiModel model = this.models.get(className);
                if (model == null) {
                    model = new UiModel();
                    this.models.put(className, model);
                }
                model.fromXml(childElm);
                this.addSource(model, meta);
                continue;
            }
            String id = XHelper.readString(childElm, "@id");
            if (TextUtil.isBlank(id)) {
                throw Xeption.forDeveloper("top-level element {0} should have an ID attribute", XmlUtil.getPath(childElm));
            }
            if ("tiles-space".equals(childElm.getTagName())) {
                UiTilesSpace space = this.spaces.get(id);
                if (space == null) {
                    space = new UiTilesSpace();
                    this.spaces.put(id, space);
                }
                this.addSource(id, meta);
                space.fromXml(childElm, resources, callback);
                continue;
            }
            if (BaseUiContainer.read(childElm, resources, callback) != null || (widget = BaseUiWidget.read(childElm, resources, callback)) != null) continue;
            throw Xeption.forDeveloper("unknown top-level element {0}", XmlUtil.getPath(childElm));
        }
        this.log.info("meta data registered from " + meta);
    }

    public Map<String, UiTilesSpace> getSpaces() {
        return this.spaces;
    }

    public Map<String, BaseUiContainer> getContainers() {
        return this.containers;
    }

    public Map<String, UiLabel> getLabels() {
        return this.labels;
    }

    public Map<String, UiModel> getModels() {
        return this.models;
    }

    public Map<String, UiAclResource> getAclResources() {
        return this.aclResources;
    }

    public Collection<URL> getSources(BaseUiMetaElement metaElm) {
        List<URL> result = this.sources.get(metaElm.getId());
        return result == null ? Collections.emptyList() : result;
    }

    protected void addSource(String ulElementId, URL source) {
        List<URL> list = this.sources.get(ulElementId);
        if (list == null) {
            list = new ArrayList<URL>();
            this.sources.put(ulElementId, list);
        }
        if (!list.contains(source)) {
            list.add(source);
        }
    }

    public Collection<URL> getSources(UiModel modelElement) {
        List<URL> result = this.modelSources.get(modelElement.getClassName());
        return result == null ? Collections.emptyList() : result;
    }

    protected void addSource(UiModel modelElement, URL source) {
        List<URL> list = this.modelSources.get(modelElement.getClassName());
        if (list == null) {
            list = new ArrayList<URL>();
            this.modelSources.put(modelElement.getClassName(), list);
        }
        if (!list.contains(source)) {
            list.add(source);
        }
    }

    public Collection<URL> getSources(UiLabel labelElement) {
        List<URL> result = labelElement.getId() == null ? null : this.labelSources.get(labelElement.getId());
        return result == null ? Collections.emptyList() : result;
    }

    protected void addSource(UiLabel labelElement, URL source) {
        List<URL> list = this.labelSources.get(labelElement.getId());
        if (list == null) {
            list = new ArrayList<URL>();
            this.labelSources.put(labelElement.getId(), list);
        }
        if (!list.contains(source)) {
            list.add(source);
        }
    }

    @Override
    public void dispose() {
        this.aclResources.clear();
        this.models.clear();
        this.labels.clear();
        this.containers.clear();
        this.sharedWidgets.clear();
        this.spaces.clear();
        this.labelSources.clear();
        this.modelSources.clear();
        this.sources.clear();
        this.log.debug("disposed");
    }

    static {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = schemaFactory.newSchema(UiMetaRegistry.class.getResource("uimodel_1_0.xsd"));
        }
        catch (SAXException e) {
            LoggerFactory.getLogger(UiMetaRegistry.class).error("failed loading XML schema", (Throwable)e);
        }
        SCHEMA = schema;
    }

    static interface ProcessingCallback {
        public <C extends BaseUiContainer> C getOrCreateContainer(String var1, Supplier<C> var2);

        public <W extends BaseUiWidget> W getOrCreateWidget(String var1, Supplier<W> var2);

        public UiLabel getOrCreateLabel(Element var1);

        public void register(UiAclResource var1);
    }
}

