/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.ListWithInjections;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.meta.ui.UiTile;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class UiTilesSpace
extends BaseUiMetaElement {
    private UiModel model;
    private final List<UiModel.Field> properties = new ArrayList<UiModel.Field>();
    private UiElement overview;
    private final ListWithInjections<UiTile> tiles = new ListWithInjections<UiTile>(BaseMetaElement::getId);
    private int columns;

    static UiElement readPayload(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        int n = 0;
        Element[] elementArray = XmlUtil.getChildren(elm);
        int n2 = elementArray.length;
        if (n < n2) {
            Element childElm = elementArray[n];
            if ("container-ref".equals(childElm.getTagName())) {
                return new UiContainerReference(XHelper.readString(childElm, "@id"));
            }
            BaseUiContainer ctr = BaseUiContainer.read(childElm, res, callback);
            if (ctr != null) {
                return new UiContainerReference(ctr.getId());
            }
            return BaseUiWidget.read(childElm, res, callback);
        }
        return null;
    }

    UiTilesSpace() {
    }

    @Override
    protected String getResourceKey() {
        return this.getId();
    }

    public UiModel getModel() {
        return this.model;
    }

    public List<UiModel.Field> getProperties() {
        return this.properties;
    }

    public UiElement getOverview() {
        return this.overview;
    }

    public List<UiTile> getTiles() {
        return this.tiles.asList();
    }

    public int getColumns() {
        return this.columns;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        throw new UnsupportedOperationException();
    }

    void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        Element[] modelElm;
        super.fromXml(elm, res);
        Element aclElm = XmlUtil.getElement(elm, "acl");
        if (aclElm != null) {
            this.acl = new UiAclResource();
            this.acl.fromXml(aclElm, res, callback);
        }
        if ((modelElm = XmlUtil.getElement(elm, "model")) != null) {
            if (this.model == null) {
                this.model = new UiModel();
            }
            this.model.fromXml((Element)modelElm);
        }
        for (Element childElm : XmlUtil.getElements(elm, "property")) {
            UiModel.Field prop = new UiModel.Field();
            prop.fromXml(childElm);
            this.properties.add(prop);
        }
        Element[] overviewElm = XmlUtil.getElement(elm, "overview");
        if (overviewElm != null) {
            this.overview = UiTilesSpace.readPayload((Element)overviewElm, res, callback);
        }
        for (Element tileElm : XmlUtil.getElements(elm, "tile")) {
            UiTile tile = new UiTile(this.getId());
            tile.fromXml(tileElm, res, callback);
            this.tiles.addOrInject(tile, XHelper.readString(tileElm, "@insert-before"), XHelper.readString(tileElm, "@insert-after"));
        }
        int val = XHelper.readInt(elm, "@columns", 0);
        if (val > this.columns) {
            this.columns = val;
        }
    }
}

