/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.ListWithInjections;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiLabel;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.List;
import org.w3c.dom.Element;

public class UiWidgetDataView
extends BaseUiWidget {
    private UiModel model;
    private UiLabel placeholder;
    private boolean noControls;
    private final ListWithInjections<Column> columns = new ListWithInjections<Column>(Column::getId);

    UiWidgetDataView() {
    }

    public UiModel getModel() {
        return this.model;
    }

    public UiLabel getPlaceholder() {
        return this.placeholder;
    }

    public boolean isNoControls() {
        return this.noControls;
    }

    public List<Column> getColumns() {
        return this.columns.asList();
    }

    @Override
    protected void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        Element placeholderElm;
        super.fromXml(elm, res, callback);
        Element modelElm = XmlUtil.getElement(elm, "model");
        if (modelElm != null) {
            if (this.model == null) {
                this.model = new UiModel();
            }
            this.model.fromXml(modelElm);
        }
        if ((placeholderElm = XmlUtil.getElement(elm, "placeholder")) != null) {
            this.placeholder = callback.getOrCreateLabel(placeholderElm);
        }
        this.noControls = XHelper.readBoolean(elm, "@no-controls", false);
        for (Element colElm : XmlUtil.getElements(elm, "column")) {
            Column column = new Column();
            column.fromXml(colElm, res, callback);
            this.columns.addOrInject(column, XHelper.readString(colElm, "@insert-before"), XHelper.readString(colElm, "@insert-after"));
        }
    }

    public static class Column {
        private UiAclResource acl;
        private UiLabel caption;
        private UiLabel help;
        private ColumnType type;
        private String id;
        private boolean sortable;

        Column() {
        }

        public UiAclResource getAcl() {
            return this.acl;
        }

        public UiLabel getCaption() {
            return this.caption;
        }

        public UiLabel getHelp() {
            return this.help;
        }

        public ColumnType getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public boolean isSortable() {
            return this.sortable;
        }

        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            Element helpElm;
            Element captionElm;
            this.id = XHelper.readString(elm, "@id");
            this.type = ColumnType.decode(XHelper.readString(elm, "@type"));
            Element aclElm = XmlUtil.getElement(elm, "acl");
            if (aclElm != null) {
                this.acl = new UiAclResource();
                this.acl.fromXml(aclElm, res, callback);
            }
            if ((captionElm = XmlUtil.getElement(elm, "caption")) != null) {
                this.caption = callback.getOrCreateLabel(captionElm);
            }
            if ((helpElm = XmlUtil.getElement(elm, "help")) != null) {
                this.help = callback.getOrCreateLabel(helpElm);
            }
            this.sortable = XHelper.readBoolean(elm, "@sortable", this.sortable);
        }
    }

    public static enum ColumnType {
        STRING,
        BOOLEAN,
        ACTION;


        static ColumnType decode(String str) {
            if ("string".equals(str)) {
                return STRING;
            }
            if ("boolean".equals(str)) {
                return BOOLEAN;
            }
            if ("action".equals(str)) {
                return ACTION;
            }
            throw Xeption.forDeveloper("unknown data view column type {0}", str);
        }
    }
}

