/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.Validatable;
import com.gridnine.xtrip.common.model.ValidationContext;
import com.gridnine.xtrip.common.util.InvocationContext;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class BaseEntity
extends BaseIdentity
implements XSerializable,
XSSerializable,
XCloneable,
Validatable {
    private static final long serialVersionUID = -3405263544767448405L;
    private boolean cloneUidSet;

    protected BaseEntity() {
    }

    protected BaseEntity(String aUid) {
        super(aUid);
    }

    public String toString() {
        return "{" + this.getClass().getName() + ": UID=" + this.getUid() + "}";
    }

    @Override
    public Object getValue(String memberId) {
        if ("uid".equals(memberId)) {
            return this.getUid();
        }
        throw new IllegalArgumentException("unknown memberId " + memberId);
    }

    @Override
    public void setValue(String memberId, Object value) {
        if ("uid".equals(memberId)) {
            this.setUid((String)value);
        }
        throw new IllegalArgumentException("unknown memberId " + memberId);
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        String value = XHelper.readString(elm, "uid");
        if (value == null) {
            value = XHelper.readString(elm, "@uid");
        }
        if (value == null) {
            LoggerFactory.getLogger(this.getClass()).warn("no UID found in element " + XmlUtil.getPath(elm));
        } else {
            this.setUid(value);
        }
    }

    @Override
    public void toXML(Element elm) throws Exception {
        XHelper.writeString(elm, "uid", this.getUid());
    }

    @Override
    public ValidationContext getValidationContext() {
        throw new IllegalArgumentException();
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract boolean readXMLElement(XMLStreamReader var1) throws Exception;

    @Override
    public final void toXML(XMLStreamWriter writer) throws Exception {
        this.writeXMLAttributes(writer);
        this.writeXMLElements(writer);
    }

    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString(writer, "uid", this.getUid());
    }

    protected void writeXMLAttributes(XMLStreamWriter writer) throws Exception {
    }

    public void setCloneUidSet(boolean value) {
        this.cloneUidSet = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        BaseEntity clone = this.newInstance(XCloneHelper.getNewUid(this.getUid(), newUids, uids));
        clone.cloneUidSet = true;
        boolean doExit = InvocationContext.get("entityClone").enter(clone);
        try {
            clone.copyFrom(this, newUids, uids);
            BaseEntity baseEntity = clone;
            return baseEntity;
        }
        finally {
            clone.cloneUidSet = false;
            if (doExit) {
                InvocationContext.get("entityClone").exit();
            }
        }
    }

    public void copyFrom(BaseEntity sourceEntity, boolean newUids, Map<String, String> uids) throws Exception {
        if (!this.cloneUidSet) {
            this.setUid(XCloneHelper.getNewUid(sourceEntity.getUid(), newUids, uids));
        }
    }

    public abstract BaseEntity newInstance(String var1);
}

