/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.IValueHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class IntrospectableReadOnlyValueHolder
implements IValueHolder {
    private final Introspectable delegate;
    private final String memberId;

    public IntrospectableReadOnlyValueHolder(Introspectable delegate, String memberId) {
        this.delegate = delegate;
        this.memberId = memberId;
    }

    public Object getValue() {
        return this.delegate.getValue(this.memberId);
    }

    public void setValue(Object value) throws Exception {
        Object finalValue = this.delegate.getValue(this.memberId);
        if (finalValue instanceof BaseEntity) {
            BaseEntity baseEntity = (BaseEntity)finalValue;
            baseEntity.copyFrom((BaseEntity)value, false, new HashMap<String, String>());
        } else if (finalValue instanceof Collection) {
            Collection collection = (Collection)finalValue;
            collection.clear();
            collection.addAll((Collection)value);
        } else if (finalValue instanceof Map) {
            Map map = (Map)finalValue;
            map.clear();
            map.putAll((Map)value);
        } else {
            throw Xeption.forDeveloper("unexpected final value type " + finalValue.getClass().getName(), new Object[0]);
        }
    }
}

