/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultiException
extends RuntimeException {
    private static final long serialVersionUID = -516220091107671453L;
    private volatile transient String message;
    private static final Pattern PATTERN = Pattern.compile("\n-BEGIN OF THE LIST-.*-END OF THE LIST-", 32);
    private final List<Throwable> exceptions = new ArrayList<Throwable>();

    public MultiException() {
    }

    public MultiException(Throwable t) {
        this.exceptions.add(Objects.requireNonNull(t));
    }

    public MultiException(Collection<Throwable> list) {
        this.exceptions.addAll(Objects.requireNonNull(list));
    }

    public MultiException(Throwable ... list) {
        this.exceptions.addAll(Arrays.asList(list));
    }

    @Override
    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        StringBuilder sb = new StringBuilder();
        int size = this.exceptions.size();
        if (this.exceptions.size() == 0) {
            sb.append("no errors has occurred.");
        } else {
            if (1 == size) {
                sb.append(String.format("an error has occurred %d", size));
            } else {
                sb.append(String.format("%d errors have occurred", size));
            }
            sb.append(":");
            int i = 1;
            sb.append("\n").append("-BEGIN OF THE LIST-");
            for (Throwable ex : this.exceptions) {
                sb.append("\n").append(i++).append(": ");
                try {
                    String str = TextUtil.getExceptionStackTraceRegular(ex);
                    Matcher matcher = PATTERN.matcher(str);
                    int p = 0;
                    while (matcher.find()) {
                        sb.append(str.substring(p, matcher.start()));
                        sb.append(matcher.group().replace("\n", "\n\t"));
                        p = matcher.end();
                    }
                    sb.append(str.substring(p));
                }
                catch (Throwable e) {
                    sb.append(ex.toString());
                    sb.append("\nUNABLE TO GET STACK TRACE BECAUSE AN EXCEPTION HAS OCCURRED: " + e.getMessage());
                }
            }
            sb.append("\n").append("-END OF THE LIST-");
        }
        this.message = sb.toString();
        return this.message;
    }

    public void addException(Throwable t) {
        this.exceptions.add(Objects.requireNonNull(t));
        this.message = null;
    }

    public List<Throwable> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public void addExceptions(Collection<Throwable> list) {
        this.exceptions.addAll(Objects.requireNonNull(list));
        this.message = null;
    }

    public void addExceptions(Throwable ... list) {
        this.exceptions.addAll(Arrays.asList(list));
        this.message = null;
    }
}

