/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class NestedEntityReference<Root extends BaseEntity, Nested extends BaseEntity>
extends EntityReference<Root> {
    private static final long serialVersionUID = 6301302029755759153L;
    private String nestedEntityUid;
    private Class<Nested> nestedEntityType;

    public NestedEntityReference() {
    }

    public NestedEntityReference(EntityContainer<Root> ect, Nested ett) {
        super(ect.getUid(), ect.getEntityType(), ((BaseEntity)ett).toString());
        this.nestedEntityUid = ((BaseIdentity)ett).getUid();
        this.nestedEntityType = ett.getClass();
    }

    public NestedEntityReference(EntityContainer<Root> ect, Nested ett, String ettCaption) {
        super(ect.getUid(), ect.getEntityType(), !TextUtil.isBlank(ettCaption) ? ettCaption : ((BaseEntity)ett).toString());
        this.nestedEntityUid = ((BaseIdentity)ett).getUid();
        this.nestedEntityType = ett.getClass();
    }

    public NestedEntityReference(EntityReference<Root> ref, Nested ett) {
        super(ref.getUid(), ref.getType(), ((BaseEntity)ett).toString());
        this.nestedEntityUid = ((BaseIdentity)ett).getUid();
        this.nestedEntityType = ett.getClass();
    }

    public NestedEntityReference(EntityReference<Root> ref, Nested ett, String ettCaption) {
        super(ref.getUid(), ref.getType(), !TextUtil.isBlank(ettCaption) ? ettCaption : ((BaseEntity)ett).toString());
        this.nestedEntityUid = ((BaseIdentity)ett).getUid();
        this.nestedEntityType = ett.getClass();
    }

    public NestedEntityReference(EntityReference<Root> ref, String ettUid, Class<Nested> ettClass, String ettCaption) {
        super(ref.getUid(), ref.getType(), TextUtil.isBlank(ettCaption) ? ref.getCaption() : ettCaption);
        this.nestedEntityUid = ettUid;
        this.nestedEntityType = ettClass;
    }

    public NestedEntityReference(String ectUid, Class<Root> ectClass, String ettUid, Class<Nested> ettClass, String ettCaption) {
        super(ectUid, ectClass, ettCaption);
        this.nestedEntityUid = ettUid;
        this.nestedEntityType = ettClass;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NestedEntityReference)) {
            return false;
        }
        NestedEntityReference other = (NestedEntityReference)obj;
        return this.getUid().equals(other.getUid()) && this.getType().equals(other.getType()) && this.getNestedEntityUid().equals(other.getNestedEntityUid()) && this.getNestedEntityType().equals(other.getNestedEntityType());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.nestedEntityUid == null ? 0 : this.nestedEntityUid.hashCode());
        result = 31 * result + (this.nestedEntityType == null ? 0 : this.nestedEntityType.hashCode());
        return result;
    }

    @Override
    public String toString() {
        String result = this.getCaption();
        return result != null ? result : String.format("{%s: uid=%s, %s: uid=%s}", this.getType() == null ? null : this.getType().getName(), this.getUid(), this.getNestedEntityType() == null ? null : this.getNestedEntityType().getName(), this.getNestedEntityUid());
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeString(elm, "nestedEntityUid", this.getNestedEntityUid());
        XHelper.writeString(elm, "nestedEntityType", this.getNestedEntityType().getName());
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        super.toXML(writer);
        XSHelper.writeString(writer, "nestedEntityUid", this.getNestedEntityUid());
        XSHelper.writeString(writer, "nestedEntityType", this.getNestedEntityType().getName());
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.setNestedEntityUid(XHelper.readString(elm, "nestedEntityUid"));
        this.setNestedEntityType(XHelper.getClass(XHelper.readString(elm, "nestedEntityType")));
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("nestedEntityUid".equals(tagName)) {
            this.setNestedEntityUid(XSHelper.readString(reader));
            return true;
        }
        if ("nestedEntityType".equals(tagName)) {
            this.setNestedEntityType(XSHelper.getClass(XSHelper.readString(reader)));
            return true;
        }
        return super.readXMLElement(reader);
    }

    public String getNestedEntityUid() {
        return this.nestedEntityUid;
    }

    public void setNestedEntityUid(String value) {
        this.nestedEntityUid = value;
    }

    public Class<Nested> getNestedEntityType() {
        return this.nestedEntityType;
    }

    public void setNestedEntityType(Class<Nested> value) {
        this.nestedEntityType = value;
    }

    @Override
    protected void copyFrom(EntityReference sourceEntityReference, boolean newUids, Map<String, String> uids) throws Exception {
        super.copyFrom(sourceEntityReference, newUids, uids);
        NestedEntityReference source = (NestedEntityReference)sourceEntityReference;
        this.nestedEntityUid = uids.containsKey(source.nestedEntityUid) ? uids.get(source.nestedEntityUid) : source.nestedEntityUid;
        this.nestedEntityType = source.nestedEntityType;
    }
}

