/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.PeriodicalValue;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.LoggerFactory;

public final class PeriodicalPropertySHelper {
    public static void writePeriodicalString(final XMLStreamWriter writer, String name, List<PeriodicalValue<String>> values, final boolean asCdata) throws Exception {
        PeriodicalPropertySHelper.writePeriodicalProperty(writer, name, values, new WriteCallback<String>(){

            @Override
            public void setValue(XMLStreamWriter w, String value) throws Exception {
                if (asCdata) {
                    writer.writeCData(value);
                } else {
                    writer.writeCharacters(value);
                }
            }
        });
    }

    public static <T extends XSSerializable> void writePeriodicalProperty(final XMLStreamWriter writer, String name, List<PeriodicalValue<T>> values) throws Exception {
        PeriodicalPropertySHelper.writePeriodicalProperty(writer, name, values, new WriteCallback<T>(){

            @Override
            public void setValue(XMLStreamWriter w, T value) throws Exception {
                try {
                    writer.writeAttribute("class", value.getClass().getName());
                    value.toXML(writer);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(PeriodicalPropertySHelper.class).warn(String.format("failed serializing value %s", value));
                }
            }
        });
    }

    private static <T> void writePeriodicalProperty(XMLStreamWriter writer, String name, List<PeriodicalValue<T>> values, WriteCallback<T> callback) throws Exception {
        if (values.isEmpty()) {
            return;
        }
        writer.writeStartElement(name);
        for (PeriodicalValue<T> value : values) {
            if (value.getValue() == null) continue;
            writer.writeStartElement("item");
            writer.writeAttribute("uid", value.getUid());
            writer.writeStartElement("value");
            callback.setValue(writer, value.getValue());
            writer.writeEndElement();
            XSHelper.writeDate(writer, "beginDate", value.getBeginDate());
            XSHelper.writeDate(writer, "endDate", value.getEndDate());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private PeriodicalPropertySHelper() {
    }

    public static interface WriteCallback<T> {
        public void setValue(XMLStreamWriter var1, T var2) throws Exception;
    }
}

