/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import java.util.Objects;

public class Xeption
extends RuntimeException {
    private static final long serialVersionUID = 8725983001691717660L;
    private final L10nMessage endUserMessage;
    private final L10nMessage adminMessage;

    public static Xeption forDeveloper(String message, Object ... parameters) {
        return new Xeption(null, null, L10nResourcesManager.replace(message, parameters), null);
    }

    public static Xeption forDeveloper(String message, Throwable cause, Object ... parameters) {
        return new Xeption(null, null, L10nResourcesManager.replace(message, parameters), cause);
    }

    public static Xeption forEndUser(String message, Object ... parameters) {
        return new Xeption(L10nResourcesManager.createL10nMessage(message, parameters), null, null, null);
    }

    public static Xeption forEndUser(String message, Throwable cause, Object ... parameters) {
        return new Xeption(L10nResourcesManager.createL10nMessage(message, parameters), null, null, cause);
    }

    public static Xeption forAdmin(String message, Object ... parameters) {
        return new Xeption(null, L10nResourcesManager.createL10nMessage(message, parameters), null, null);
    }

    public static Xeption forAdmin(String message, Throwable cause, Object ... parameters) {
        return new Xeption(null, L10nResourcesManager.createL10nMessage(message, parameters), null, cause);
    }

    public Xeption(L10nMessage userMessage, L10nMessage admMessage, String message, Throwable cause) {
        super(message, cause);
        this.endUserMessage = userMessage;
        this.adminMessage = admMessage;
    }

    public L10nMessage getEndUserMessage() {
        return this.endUserMessage;
    }

    public L10nMessage getAdminMessage() {
        return this.adminMessage;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getMessage() != null) {
            sb.append("developer: ").append(this.getMessage());
        }
        if (this.adminMessage != null) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("admin: ").append(this.adminMessage);
        }
        if (this.endUserMessage != null) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("user: ").append(this.endUserMessage);
        }
        return sb.toString();
    }

    public String toMessageString() {
        String message = this.getMessage();
        if (Objects.nonNull(message)) {
            return message;
        }
        if (Objects.nonNull(this.adminMessage)) {
            return this.adminMessage.toString();
        }
        if (Objects.nonNull(this.endUserMessage)) {
            return this.endUserMessage.toString();
        }
        return "";
    }
}

