/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.asset;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import java.util.List;

public abstract class AssetsStorage {
    public static AssetsStorage get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return Environment.getPublished(AssetsStorage.class);
    }

    public abstract <A extends BaseAsset> SearchResult<A> search(Class<A> var1, SearchQuery var2) throws StorageException;

    public abstract <A extends BaseAsset> SearchResult<A> search(Class<A> var1, SearchQuery var2, boolean var3) throws StorageException;

    public abstract <A extends BaseAsset> ProjectionResult search(Class<A> var1, ProjectionQuery var2) throws StorageException;

    public abstract <A extends BaseAsset> ProjectionResult search(Class<A> var1, ProjectionQuery var2, boolean var3) throws StorageException;

    public abstract <A extends BaseAsset> A save(A var1) throws StorageException;

    public abstract <A extends BaseAsset> A save(A var1, boolean var2) throws StorageException;

    public abstract <A extends BaseAsset> List<A> save(Iterable<A> var1) throws StorageException;

    public abstract <A extends BaseAsset> A load(Class<A> var1, String var2) throws StorageException;

    public abstract <A extends BaseAsset> A load(Class<A> var1, String var2, boolean var3) throws StorageException;

    public abstract <A extends BaseAsset> A find(Class<A> var1, String var2, Object var3) throws StorageException;

    public abstract <A extends BaseAsset> A find(Class<A> var1, String var2, Object var3, boolean var4) throws StorageException;

    public abstract <A extends BaseAsset> List<A> save(Iterable<A> var1, boolean var2) throws StorageException;

    public abstract <A extends BaseAsset> void delete(A var1) throws StorageException;

    public abstract <A extends BaseAsset> void delete(A var1, boolean var2) throws StorageException;

    private static class Holder {
        public static final AssetsStorage INSTANCE = Environment.getPublished(AssetsStorage.class);

        private Holder() {
        }
    }
}

