/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.advanced;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.gridnine.xtrip.common.model.cache.advanced.GroupsHandlerManager;
import com.gridnine.xtrip.common.model.cache.common.CacheHelper;
import com.gridnine.xtrip.common.model.cache.common.GroupsBuilder;
import com.gridnine.xtrip.common.model.cache.common.ResolveCache;
import com.gridnine.xtrip.common.search.StorageQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryCache<I> {
    private static final Logger log = LoggerFactory.getLogger(SearchQueryCache.class);
    private static final boolean DEBUG = true;
    private final Cache<Class<I>, ResolveCache<DataInfo>> data;
    private static final String PROPERTY_KEY = "com.gridnine.xtrip.server.search-query-cache";
    private static final long DEFAULT_DURATION = 30L;
    private static final TimeUnit DEFAULT_UNIT = TimeUnit.MINUTES;

    public SearchQueryCache() {
        String spec = System.getProperty(PROPERTY_KEY);
        this.data = (spec != null ? CacheBuilder.from((String)spec) : CacheBuilder.newBuilder().softValues().expireAfterAccess(30L, DEFAULT_UNIT)).recordStats().build();
    }

    public Object getValue(Class<I> cls, StorageQuery query) {
        ResolveCache indexCache = (ResolveCache)this.data.getIfPresent(cls);
        if (indexCache == null) {
            return null;
        }
        DataInfo info = (DataInfo)indexCache.get(CacheHelper.toKey(query));
        return info != null ? info.getResult() : null;
    }

    public void putValue(Class<I> cls, StorageQuery query, Object result) {
        Collection<String> groups;
        ResolveCache indexCache;
        try {
            indexCache = (ResolveCache)this.data.get(cls, () -> new ResolveCache(PROPERTY_KEY, 30L, DEFAULT_UNIT));
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
        boolean isCachedByGroups = GroupsHandlerManager.isCachedByGroups(cls);
        String key = CacheHelper.toKey(query);
        Collection<String> collection = groups = isCachedByGroups ? GroupsHandlerManager.getQueryGroups(query) : null;
        if (log.isDebugEnabled()) {
            log.debug(String.format("put value into cache class=%s, groups=%s", cls.getName(), groups != null ? Arrays.toString(groups.toArray(new String[groups.size()])) : "null"));
        }
        indexCache.putValue(key, new DataInfo(result, groups, query));
    }

    public void invalidate(Class<I> indexClass, String[] groups) {
        if (!GroupsHandlerManager.isCachedByGroups(indexClass)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("invalidate all values into cache (groups not support) class=%s, groups=%s", indexClass.getName(), groups != null ? Arrays.toString(groups) : "null"));
            }
            this.data.invalidate(indexClass);
            return;
        }
        if (groups == null || groups.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("invalidate all values into cache class=%s, groups=%s", indexClass.getName(), groups != null ? Arrays.toString(groups) : "null"));
            }
            this.data.invalidate(indexClass);
            return;
        }
        ResolveCache resolveCache = (ResolveCache)this.data.getIfPresent(indexClass);
        if (resolveCache == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("skip invalidate values into cache (cache is empty) class=%s, groups=%s", indexClass.getName(), Arrays.toString(groups)));
            }
            return;
        }
        int affected = 0;
        Map<String, Collection<String>> groupMap = this.getGroupMap(Arrays.asList(groups));
        for (Map.Entry entry : new ArrayList(resolveCache.getData().entrySet())) {
            Map<String, Collection<String>> cachedAndGroupMap;
            DataInfo info = (DataInfo)entry.getValue();
            boolean removeIt = info.getGroups().isEmpty();
            if (!removeIt) {
                Map<String, Collection<String>> cachedOrGroupMap = this.getOrGroupMap(info.getGroups());
                block1: for (Map.Entry<String, Collection<String>> entry2 : cachedOrGroupMap.entrySet()) {
                    Collection<String> objectValues = groupMap.get(entry2.getKey());
                    if (objectValues == null) {
                        removeIt = true;
                        break;
                    }
                    for (String value : entry2.getValue()) {
                        for (String objectValue : objectValues) {
                            if (!this.compareValues(objectValue, value)) continue;
                            removeIt = true;
                            break block1;
                        }
                    }
                }
            }
            if (!removeIt && (cachedAndGroupMap = this.getAndGroupMap(info.getGroups())).size() > 0) {
                boolean ignoreIt = false;
                for (Map.Entry<String, Collection<String>> entry2 : cachedAndGroupMap.entrySet()) {
                    Collection<String> objectValues = groupMap.get(entry2.getKey());
                    if (objectValues == null) {
                        removeIt = true;
                        break;
                    }
                    boolean equals = false;
                    block5: for (String value : entry2.getValue()) {
                        for (String objectValue : objectValues) {
                            if (!this.compareValues(objectValue, value)) continue;
                            equals = true;
                            break block5;
                        }
                    }
                    if (equals) continue;
                    ignoreIt = true;
                    break;
                }
                if (!ignoreIt) {
                    removeIt = true;
                }
            }
            if (!removeIt) continue;
            resolveCache.remove(entry.getKey());
            ++affected;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("invalidate some values into cache affected=%d, class=%s, groups=%s", affected, indexClass.getName(), Arrays.toString(groups)));
        }
    }

    private boolean compareValues(String objectValue, String valueWithOperation) {
        GroupsBuilder.Operation operation = Arrays.stream(GroupsBuilder.Operation.values()).filter(o -> valueWithOperation.startsWith(o.getText())).findFirst().orElse(null);
        if (null == operation) {
            return false;
        }
        String value = valueWithOperation.substring(operation.getText().length());
        switch (operation) {
            case EQ: {
                return Objects.equals(objectValue, value);
            }
            case NE: {
                return !Objects.equals(objectValue, value);
            }
            case GT: {
                return !"null".equals(objectValue) && !"null".equals(value) && objectValue.compareTo(value) > 0;
            }
            case GE: {
                return !"null".equals(objectValue) && !"null".equals(value) && objectValue.compareTo(value) >= 0;
            }
            case LT: {
                return !"null".equals(objectValue) && !"null".equals(value) && objectValue.compareTo(value) < 0;
            }
            case LE: {
                return !"null".equals(objectValue) && !"null".equals(value) && objectValue.compareTo(value) <= 0;
            }
        }
        throw new UnsupportedOperationException(operation.name());
    }

    private Map<String, Collection<String>> getGroupMap(Iterable<String> groups) {
        if (groups == null) {
            return null;
        }
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (String group : groups) {
            String value;
            String key;
            int p = group.indexOf(61);
            if (p == -1) {
                key = group;
                value = "";
            } else {
                key = group.substring(0, p);
                value = group.substring(p + 1);
            }
            Collection values = result.computeIfAbsent(key, k -> new ArrayList());
            values.add(value);
        }
        return result;
    }

    private Map<String, Collection<String>> getAndGroupMap(Iterable<String> groups) {
        if (groups == null) {
            return null;
        }
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (String group : groups) {
            String value;
            String key;
            if (group.startsWith("|")) continue;
            int p = Arrays.stream(GroupsBuilder.Operation.values()).map(o -> group.indexOf(o.getText())).filter(i -> i >= 0).findFirst().orElse(-1);
            if (p == -1) {
                key = group.startsWith("&") ? group.substring(1) : group;
                value = "(unsupported)";
            } else {
                key = group.substring(group.startsWith("&") ? 1 : 0, p);
                value = group.substring(p);
            }
            Collection values = result.computeIfAbsent(key, k -> new ArrayList());
            values.add(value);
        }
        return result;
    }

    private Map<String, Collection<String>> getOrGroupMap(Iterable<String> groups) {
        if (groups == null) {
            return null;
        }
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (String group : groups) {
            String value;
            String key;
            if (!group.startsWith("|")) continue;
            int p = Arrays.stream(GroupsBuilder.Operation.values()).map(o -> group.indexOf(o.getText())).filter(i -> i >= 0).findFirst().orElse(-1);
            if (p == -1) {
                key = group.substring(1);
                value = "(unsupported)";
            } else {
                key = group.substring(1, p);
                value = group.substring(p);
            }
            Collection values = result.computeIfAbsent(key, k -> new ArrayList());
            values.add(value);
        }
        return result;
    }

    public void invalidateAll() {
        this.data.invalidateAll();
    }

    public void maintenance() {
        this.data.cleanUp();
        for (ResolveCache entry : new ArrayList(this.data.asMap().values())) {
            entry.maintenance();
        }
    }

    public CacheStats getStats() {
        return this.data.stats();
    }

    private static class DataInfo {
        private final Object result;
        private final Collection<String> groups;

        public DataInfo(Object result, Collection<String> groups, StorageQuery query) {
            this.result = result;
            this.groups = groups;
        }

        public Object getResult() {
            return this.result;
        }

        public Collection<String> getGroups() {
            return this.groups;
        }
    }
}

