/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.asset;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.cache.common.CacheHelper;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.model.cache.common.ObjectsCache;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import java.util.Collection;

public class AssetsCacheData {
    private final AssetsCache assetsCache = new AssetsCache();
    private final SimpleSearchCache simpleSearchCache = new SimpleSearchCache();
    private final SearchQueryCache searchQueryCache = new SearchQueryCache();

    AssetsCache getAssetsCache() {
        return this.assetsCache;
    }

    SimpleSearchCache getSimpleSearchCache() {
        return this.simpleSearchCache;
    }

    SearchQueryCache getSearchQueryCache() {
        return this.searchQueryCache;
    }

    void reset() {
        this.assetsCache.invalidateAll();
        this.simpleSearchCache.invalidateAll();
        this.searchQueryCache.invalidateAll();
    }

    void invalidate(Collection<ModificationData<AssetReference<?>>> refs) {
        for (ModificationData<AssetReference<?>> data : refs) {
            AssetReference<?> item = data.getItem();
            this.assetsCache.invalidate(item);
            this.simpleSearchCache.invalidate(item);
            this.searchQueryCache.invalidate(item.getType(), data.getGroups());
        }
    }

    static class AssetsCache
    extends ObjectsCache<BaseAsset, BaseAsset> {
        AssetsCache() {
        }

        <A extends BaseAsset> A get(Class<A> cls, String uid) {
            return (A)((BaseAsset)super.getObject(cls, uid));
        }

        <A extends BaseAsset> void put(Class<A> cls, String uid, A asset) {
            super.putObject(cls, uid, asset);
        }

        <A extends BaseAsset> void invalidate(AssetReference<A> ref) {
            super.invalidateObject(ref.getType(), ref.getUid());
        }
    }

    static class SimpleSearchCache
    extends com.gridnine.xtrip.common.model.cache.common.SimpleSearchCache<BaseAsset, AssetReference<BaseAsset>> {
        SimpleSearchCache() {
            super(CacheHelper.NULL_ASSET_REFERENCE);
        }

        <A extends BaseAsset> AssetReference<A> get(Class<A> cls, String fieldName, Object value) {
            return (AssetReference)super.getReference(cls, fieldName, value);
        }

        <A extends BaseAsset> boolean contains(Class<A> cls, String fieldName, Object value) {
            return super.containsValue(cls, fieldName, value);
        }

        <A extends BaseAsset> void put(Class<A> cls, String fieldName, Object value, AssetReference<A> ref) {
            super.putReference(cls, fieldName, value, ref);
        }

        <A extends BaseAsset> void invalidate(Class<A> cls, String fieldName, Object value) {
            super.invalidateByValue(cls, fieldName, value);
        }

        <A extends BaseAsset> void invalidate(AssetReference<A> ref) {
            super.invalidateByReference(ref.getType(), ref);
        }
    }

    static class SearchQueryCache
    extends com.gridnine.xtrip.common.model.cache.advanced.SearchQueryCache<BaseAsset> {
        SearchQueryCache() {
        }

        <A extends BaseAsset> SearchResult<A> get(Class<A> cls, SearchQuery query) {
            return (SearchResult)super.getValue(cls, query);
        }

        <A extends BaseAsset> void put(Class<A> cls, SearchQuery query, SearchResult<A> result) {
            super.putValue(cls, query, result);
        }

        <A extends BaseAsset> ProjectionResult get(Class<A> cls, ProjectionQuery query) {
            return (ProjectionResult)super.getValue(cls, query);
        }

        <A extends BaseAsset> void put(Class<A> cls, ProjectionQuery query, ProjectionResult result) {
            super.putValue(cls, query, result);
        }
    }
}

