/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.common;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.cache.common.ReferenceActualizationResult;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.MultiString;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;

public final class CacheHelper {
    public static final String NULL_REFERENCE_CAPTION = "7821111802610283508L";
    public static final EntityContainer<FakeEntity> NULL_CONTAINER = new EntityContainer<FakeEntity>(FakeEntity.class);
    public static final EntityReference<FakeEntity> NULL_REFERENCE = NULL_CONTAINER.toReference();
    public static final String NULL_UID = "100841239008651406L";
    public static final FakeAsset NULL_ASSET = new FakeAsset();
    public static final AssetReference<FakeAsset> NULL_ASSET_REFERENCE = NULL_ASSET.toReference();
    private static final ConcurrentHashMap<String, Lock> locks = new ConcurrentHashMap();

    public static void profileCacheOperation(MultiString key, long startTime) {
        if (!Environment.isPublished(Profiler.class)) {
            return;
        }
        Profiler monitoringData = Profiler.get();
        if (monitoringData.isProfilingEnabled(key)) {
            monitoringData.updateTiming(key.join(), startTime, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static <T> T doActionWithLock(DoActionCallback<T> callback, boolean ignoreCache, String operationKey, String lockKey) {
        boolean useActualStorage;
        if (lockKey == null) {
            return CacheHelper.doAction(callback, ignoreCache, operationKey);
        }
        if (callback.isDisposed()) {
            callback.getLog().warn("storage is disposed");
            return null;
        }
        MultiString fullKey = new MultiString(true, ".", callback.getProfilingPrefix(), operationKey);
        boolean callbackLogDebugEnabled = callback.getLog().isDebugEnabled();
        if (callbackLogDebugEnabled) {
            callback.getLog().debug("performing operation {}, ignoreCache = {}", (Object)fullKey.join(), (Object)ignoreCache);
        }
        boolean cached = callback.isCached();
        boolean bl = useActualStorage = ignoreCache || !cached;
        if (useActualStorage) {
            return CacheHelper.doWithActualStorage(callback, fullKey, operationKey, cached);
        }
        try {
            if (callbackLogDebugEnabled) {
                callback.getLog().debug("performing operation with local storage");
            }
            long startTime = System.currentTimeMillis();
            T result = callback.doWithLocalStorage();
            if (result != null) {
                CacheHelper.profileCacheOperation(new MultiString(true, ".", callback.getProfilingPrefix(), operationKey, "local"), startTime);
                if (callbackLogDebugEnabled) {
                    callback.getLog().debug("got result {}", (Object)CacheHelper.toString(result));
                }
                return result;
            }
            boolean lockOwner = false;
            Lock lock = locks.get(lockKey);
            if (lock == null) {
                ReentrantReadWriteLock.WriteLock newLock = new ReentrantReadWriteLock().writeLock();
                Lock oldLock = locks.putIfAbsent(lockKey, newLock);
                if (oldLock != null && oldLock != newLock) {
                    lock = oldLock;
                } else {
                    lock = newLock;
                    lockOwner = true;
                }
            }
            try {
                T t;
                lock.lock();
                try {
                    t = lockOwner ? CacheHelper.doWithActualStorage(callback, fullKey, operationKey, cached) : CacheHelper.doAction(callback, ignoreCache, operationKey);
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
                return t;
            }
            finally {
                if (lockOwner) {
                    locks.remove(lockKey);
                }
            }
        }
        catch (Throwable e) {
            callback.getLog().error("unable to perform operation {}", (Object)fullKey, (Object)e);
            throw new StorageException("An error has occurred while connecting to database", e);
        }
    }

    public static void profileCacheOperation(String key, long startTime) {
        if (!Environment.isPublished(Profiler.class)) {
            return;
        }
        Profiler monitoringData = Profiler.get();
        if (monitoringData.isProfilingEnabled(key)) {
            monitoringData.updateTiming(key, startTime, null);
        }
    }

    public static String toKey(StorageQuery query) {
        try {
            return XSUtil.toString(query);
        }
        catch (Exception e) {
            throw new IllegalStateException("bad query", e);
        }
    }

    public static <T> T doAction(DoActionCallback<T> callback, boolean ignoreCache, String operationKey) {
        boolean useActualSrorage;
        if (callback.isDisposed()) {
            callback.getLog().warn("storage is disposed");
            return null;
        }
        MultiString fullKey = new MultiString(true, ".", callback.getProfilingPrefix(), operationKey);
        boolean callbackLogDebugEnabled = callback.getLog().isDebugEnabled();
        if (callbackLogDebugEnabled) {
            callback.getLog().debug("performing operation {}, ignoreCache = {}", (Object)fullKey.join(), (Object)ignoreCache);
        }
        boolean cached = callback.isCached();
        boolean bl = useActualSrorage = ignoreCache || !cached;
        if (useActualSrorage) {
            return CacheHelper.doWithActualStorage(callback, fullKey, operationKey, cached);
        }
        try {
            callback.getLog().debug("performing operation with local storage");
            long startTime = System.currentTimeMillis();
            T result = callback.doWithLocalStorage();
            if (result != null) {
                CacheHelper.profileCacheOperation(new MultiString(true, ".", callback.getProfilingPrefix(), operationKey, "local"), startTime);
                if (callbackLogDebugEnabled) {
                    callback.getLog().debug("got result {}", (Object)CacheHelper.toString(result));
                }
                return result;
            }
            return CacheHelper.doWithActualStorage(callback, fullKey, operationKey, cached);
        }
        catch (Throwable e) {
            callback.getLog().error("unable to perform operation {}", (Object)fullKey.join(), (Object)e);
            throw new StorageException("An error has occurred while connecting to database", e);
        }
    }

    private static <T> T doWithActualStorage(DoActionCallback<T> callback, MultiString fullKey, String operationKey, boolean cached) {
        if (callback.getLog().isDebugEnabled()) {
            callback.getLog().debug("actual storage is used");
        }
        try {
            long startTime = System.currentTimeMillis();
            T result = callback.doWithActualStorage();
            if (cached) {
                callback.updateTimeStamp(new Date());
                if (callback.getWriteLog().isDebugEnabled()) {
                    callback.getWriteLog().debug("updating local storage with {}", (Object)CacheHelper.toString(result));
                }
                callback.updateLocalStorage(result);
            }
            if (callback.getLog().isDebugEnabled()) {
                callback.getLog().debug("got result {}", (Object)CacheHelper.toString(result));
            }
            CacheHelper.profileCacheOperation(new MultiString(".", callback.getProfilingPrefix(), operationKey, "actual"), startTime);
            return result;
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Throwable e) {
            callback.getLog().error("unable to perform operation {}", (Object)fullKey.join(), (Object)e);
            throw new StorageException("An error has occurred while connecting to database", e);
        }
    }

    static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof EntityContainer) {
            EntityContainer ctr = (EntityContainer)obj;
            return String.format("%s(%s): %s", MiscUtil.getSimpleClassName(ctr.getEntityType()), ctr.getUid(), ((BaseEntity)ctr.getEntity()).toString());
        }
        if (obj instanceof ReferenceActualizationResult) {
            ReferenceActualizationResult ctr = (ReferenceActualizationResult)obj;
            return String.format("ReferenceActualizationResult: %s, %s", ctr.getReference(), ctr.getTimestamp());
        }
        return obj.toString();
    }

    private CacheHelper() {
    }

    public static interface DoActionCallback<T> {
        public T doWithActualStorage() throws Throwable;

        public T doWithLocalStorage() throws Throwable;

        public void updateLocalStorage(T var1) throws Throwable;

        public boolean isCached();

        public Logger getLog();

        public Logger getWriteLog();

        public boolean isDisposed();

        public String getProfilingPrefix();

        public void updateTimeStamp(Date var1);
    }

    public static class FakeEntity
    extends BaseEntity {
        private static final long serialVersionUID = -7065474011296334534L;

        public FakeEntity() {
            super(CacheHelper.NULL_UID);
        }

        public FakeEntity(String uid) {
            super(uid);
        }

        @Override
        protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
            return false;
        }

        @Override
        public void copyFrom(BaseEntity sourceEntity, boolean newUids, Map<String, String> uids) throws Exception {
            super.copyFrom(sourceEntity, newUids, uids);
        }

        @Override
        public BaseEntity newInstance(String uid) {
            return new FakeEntity(uid);
        }
    }

    public static class FakeAsset
    extends BaseAsset {
        private static final long serialVersionUID = -9034848010028405582L;

        public FakeAsset() {
            super(CacheHelper.NULL_UID);
        }

        AssetReference<FakeAsset> toReference() {
            return new AssetReference<FakeAsset>(CacheHelper.NULL_UID, FakeAsset.class, "fake");
        }

        @Override
        protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
            return false;
        }

        @Override
        protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        }

        @Override
        protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        }
    }
}

