/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.common;

import com.gridnine.xtrip.common.model.cache.common.CacheDataModification;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModificationProvider;
import com.gridnine.xtrip.common.model.cache.common.CacheHelper;
import com.gridnine.xtrip.common.model.cache.common.CacheState;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import java.util.Collection;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUpdater<A extends XSerializable & XSSerializable> {
    final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Timer timer;
    private final CacheDataModificationProvider<A> provider;
    final CacheState state;
    final CacheUpdaterCallback<A> callback;
    private volatile boolean disposed;
    private final Collection<String> classes;
    private final String key;

    public CacheUpdater(CacheDataModificationProvider<A> dataProvider, CacheState cacheState, Collection<String> checkClassNames, CacheUpdaterCallback<A> updaterCallback, int updatePeriodInSeconds, String checkThreadName, String checkProfilingKey) {
        this.provider = dataProvider;
        this.state = cacheState;
        this.callback = updaterCallback;
        this.classes = checkClassNames;
        this.key = checkProfilingKey;
        if (updatePeriodInSeconds <= 0) {
            this.log.info("delay is 0, timer was not started");
            this.timer = null;
            return;
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    CacheUpdater.this.check();
                }
                catch (Throwable e) {
                    CacheUpdater.this.log.error("failed updating entity cache", e);
                }
            }
        };
        this.timer = new Timer(checkThreadName, true);
        this.timer.schedule(task, 1000L, 1000L * (long)updatePeriodInSeconds);
        this.log.debug("timer scheduled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void check() throws Exception {
        this.log.debug("started check");
        if (this.disposed) {
            this.log.warn("cache is disposed");
            return;
        }
        Date currentDate = new Date();
        CacheUpdater cacheUpdater = this;
        synchronized (cacheUpdater) {
            try {
                if (this.state.getTimeStamp() == null) {
                    this.log.debug("nothing to actualize");
                    return;
                }
                if (currentDate.before(this.state.getTimeStamp())) {
                    this.log.debug(String.format("current check timestamp %s is greater than request date %s", this.state.getTimeStamp(), currentDate));
                    return;
                }
                long startTime = System.currentTimeMillis();
                this.update();
                CacheHelper.profileCacheOperation(this.key, startTime);
                this.log.debug(String.format("check finished, timing: %s ms", Long.toString(System.currentTimeMillis() - startTime)));
            }
            finally {
                this.notify();
            }
            return;
        }
    }

    void update() throws Exception {
        CacheDataModification<A> modificatons = this.provider.getModifications(this.state.getTimeStamp(), this.classes);
        if (modificatons.getTimeStamp() == null) {
            this.state.setTimeStamp(null);
            this.callback.reset();
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("got %s references to invalidate: %s", Integer.toString(modificatons.getUpdatedReferences().keySet().size()), modificatons.getUpdatedReferences().keySet()));
        }
        if (modificatons.getUpdatedReferences().size() > 0) {
            this.callback.invalidate(modificatons.getUpdatedReferences().keySet());
        }
        this.state.setTimeStamp(modificatons.getTimeStamp());
    }

    public void dispose() {
        this.disposed = true;
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.log.info("disposed");
    }

    public static interface CacheUpdaterCallback<A extends XSerializable & XSSerializable> {
        public void reset();

        public void invalidate(Collection<ModificationData<A>> var1);
    }
}

