/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ResolveCache<T> {
    private final Cache<String, T> data;

    public ResolveCache(String property, long duration, TimeUnit unit) {
        String spec = System.getProperty(property);
        this.data = (spec != null ? CacheBuilder.from((String)spec) : CacheBuilder.newBuilder().softValues().expireAfterAccess(duration, unit)).build();
    }

    public void putValue(String key, T value) {
        this.data.put((Object)key, value);
    }

    public T get(String key) {
        return (T)this.data.getIfPresent((Object)key);
    }

    public void remove(String key) {
        this.data.invalidate((Object)key);
    }

    public void clear() {
        this.data.invalidateAll();
    }

    public void maintenance() {
        this.data.cleanUp();
    }

    public Map<String, T> getData() {
        return Collections.unmodifiableMap(this.data.asMap());
    }
}

