/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.entity.advanced;

import com.google.common.cache.CacheStats;
import com.gridnine.xtrip.common.jmx.AbstractAnnotatedJmxBean;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECData;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AdvancedCachedEntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Optional;
import java.util.function.Function;
import org.weakref.jmx.Managed;

public abstract class AbstractAdvancedCachedEntityStorageCacheStatsJmxBean
extends AbstractAnnotatedJmxBean {
    private static final String DEFAULT_APP_NAME = "Midoffice";
    private final String appName;
    private AdvancedCachedEntityStorage aces;

    public AbstractAdvancedCachedEntityStorageCacheStatsJmxBean() {
        this.appName = DEFAULT_APP_NAME;
    }

    public AbstractAdvancedCachedEntityStorageCacheStatsJmxBean(String name) {
        this.appName = !TextUtil.isBlank(name) ? name : DEFAULT_APP_NAME;
    }

    @Override
    protected boolean doRegister() {
        this.initAdvancedCachedEntityStorage();
        return this.aces != null;
    }

    private void initAdvancedCachedEntityStorage() {
        this.findAdvancedCachedEntityStorage(EntityStorage.get());
    }

    private void findAdvancedCachedEntityStorage(EntityStorage es) {
        if (es instanceof AdvancedCachedEntityStorage) {
            this.aces = (AdvancedCachedEntityStorage)es;
            return;
        }
        if (es instanceof IrrelevanceTolerantEntityStorage) {
            IrrelevanceTolerantEntityStorage ites = (IrrelevanceTolerantEntityStorage)es;
            this.findAdvancedCachedEntityStorage(ites.getDelegateStorage());
            return;
        }
    }

    @Override
    protected String getOname() {
        return this.appName + ":00=AdvancedCachedEntityStorage,name=" + this.getName();
    }

    protected abstract String getName();

    protected abstract Function<AECData, CacheStats> getCacheStatsFunction();

    protected <T> T getValue(Function<CacheStats, T> valueFunction) {
        return Optional.of(this.aces.data).map(this.getCacheStatsFunction()).map(valueFunction).get();
    }

    @Managed
    public long getRequestCount() {
        return this.getValue(CacheStats::requestCount);
    }

    @Managed
    public long getHitCount() {
        return this.getValue(CacheStats::hitCount);
    }

    @Managed
    public double getHitRate() {
        return this.getValue(CacheStats::hitRate);
    }

    @Managed
    public long getMissCount() {
        return this.getValue(CacheStats::missCount);
    }

    @Managed
    public double getMissRate() {
        return this.getValue(CacheStats::missRate);
    }

    @Managed
    public long getLoadCount() {
        return this.getValue(CacheStats::loadCount);
    }

    @Managed
    public long getLoadSuccessCount() {
        return this.getValue(CacheStats::loadSuccessCount);
    }

    @Managed
    public long getLoadExceptionCount() {
        return this.getValue(CacheStats::loadExceptionCount);
    }

    @Managed
    public double getLoadExceptionRate() {
        return this.getValue(CacheStats::loadExceptionRate);
    }

    @Managed
    public long getTotalLoadTime() {
        return this.getValue(CacheStats::totalLoadTime);
    }

    @Managed
    public double getAverageLoadPenalty() {
        return this.getValue(CacheStats::averageLoadPenalty);
    }

    @Managed
    public long getEvictionCount() {
        return this.getValue(CacheStats::evictionCount);
    }
}

