/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.dict;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public abstract class BaseLegalForm
extends BaseDictionary {
    private static final long serialVersionUID = 7909541554815869209L;
    private final Map<Locale, String> abbreviations = new HashMap<Locale, String>();

    public BaseLegalForm() {
    }

    public Map<Locale, String> getAbbreviations() {
        return this.abbreviations;
    }

    @Override
    public String toString(Locale locale) {
        String result = MiscUtil.findByLocale(this.abbreviations, locale);
        if (TextUtil.isBlank(result) && !MiscUtil.equals(locale, Locale.ENGLISH)) {
            result = MiscUtil.findByLocale(this.abbreviations, Locale.ENGLISH);
        }
        return !TextUtil.isBlank(result) ? result : super.toString(locale);
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.abbreviations.clear();
        for (Element itemElm : XmlUtil.getElements(elm, "abbreviations/item")) {
            this.abbreviations.put(TextUtil.str2locale(itemElm.getAttribute("lang")), XmlUtil.getValue(itemElm));
        }
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("abbreviations".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    this.abbreviations.put(TextUtil.str2locale(reader.getAttributeValue(null, "lang")), XSHelper.readString(reader));
                    continue;
                }
                XSHelper.skipElement(reader);
            }
            return true;
        }
        return super.readXMLElement(reader);
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        for (Map.Entry<Locale, String> entry : this.abbreviations.entrySet()) {
            Element itemElm = XmlUtil.addElement(elm, "abbreviations/item");
            itemElm.setAttribute("lang", entry.getKey().toString());
            XmlUtil.setValue(itemElm, entry.getValue());
        }
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        super.writeXMLElements(writer);
        if (!this.abbreviations.isEmpty()) {
            writer.writeStartElement("abbreviations");
            for (Map.Entry<Locale, String> entry : this.abbreviations.entrySet()) {
                XSHelper.writeString(writer, "item", entry.getValue(), Collections.singletonMap("lang", entry.getKey().toString()));
            }
            writer.writeEndElement();
        }
    }

    @Override
    public void copyFrom(BaseEntity sourceEntity, boolean newUids, Map<String, String> uids) throws Exception {
        super.copyFrom(sourceEntity, newUids, uids);
        BaseLegalForm source = (BaseLegalForm)sourceEntity;
        this.abbreviations.clear();
        this.abbreviations.putAll(source.abbreviations);
    }

    @Override
    public Object getValue(String memberId) {
        switch (memberId) {
            case "abbreviations": {
                return this.abbreviations;
            }
        }
        return super.getValue(memberId);
    }

    public BaseLegalForm(String uid) {
        super(uid);
    }

    public static enum Property {
        abbreviations;

    }
}

