/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EntityStorageContext {
    private final Map<String, EntityContainer<?>> originalContainersCache = new ConcurrentHashMap();
    private final Map<String, EntityContainer<?>> containersCache = new ConcurrentHashMap();
    private final Set<EntityContainer<?>> deletedContainersCache = Collections.newSetFromMap(new ConcurrentHashMap());

    public <E extends BaseEntity> void putContainer(EntityReference<E> ref, EntityContainer<E> ctr) {
        this.containersCache.put(ref.getUid(), ctr);
    }

    <E extends BaseEntity> EntityContainer<E> getContainer(EntityReference<E> ref) {
        return this.containersCache.get(ref.getUid());
    }

    Collection<EntityContainer<?>> getAllContainers() {
        return this.containersCache.values();
    }

    <E extends BaseEntity> void putOriginalContainer(EntityReference<E> ref, EntityContainer<E> ctr) {
        this.originalContainersCache.put(ref.getUid(), ctr);
    }

    <E extends BaseEntity> void registerDeletedContainer(EntityContainer<E> ctr) {
        this.deletedContainersCache.add(ctr);
    }

    <E extends BaseEntity> EntityContainer<E> getOriginalContainer(EntityReference<E> ref) {
        return this.originalContainersCache.get(ref.getUid());
    }

    Map<String, EntityContainer<?>> getContainers() {
        return this.containersCache;
    }

    Map<String, EntityContainer<?>> getOriginalContainers() {
        return this.originalContainersCache;
    }

    Set<EntityContainer<?>> getDeletedContainers() {
        return this.deletedContainersCache;
    }
}

